package lu.tudor.santec.gecamed.formeditor.gui.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.formeditor.gui.controller.ColorChangeListener;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class GECAMedColorChooser extends JPanel {
	
	private static final long serialVersionUID = 1L;

	private Component parentComponent;
	
	private Color selectedColor = Color.WHITE;
	
	private JLabel colorPreview = new JLabel();
	
	private JButton chooser = new JButton();
	
	private List<ColorChangeListener> listener = new LinkedList<ColorChangeListener>();
	
	
	public GECAMedColorChooser (Component parent) {
		/* ======================================== */
		this(parent, "", Color.WHITE);
		/* ======================================== */
	}
	
	public GECAMedColorChooser (Component parent, String text) {
		/* ======================================== */
		this(parent, text, Color.WHITE);
		/* ======================================== */
	}
	
	public GECAMedColorChooser (Component parent, String text, Color startColor) {
		/* ======================================== */
		super(new BorderLayout());
		this.parentComponent = parent;
		this.setLayout(new BorderLayout());
		
		// define color preview
		colorPreview.setBackground(selectedColor = startColor);
		colorPreview.setOpaque(true);
//		colorPreview.setText("C");
		JPanel previewPanel = new JPanel(new FormLayout("2px, f:24px, 2px", "2px, f:24px, 2px"));
		previewPanel.setOpaque(false);
		previewPanel.add(colorPreview, new CellConstraints(2, 2));
		this.add(previewPanel, BorderLayout.WEST);
		
		// define the ColorChooser
		chooser.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				/* ======================================== */
				Color c = JColorChooser.showDialog(parentComponent, 
						Translatrix.getTranslationString("formeditor.chooseColor"), 
						selectedColor);
				if (c != null) {
					selectedColor = c;
					fireColorChanged(true);
				}
				/* ======================================== */
			}
		});
		this.setText(text);
		this.setToolTipText(text);
		this.add(chooser, BorderLayout.CENTER);
		/* ======================================== */
	}
	
	public void setColor (Color c) {
		/* ======================================== */
		this.selectedColor = c;
		fireColorChanged(false);
		/* ======================================== */
	}
	
	public Color getColor () {
		/* ======================================== */
		return selectedColor;
		/* ======================================== */
	}
	
	public void addColorChangeListener (ColorChangeListener l) {
		/* ======================================== */
		listener.add(l);
		/* ======================================== */
	}
	
	public void removeColorChangeListener (ColorChangeListener l) {
		/* ======================================== */
		listener.remove(l);
		/* ======================================== */
	}
	
	public void remvoeColorChangeListener (int index) {
		/* ======================================== */
		listener.remove(index);
		/* ======================================== */
	}
	
	public void removeAllColorChangeListener () {
		/* ======================================== */
		listener.clear();
		/* ======================================== */
	}
	
	
	public void setText(String text) {
		/* ======================================== */
		chooser.setText(text);
		/* ======================================== */
	}
	
	public String getText () {
		return chooser.getText();
	}
	
	public JButton getChooseButton () {
		/* ======================================== */
		return chooser;
		/* ======================================== */
	}
	
	private void fireColorChanged (boolean changedByAction) 
	{
		colorPreview.setBackground(selectedColor);
		
		for (ColorChangeListener l : listener) 
		{
			if (changedByAction)
				l.colorChangedByAction(selectedColor);
			l.colorChanged(selectedColor);
		}
	}
	
	/**
	 * Disables the button, to choose a color
	 */
	@Override
	public void setEnabled (boolean b) {
		/* ======================================== */
		chooser.setEnabled(b);
		/* ======================================== */
	}
}
