package lu.tudor.santec.gecamed.formeditor.gui.component;

/**
 * A JTextField, that only accepts numbers and empty String
 */

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;

import javax.swing.JTextField;
import javax.swing.text.Document;


public class NumericField extends JTextField 
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long serialVersionUID = 1L;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public NumericField (String text, boolean deciamlAllowed) 
	{
		super(new NumberDocument(deciamlAllowed), text, text.length());
		
		this.addFocusListener(new FocusListener() {
			public void focusLost(FocusEvent e) {
				/* ======================================== */
				if (NumericField.this.getText().endsWith(".")) {
					/* ---------------------------------------- */
					setText(getText().replace(".", ""));
					/* ---------------------------------------- */
				}
				
				String text = NumericField.this.getText();
				if (text.contains(".")) {
					while (text.endsWith("0")
							&& text.length() > 1
							&& text.charAt(text.length()-2) != '.') {
						/* ---------------------------------------- */
						text = text.substring(0, text.length()-1);
						/* ---------------------------------------- */
					}
					setText(text);
				}
				/* ======================================== */
			}
			
			public void focusGained(FocusEvent e) {}
		});
	}
	
	
	public NumericField (String text)
	{
		this(text, true);
	}
	
	
	public NumericField (Number value) 
	{
		this(String.valueOf(value), true);
	}
	
	
	public NumericField (double value) 
	{
		this(String.valueOf(value), true);
	}
	
	
	public NumericField (int value) 
	{
		this(String.valueOf(value), false);
	}
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	@Override 
	public void setText (String text) 
	{
		super.setText(text);
	}
	
	
	@Override
	public String getText()
	{
		return getDocument().toString();
	}
	
	
	/**
	 * This method is deprecated. Please use getDouble, getDecimal or getLong instead. 
	 */
	@Deprecated
	public double getValue ()
	{
		return getDouble();
	}
	
	
	public Long getLong ()
	{
		return getDocument().getLong();
	}
	
	
	public int getInt ()
	{
		Long l = getLong();
		return l != null ? l.intValue() : 0;
	}
	
	
	public BigDecimal getDecimal ()
	{
		return getDocument().getDecimal();
	}
	
	
	public double getDouble ()
	{
		Double d = getDocument().getDouble();
		return d != null ? d.doubleValue() : 0.0;
	}
	
	
	public void setValue (Number value) 
	{
		super.setText(value.toString());
	}
	
	
	public void setValue (double value) 
	{
		super.setText(String.valueOf(value));
	}
	
	
	public void allowDecimalValues (boolean allow)
	{
		getDocument().setDecimal(allow);
	}
	
	
	public boolean isDecimalValueAllowed ()
	{
		return getDocument().isDecimal();
	}
	
	
	@Override
	public void setDocument(Document doc)
	{
		if (doc instanceof NumberDocument)
			super.setDocument(doc);
	}
	
	
	@Override
	public NumberDocument getDocument()
	{
		return (NumberDocument) super.getDocument();
	}
}
