package lu.tudor.santec.gecamed.formeditor.gui.component;

import javax.swing.event.CaretListener;

import lu.tudor.santec.org.fife.ui.autocomplete.AutoCompletion;
import lu.tudor.santec.org.fife.ui.autocomplete.CompletionProvider;

import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

import com.l2fprod.common.swing.JLinkButton;

public class ScriptLink extends JLinkButton {
	/**
	 * @author Jens Ferring
	 * 
	 * This is a JLinkButton that additionally stores the key, the type and the script of, 
	 * that shall be editable, if clicked.
	 */
	private static final long serialVersionUID = 1L;
	
	private String key;
	private int type;
	private RSyntaxTextArea editor = new RSyntaxTextArea();
	private boolean hasListener = false;
	
	public ScriptLink (String name, String text, int type, CompletionProvider provider) {
		super(name);
		editor.setText(text);
		initEditor(provider);
		key = name;
		this.type = type;
		setName(key);
	}
	
	private void initEditor (CompletionProvider provider) {
		editor.setSyntaxEditingStyle(RSyntaxTextArea.SYNTAX_STYLE_JAVASCRIPT);
		editor.setMarkOccurrences(true);
		editor.setTabSize(4);
		AutoCompletion ac = new AutoCompletion(provider);
		ac.install(editor);
	}
	
	public void setKey(String key) {
		this.key = key;
	}
	public String getKey() {
		return key;
	}
	public void setScript(String script) {
		editor.setText(script);
	}
	public String getScript() {
		return editor.getText();
	}
	public int getType () {
		return type;
	}
	public RSyntaxTextArea getEditor () {
		return editor;
	}
	public void addCaretListener(CaretListener l) {
		if (!hasListener) {
			hasListener = true;
			editor.addCaretListener(l);
		}
	}
	public void setName (String name) {
		super.setName(name+"()");
	}
}
