package lu.tudor.santec.gecamed.formeditor.gui.component;

import javax.swing.JComponent;
import javax.swing.JPanel;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;

public abstract class SettingsBasePanel extends JPanel
{
	/* ======================================== */
	// 		FINAL MEMBERS
	/* ======================================== */
	
	private static final long 	serialVersionUID = 1L;
	private static final String	DEFAULT_COL_SPEC = "f:154px";
	
	protected static final RowSpec 	DEFAULT_ROW_SPEC = new RowSpec(RowSpec.FILL, 	Sizes.PREFERRED,RowSpec.NO_GROW);
	protected static final RowSpec 	SPACER_ROW_SPEC	 = new RowSpec(RowSpec.DEFAULT, Sizes.DLUY2, 	RowSpec.NO_GROW);
	protected static final CellConstraints CC 		 = new CellConstraints();
	

	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	protected EditableComponent editableComponent;
	protected FormLayout 		layout;
	
	

	/* ======================================== */
	// 		CONSTRUCTOR
	/* ======================================== */
	
	public SettingsBasePanel(EditableComponent editableComponent)
	{
		this.editableComponent 	= editableComponent;
		layout 					= new FormLayout(DEFAULT_COL_SPEC);
		
		this.setLayout(layout);
		this.setOpaque(false);
		init();
	}
	
	
	
	/* ======================================== */
	// 		HELP METHODS
	/* ======================================== */
	
	/**
	 * Appends a new row and a component into this row. 
	 * Afterwards a row as spacer to the next row is appended.
	 *  
	 * @param c the component to add
	 */
	public void appendRow (JComponent c)
	{
		appendRow(c, DEFAULT_ROW_SPEC);
	}
	
	/**
	 * Appends a new row and a component into this row. 
	 * Afterwards a row as spacer to the next row is appended.
	 *  
	 * @param c the component to add
	 * @param rowSpec the specification of the row to enter the column
	 */
	public void appendRow (JComponent c, RowSpec rowSpec)
	{
		layout.appendRow(rowSpec);
		
		int size = layout.getRowCount();
		this.add(c, CC.xy(1, size));
		
		layout.appendRow(SPACER_ROW_SPEC);
	}
	
	
	
	/* ======================================== */
	// 		ABSTRACT METHODS
	/* ======================================== */

	/**
	 * Initializes the panel by creating and adding all the components
	 */
	protected abstract void init ();
}
