package lu.tudor.santec.gecamed.formeditor.gui.controller;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: AbstractListener.java,v $
 * <br>Revision 1.7  2012-11-22 15:39:08  ferring
 * <br>test
 * <br>
 */
public abstract class AbstractListener implements ActionListener, CaretListener, MouseListener, 
		KeyListener, PropertyChangeListener, ChangeListener, ListSelectionListener, TableModelListener {
	
	protected Object[] array;
	
	
	public AbstractListener (Object ... array) {
		/* ======================================== */
		this.array = array;
		/* ======================================== */
	}

	public void actionPerformed(ActionEvent e) {}
	public void caretUpdate(CaretEvent e) {}
	public void mouseClicked(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
	public void keyPressed(KeyEvent e) {}
	public void keyReleased(KeyEvent e) {}
	public void keyTyped(KeyEvent e) {}
	public void propertyChange(PropertyChangeEvent e) {}
	public void stateChanged(ChangeEvent e) {}
	public void valueChanged(ListSelectionEvent e) {}
	public void tableChanged(TableModelEvent e) {}
	
	
	public Object get() {
		/* ======================================== */
		return get(0);
		/* ======================================== */
	}
	
	public Object get(int index) {
		/* ======================================== */
		if (array.length > index) {
			return array[index];
		} else {
			return null;
		}
		/* ======================================== */
	}
}
