package lu.tudor.santec.gecamed.formeditor.gui.controller;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JComponent;
import javax.swing.TransferHandler;

import lu.tudor.santec.gecamed.formeditor.gui.FormEditorModule;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableComponent;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormEditorModel;

public class EditorPanelController implements MouseListener {
	
	/**
	 * @author Jens Ferring
	 * 2009-11-17
	 * 
	 * This Controller listens to the mouse events of the edit panel. It enables the hover effects.
	 */
	
	private FormEditorModel model;
	private FormEditorModule view;
	private EditableComponent hoveredComponent;
	
	public EditorPanelController (FormEditorModel model) {
		this.model = model;
		view = model.getView();
	}

	
	/**
	 * The mouse entered a component. The name of the hovered component is get by the MouseEvent, 
	 * and it's used to get the component from the model. The method startHover (which changes the 
	 * background color of the component) is executed on the Component and the editor panel is 
	 * repainted (NOT rearranged)
	 */
	public void mouseEntered(MouseEvent e) {
		hoveredComponent = view.getComponent(((JComponent)e.getSource()).getName());
		if (hoveredComponent != null) {
			hoveredComponent.startHover();
//			view.repaintEditPanel();
			hoveredComponent.repaint();
		}
	}
	
	/**
	 * The mouse exited the component. The background color will be reset to what it was before.
	 */
	public void mouseExited(MouseEvent e) {
		resetBackground();
	}
	
	
	/**
	 * Makes the component draggable (only "real"-components are draggable)
	 * 
	 * The component is clicked. This method is used for a clicked, because the DnD blocks the 
	 * click method (the click method isn't called since the DnD was enabled for a component).
	 * The background will be reset, to have the right color, when the selection is removed and 
	 * the component is set as currently selected in the model.
	 */
	public void mousePressed(MouseEvent e) 
	{
		if (e.getButton() == MouseEvent.BUTTON1)
//		if (!e.isPopupTrigger())
		{
			// only drag, if button 1 is pressed
			JComponent c = (JComponent)e.getSource();
			TransferHandler handler = c.getTransferHandler();
			
			if (handler != null) 
				handler.exportAsDrag(c, e, TransferHandler.COPY);
		}
		
		if (model.getCurrentlySelectedComponent() == null
				|| !((JComponent)e.getSource()).getName().equals(
						model.getCurrentlySelectedComponent().getName())) 
		{
			// only update if a new component is chosen
			resetBackground();
			String name = ((JComponent)e.getSource()).getName();
			model.update(view.getComponent(name), false);
		}
	}
	
	
	/**
	 * resets the background of the currently hovered component and rearranges the edit panel
	 */
	private void resetBackground() 
	{
		if (hoveredComponent != null) {
			hoveredComponent.stopHover();
			hoveredComponent.repaint();
			hoveredComponent = null;
//			view.repaintEditPanel();
		}
	}	

	// =====  UNUSED LISTENER-METHODS  =====
	public void mouseReleased(MouseEvent e) {}
	public void mouseClicked(MouseEvent e) {}
}
