package lu.tudor.santec.gecamed.formeditor.gui.controller;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

import lu.tudor.santec.gecamed.formeditor.gui.FormEditorModule;




public class FormSplitPaneController implements ActionListener, PropertyChangeListener, MouseListener
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final int 	DIVIDER_SIZE 				= 5;
	private static final double DEFAULT_DIVIDER_PROPORTION 	= 0.6;
	private static final int 	BUTTON_SIZE 				= 7;
	
	private static final Color 	BUTTON_HOVER_COLOR 			= Color.ORANGE;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private JSplitPane 	splitPane;
	private JTabbedPane formTabs;
	
	private JButton 	pushUpButton;
	private JButton 	pullDownButton;
	private Color 		buttonDefaultColor;
	
	private JPanel 		topPanel;
	private JPanel 		bottomPanel;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public FormSplitPaneController (JTabbedPane tabbedPane)
	{
		formTabs = tabbedPane;
		formTabs.addPropertyChangeListener(this);
		
		// create & define the SPLIT PANE
		splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
		splitPane.setDividerLocation(DEFAULT_DIVIDER_PROPORTION);
		splitPane.setOneTouchExpandable(false);
		splitPane.setDividerSize(DIVIDER_SIZE);
		splitPane.setContinuousLayout(false);
		splitPane.setOpaque(false);
		
		// create & define the PANELs
		topPanel 	= new JPanel(new BorderLayout());
		topPanel.setOpaque(false);
		splitPane.add(topPanel, JSplitPane.TOP);
		
		bottomPanel = new JPanel(new BorderLayout());
		bottomPanel.setOpaque(false);
		splitPane.add(bottomPanel, JSplitPane.BOTTOM);
		
		// create & define the BUTTONs
		Component 	divider 		= getDivider();
		Color 		dividerColor 	= divider.getBackground();
		
		buttonDefaultColor 	= new Color(dividerColor.getRGB());
		
		pushUpButton 	= new JButton(FormEditorModule.getIcon("arrow_up.png"));
		pushUpButton.setMaximumSize	 (new Dimension(pushUpButton.getMaximumSize().width, 	BUTTON_SIZE));
		pushUpButton.setPreferredSize(new Dimension(pushUpButton.getPreferredSize().width,	BUTTON_SIZE));
		pushUpButton.setBackground(buttonDefaultColor);
		pushUpButton.setBorder(BorderFactory.createEmptyBorder());
		pushUpButton.setOpaque(true);
		pushUpButton.addActionListener(this);
		pushUpButton.addMouseListener(this);
		topPanel.add(pushUpButton, BorderLayout.SOUTH);
		
		pullDownButton 	= new JButton(FormEditorModule.getIcon("arrow_down.png"));
		pullDownButton.setMaximumSize 	(new Dimension(pushUpButton.getMaximumSize().width, 	BUTTON_SIZE));
		pullDownButton.setPreferredSize (new Dimension(pushUpButton.getPreferredSize().width, 	BUTTON_SIZE));
		pullDownButton.setBackground(buttonDefaultColor);
		pullDownButton.setBorder(BorderFactory.createEmptyBorder());
		pullDownButton.setOpaque(true);
		pullDownButton.addActionListener(this);
		pullDownButton.addMouseListener(this);
		bottomPanel.add(pullDownButton, BorderLayout.NORTH);
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public void showUp ()
	{
		splitPane.setDividerLocation(DEFAULT_DIVIDER_PROPORTION);
//		splitPane.setDividerLocation(0.0);
	}
	
	
	
	/* ======================================== */
	// 		GETTER & SETTER
	/* ======================================== */
	
	public JSplitPane getSplitPane ()
	{
		return this.splitPane;
	}
	
	
	public void setTopComponent (Component c)
	{
		topPanel.add(c, BorderLayout.CENTER);
	}
	
	
	public void setBottomComponent (Component c)
	{
		bottomPanel.add(c, BorderLayout.CENTER);
	}
	
	
	
	/* ======================================== */
	// 		LISTENER EVENTS
	/* ======================================== */
	
	public void propertyChange(PropertyChangeEvent evt)
	{
		int tabCount 			= formTabs.getTabCount();
		int dividerLocation 	= splitPane.getDividerLocation();
		int lastDividerLocation = splitPane.getLastDividerLocation();
		int minDividerLocation 	= DIVIDER_SIZE;

		if (tabCount <= 0)
			splitPane.setDividerLocation(0);
		else if (dividerLocation <= minDividerLocation)
			/* activate the following line, if the split pane shall not be resized
			 * every time a form is opened, but only if there was no form opened before.
			 */
//				&& tabCount == 1)  
		{
			int maxDividerLocation 	= splitPane.getHeight() - DIVIDER_SIZE;
			
			if (		lastDividerLocation <= minDividerLocation
					||  lastDividerLocation >= maxDividerLocation)
				lastDividerLocation = (int)(maxDividerLocation * DEFAULT_DIVIDER_PROPORTION);
			
			splitPane.setDividerLocation(lastDividerLocation);
		}
	}


	public void actionPerformed(ActionEvent e)
	{
		Object source 			= e.getSource();
		int dividerLocation 	= splitPane.getDividerLocation();
		int minDividerLocation 	= DIVIDER_SIZE;
		int maxDividerLocation 	= splitPane.getHeight() - DIVIDER_SIZE;
		int lastDividerLocation = splitPane.getLastDividerLocation();
		
		if (		lastDividerLocation <= minDividerLocation
				||  lastDividerLocation >= maxDividerLocation)
			lastDividerLocation = (int)(maxDividerLocation * DEFAULT_DIVIDER_PROPORTION);
		
		if (source == pushUpButton)
			if (dividerLocation >= maxDividerLocation)
				 splitPane.setDividerLocation(lastDividerLocation);
			else splitPane.setDividerLocation(0.0);
		else if (source == pullDownButton)
			if (dividerLocation <= minDividerLocation)
				 splitPane.setDividerLocation(lastDividerLocation);
			else splitPane.setDividerLocation(1.0);
	}
	
	
	public void mouseEntered (MouseEvent e) 
	{
		JButton button = (JButton) e.getSource();
		button.setBackground(BUTTON_HOVER_COLOR);
	}
	
	
	public void mouseExited  (MouseEvent e) 
	{
		JButton button = (JButton) e.getSource();
		button.setBackground(buttonDefaultColor);
	}
	
	
	// unused listener events
	public void mouseClicked(MouseEvent e) {}
	public void mousePressed (MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
	
	
	
	/* ======================================== */
	// 		HELP METHODS
	/* ======================================== */
	
	private Component getDivider ()
	{
		for (Component c : splitPane.getComponents())
		{
			if (c instanceof BasicSplitPaneDivider)
				return c;
		}
		return null;
	}
}
