package lu.tudor.santec.gecamed.formeditor.gui.controller.converter;

import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.XSLTemplate;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.xslfo.TransFOmer;
import lu.tudor.santec.gecamed.formeditor.ejb.entity.beans.FormTemplate;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableComponent;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormModel;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.w3c.dom.Node;

public class HistoryHtmlHandler extends FormDataConverter
{
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(HistoryHtmlHandler.class.getName());
	
	private static final String OPEN_INFO = "This method is not implemented, " +
			"because this class is not supposed to open or print, but to show form in the history.";

	public HistoryHtmlHandler(FormModel model)
	{
		super(model);
	}
	
	
	@Override
	public void open(XSLTemplate xslTemplate)
	{
		logger.info(OPEN_INFO);
	}
	
	@Override
	public void edit(XSLTemplate xslTemplate)
	{
		logger.info(OPEN_INFO);
	}
	
	
	@Override
	public void print(XSLTemplate xslTemplate)
	{
		logger.info(OPEN_INFO);
	}
	
	
	public String createHistoryHtml () throws Exception
	{
		FormTemplate 	template 	= model.getTemplate();
		Physician 		physician 	= MainFrame.getCurrentPhysician();
		XSLTemplate 	xsl 		= template.getHistoryTemplates(physician);
		String 			html;
		TransFOmer 		transFOmer;
		Node 			templateNode;
		Node 			dataNode;
		
		createXmlOfModel(TYPE_HISTORY);
		
		if (xsl == null)
			 html 			= createDefaultHistoryHtml();
		else
		{
			transFOmer 		= TransFOmer.getInstance();
			templateNode 	= transFOmer.loadXMLFrom(xsl.getData());
			dataNode 		= transFOmer.loadXMLFrom(new Document(root));
			html 			= new String(transFOmer.transFO(dataNode, templateNode, TransFOmer.HTML_FORMAT), TransFOmer.UTF8);
		}
		
		return html;
	}


	private String createDefaultHistoryHtml ()
	{
		Collection<EditableComponent> components = model.getEditableComponents().values();
		
		// order the history texts by the history index
		SortedMap<Float, String> historyTextMap = new TreeMap<Float, String>();
		
		StringBuffer historyText;
		String 		 text;
		for (EditableComponent c : components) 
		{
			if (!c.isShowInHistory())
				continue;
			
			text = c.getHistoryText();
			if (text == null
					|| text.equals(""))
				continue;
			
			historyText = new StringBuffer("<br>")
					.append(c.getDescription())
					.append("<i>")
					.append(text)
					.append("</i>");
			
			Float key = c.getHistoryIndex();
			if (historyTextMap.get(key) == null)
				// just put the history text into the map
				historyTextMap.put(key, historyText.toString());
			else
				// append the new history text to the already existing one 
				historyTextMap.put(key, historyText.insert(0, historyTextMap.get(key)).toString());
		}
		
		/* get the description and values from the components, 
		 * that are supposed to be entered into the history
		 * append the sorted history texts
		 */ 
		StringBuffer description = new StringBuffer("<b>")
				.append(model.getTemplate().getName())
				.append("</b>");
		
		for (String entry : historyTextMap.values()) 
			description.append(entry);
		
		return description.toString();
	}
}
