package lu.tudor.santec.gecamed.formeditor.gui.exception;

import javax.swing.JComponent;
import javax.swing.JLabel;

import lu.tudor.santec.gecamed.formeditor.gui.FormWidgets;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableComponent;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class NotProperInitializedException extends Exception {
	
	private static final long serialVersionUID = 1L;
	
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(NotProperInitializedException.class.getName());

	public NotProperInitializedException (String cause) {
		super ("The Component wasn't properly initialized because of the following reasen:" +
				FormWidgets.NEWLINE + cause);
	}
	
	public static void testEditableComponent (EditableComponent ec) {

		// test, if type is correct
		int type = ec.getType();
		
		switch (type) {
		case EditableComponent.BORDER_COMPONENT:
		case EditableComponent.DUMMY_COMPONENT:
		case EditableComponent.FINAL_COMPONENT:
		case EditableComponent.REAL_COMPONENT:
			break;
		default:
			try {
				throw new NotProperInitializedException("The type of the JComponent is not one of the pre-defined. " +
						"Type is " + type + ", but can be " 
						+ EditableComponent.BORDER_COMPONENT + ", "
						+ EditableComponent.DUMMY_COMPONENT + ", "
						+ EditableComponent.FINAL_COMPONENT + " or "
						+ EditableComponent.REAL_COMPONENT + ".");
			} catch (NotProperInitializedException e) {
				logger.log(Level.ERROR, e.getMessage(), e);
//				ec.setType(EditableComponent.DUMMY_COMPONENT);
			}
		}
		
		// test, if component is not NULL
		JComponent component = ec.getComponent();
		
		if (component == null) {
			try {
				throw new NotProperInitializedException("The JComponent is NULL. " +
						"It should has been initialized in the sub-class constructor");
			} catch (NotProperInitializedException e) {
				logger.log(Level.ERROR, e.getMessage(), e);
				ec.setComponent(new JLabel());
			}
		}
	}
}
