package lu.tudor.santec.gecamed.formeditor.gui.model;


public class ComboBoxElement<T> implements Comparable<Object> {
	
	/**
	 * @author Jens Ferring
	 * 
	 * This is just to have a class, where 2 strings and an integer can be saved. 
	 * Objects of this class are mainly used for comboBoxes. 
	 * Primary, the objects where used to select the format of a row / column only.
	 * The toString method on this class delivers the translation. 
	 */
	private T[] 	value;
	private String 	translation;
	
	public ComboBoxElement (String translation, T ... value) 
	{
		this.translation = translation;
		this.value = value;
	}

	
	public T getValue() 
	{
		return value[0];
	}
	
	public void setValue(T value) 
	{
		this.value[0] = value;
	}

	public T getValue(int index) 
	{
		return value[index];
	}
	
	public void setValue(T value, int index) 
	{
		this.value[index] = value;
	}
	
	public T[] getValues () 
	{
		return value;
	}
	
	public String getTranslation() 
	{
		return translation;
	}
	
	public void setTranslation(String translation) 
	{
		this.translation = translation;
	}
	
	public String toString () 
	{
		String s = getTranslation();
		if (s != null) {
			return s;
		} else {
			return "";
		}
	}
	
	
	public int compareTo(Object e) 
	{
		return this.toString().compareTo(e.toString());
	}
	
	@Override
	public boolean equals(Object otherElement) 
	{
		if (otherElement == null)
		{
			return false;
		}
		else if (otherElement instanceof ComboBoxElement<?>) 
		{
			if (!otherElement.toString().equals(this.toString())) 
				return false;
			
			if (value == null)
				return ((ComboBoxElement<?>) otherElement).getValues() == null;
			
			Object[] objects = ((ComboBoxElement<?>)otherElement).getValues();
			if (value.length != objects.length) 
				return false;
			
			for (int index = 0; index < value.length; index++) 
			{
				if (objects[index] == null) 
				{
					if (value[index] == null) 
						continue;
					else 
						return false;
				}
				
				if (!objects[index].equals(value[index])) 
					return false;
			}
			
			return true;
		} 
		else if (otherElement instanceof String)
		{
			return this.toString().equals(otherElement);
		}
		else
		{
			if (this.value.length == 1 
					&& this.getValue() != null)
				return this.getValue().equals(otherElement);
			else
				return false;
		}
	}
}
