package lu.tudor.santec.gecamed.formeditor.gui.model;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.AbstractListModel;

public class DynamicListModel<T> extends AbstractListModel {
	private static final long serialVersionUID = 1L;
	
	private Vector<T> data;
	
	
	public DynamicListModel () {
		this(new Vector<T>());
	}
	
	public DynamicListModel (Vector<T> data) {
		/* ======================================== */
		this.data = data;
		/* ======================================== */
	}
	
	
	public Vector<T> getData () {
		return data;
	}
	
	public void setData (Collection<T> newData) {
		this.data.clear();
		this.data.addAll(data);
		this.fireContentsChanged(this, 0, getSize());
	}
	
	public void addAll (Collection<T> newData) {
		int startIndex = getSize();
		this.addAll(newData);
		this.fireContentsChanged(this, startIndex, getSize());
	}
	
    public int getSize() {
    	return data.size();
    }

    
    public T getElementAt(int index) {
    	return data.elementAt(index);
    }

    public boolean isEmpty() {
    	return data.isEmpty();
    }
    
    public Enumeration<T> elements() {
    	return data.elements();
    }

    public boolean contains(T elem) {
    	return data.contains(elem);
    }
    
    public void setElementAt(T obj, int index) {
		data.setElementAt(obj, index);
		fireContentsChanged(this, index, index);
    }
    
    public void removeElementAt(int index) {
		data.removeElementAt(index);
		fireIntervalRemoved(this, index, index);
    }
    
    public void insertElementAt(T obj, int index) {
		data.insertElementAt(obj, index);
		fireIntervalAdded(this, index, index);
    }
    
    public void addElement(T obj) {
		int index = data.size();
		data.addElement(obj);
		fireIntervalAdded(this, index, index);
    }
    
    public boolean removeElement(T obj) {
		int index = data.indexOf(obj);
		boolean rv = data.removeElement(obj);
		if (index >= 0) {
		    fireIntervalRemoved(this, index, index);
		}
		return rv;
    }
    
    public void removeAllElements() {
		int index1 = data.size()-1;
		data.removeAllElements();
		if (index1 >= 0) {
		    fireIntervalRemoved(this, 0, index1);
		}
    }

    public String toString() {
	   return data.toString();
	}


    /* The remaining methods are included for compatibility with the
     * Java 2 platform Vector class.
     */

    public T get(int index) {
    	return data.elementAt(index);
    }

    public T set(int index, T element) {
		T rv = data.elementAt(index);
		data.setElementAt(element, index);
		fireContentsChanged(this, index, index);
		return rv;
    }

    public void add(int index, T element) {
		data.insertElementAt(element, index);
		fireIntervalAdded(this, index, index);
    }

    public T remove(int index) {
		T rv = data.elementAt(index);
		data.removeElementAt(index);
		fireIntervalRemoved(this, index, index);
		return rv;
    }

    public void clear() {
		int index1 = data.size()-1;
		data.removeAllElements();
		if (index1 >= 0) {
		    fireIntervalRemoved(this, 0, index1);
		}
    }

    
    public void removeRange(int fromIndex, int toIndex) {
		if (fromIndex > toIndex) {
		    throw new IllegalArgumentException("fromIndex must be <= toIndex");
		}
		for(int i = toIndex; i >= fromIndex; i--) {
		    data.removeElementAt(i);
		}
		fireIntervalRemoved(this, fromIndex, toIndex);
    }
}
