package lu.tudor.santec.gecamed.formeditor.gui.view;

import javax.swing.JPanel;

import lu.tudor.santec.gecamed.formeditor.gui.FormEditorModule;
import lu.tudor.santec.gecamed.formeditor.gui.controller.converter.FormDataConverter;
import lu.tudor.santec.gecamed.formeditor.gui.controller.converter.FormDataConverterChooser;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class FormEditorSettingsPlugin extends SettingsPlugin
{
	/* ======================================== */
	// 		FINAL MEMBERS
	/* ======================================== */
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * choose the handler to print forms with
	 */
	public static final String PRINTER_FORM_HANDLER = "PRINTER_FORM_HANDLER";

	public static final String NAME 				= "formEditorSettings";
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private FormDataConverterChooser handlerChooser;
	
	private JPanel printOptionSubPanel;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTOR
	/* ======================================== */
	
	public FormEditorSettingsPlugin()
	{
		super(NAME);
		this.setStationaryValues();
		printOptionSubPanel = createSubPanel(Translatrix.getTranslationString("formeditor.formEditorSettings"));
		addSubPanel(printOptionSubPanel);
		printOptionSubPanel.setLayout(new FormLayout("f:p:g", "p"));
		this.buildPanel();
	}
	
	
	
	/* ======================================== */
	// 		MEHTODS
	/* ======================================== */

	private void buildPanel ()
	{
		CellConstraints cc = new CellConstraints();
		
		this.setLabel(Translatrix.getTranslationString("formeditor.formeditor"));
		this.setIcon(FormEditorModule.getIcon(FormEditorModule.FORMEDITOR_ICON));
		
		this.handlerChooser = new FormDataConverterChooser();
		
		printOptionSubPanel.removeAll();
		printOptionSubPanel.add(handlerChooser, cc.xy(1, 1));
	}
	
	private void setStationaryValues ()
	{
		setStationary(PRINTER_FORM_HANDLER, FormDataConverter.NO_HANDLER_OPTION);
	}
	
	
	/* ======================================== */
	// 		OVERRIDDEN METHODS
	/* ======================================== */
	
	@Override
	public void relocalize()
	{
		this.setLabel(Translatrix.getTranslationString("formeditor.formeditor"));
		super.relocalize();
		handlerChooser.relocalize();
	}
	
	@Override
	public void revertToDefaults()
	{
		this.handlerChooser.setSelectedValue((Integer) getDefault(PRINTER_FORM_HANDLER));
		reflectSettings();
		super.revertToDefaults();
	}
	
	@Override
	public void reflectSettings()
	{
		super.reflectSettings();
		this.handlerChooser.setSelectedValue((Integer) getValue(PRINTER_FORM_HANDLER));
	}
	
	@Override
	public void updateSettings()
	{
		setValue(PRINTER_FORM_HANDLER, this.handlerChooser.getSelectedValue());
		super.updateSettings();
	}
}
