package lu.tudor.santec.gecamed.formeditor.gui.view;

import java.awt.Component;

import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.utils.LineColorListRenderer;
import lu.tudor.santec.gecamed.formeditor.ejb.entity.beans.FormTemplate;

public class FormTemplateListRenderer extends LineColorListRenderer {
	
	private static final long serialVersionUID = 1L;

	// Creates the look for an entry in the template list
	public Component getListCellRendererComponent(JList list, Object value,
			int index, boolean isSelected, boolean cellHasFocus) {
		/* ======================================== */
		// Icon for the template, corresponding to the type
		Icon icon = GECAMedModule.getIcon(GECAMedIconNames.TEMPLATE);
		
		FormTemplate template = (FormTemplate) value;
		
		StringBuffer text = new StringBuffer("<html><font size=3><b>");
		text.append(template.getName());
		text.append("</font>");
		
		String version = template.getVersion();
		if (version != null && version.length() > 0) {
			/* ---------------------------------------- */
			if (version.length() > 32) {
				version = version.substring(0, 29) + "...";
			}
			text.append("<font size=2> (");
			text.append(version);
			text.append(")");
			/* ---------------------------------------- */
		}
		String description = template.getDescription();
		if (description != null && description.length() > 0) {
			/* ---------------------------------------- */
			if (description.length() > 64) {
				description = description.substring(0, 61) + "...";
			}
			text.append("<br />");
			/* ---------------------------------------- */
		}
		
		JLabel label = (JLabel) super.getListCellRendererComponent(list, text,
				index, isSelected, cellHasFocus);
		label.setIcon(icon);

		return label;
		/* ======================================== */
	}
}
