package lu.tudor.santec.gecamed.formeditor.gui.view.dialog;

import java.awt.Container;
import java.awt.Window;
import java.util.Calendar;
import java.util.GregorianCalendar;

import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormModel;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.toedter.calendar.JDateChooser;

public class ChangeCreationDateDialog {
	
	private GECAMedBaseDialogImpl dialog;
	
	private JSpinner hoursSpinner;
	private JSpinner minutesSpinner;
	private JSpinner secondSpinner;
	private JDateChooser dateChooser;
	
	public ChangeCreationDateDialog (Container parent) {
		/* ======================================== */
		
		JPanel mainPanel = new JPanel(new FormLayout(
				"5px:g, 120px, 5px, 20dlu, p, 20dlu, p, 20dlu, p, 5px:g", 
				"5px:g(1.3), f:p, 10px, f:p, 5px:g(0.7)"));
		CellConstraints cc = new CellConstraints();
		
		JLabel headline = new JLabel("<html>" +
				"<font color=red><i>" + 
				Translatrix.getTranslationString("formeditor.change_creation_date_warning") 
				+ "</i></font><br><br>" +
				Translatrix.getTranslationString("formeditor.change_creation_date_msg"));
		mainPanel.add(headline, cc.xyw(2, 2, 8));
		
		
		dateChooser =  GECAMedGuiUtils.getDateChooser(false);
		mainPanel.add(dateChooser, cc.xy(2, 4));
		
		hoursSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 23, 1));
		mainPanel.add(hoursSpinner, cc.xy(4, 4));
		
		JLabel seperateLabel = new JLabel(":");
		mainPanel.add(seperateLabel, cc.xy(5, 4));

		minutesSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
		mainPanel.add(minutesSpinner, cc.xy(6, 4));
		
		JLabel seperate2Label = new JLabel(":");
		mainPanel.add(seperate2Label, cc.xy(7, 4));

		secondSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
		mainPanel.add(secondSpinner, cc.xy(8, 4));
		
		JLabel clockLabel = new JLabel(" " + 
				Translatrix.getTranslationString("formeditor.oclock"));
		mainPanel.add(clockLabel, cc.xy(9, 4));
		
		Window w = GECAMedBaseDialog.getParentWindow(parent);
		if (w instanceof JDialog)
			this.dialog = new GECAMedBaseDialogImpl((JDialog) w, 
					Translatrix.getTranslationString("formeditor.change_creation_date_title"), 
					GECAMedBaseDialogImpl.OK_CANCEL_BUTTON_MODE, mainPanel);
		else
			this.dialog = new GECAMedBaseDialogImpl((JFrame) w, 
					Translatrix.getTranslationString("formeditor.change_creation_date_title"), 
					GECAMedBaseDialogImpl.OK_CANCEL_BUTTON_MODE, mainPanel);
		/* ======================================== */
	}
	
	public void openChangeCreationDialog (FormModel formModel) {
		/* ======================================== */
		Calendar cal = new GregorianCalendar();
		cal.setTime(formModel.getForm().getDateCreated());

		this.dateChooser.setDate(cal.getTime());
		this.hoursSpinner.setValue(cal.get(Calendar.HOUR_OF_DAY));
		this.minutesSpinner.setValue(cal.get(Calendar.MINUTE));
		this.secondSpinner.setValue(cal.get(Calendar.SECOND));
		
		dialog.setSize(350, 230);
//		dialog.pack();
//		dialog.pack();
//		dialog.pack();
		
		int buttonPressed = dialog.showCenteredDialog();
		
		if (buttonPressed == GECAMedBaseDialog.CANCEL_OPTION) {
			return;
		}
		
		cal.setTime(dateChooser.getDate());
		cal.set(Calendar.HOUR_OF_DAY, (Integer)hoursSpinner.getValue());
		cal.set(Calendar.MINUTE, (Integer)minutesSpinner.getValue());
		cal.set(Calendar.SECOND, (Integer)secondSpinner.getValue());
		
		formModel.setDateCreated(cal.getTime());
		
		formModel.setModified(true);
		/* ======================================== */
	}
}
