package lu.tudor.santec.gecamed.formeditor.gui.view.dialog;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.formeditor.ejb.entity.beans.FormTemplate;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormEditorModel;
import lu.tudor.santec.gecamed.formeditor.gui.view.FormTemplateListRenderer;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class SelectFormDialog extends GECAMedBaseDialogImpl 
{
	private static final long serialVersionUID = 1L;
	
	private JList formList;
	
	
	public SelectFormDialog(FormEditorModel model)
	{
		super(MainFrame.getInstance(), 
				Translatrix.getTranslationString("formeditor.templateListHeadline"), 
				OK_CANCEL_BUTTON_MODE, new JPanel());
		
		JLabel descriptionLabel = new JLabel (
				Translatrix.getTranslationString(""));
		
		formList = new JList(model.getTemplateListModel());
		formList.setCellRenderer(new FormTemplateListRenderer());
		formList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		formList.addMouseListener(new MouseListener()
		{
			public void mouseReleased(MouseEvent e) {}
			public void mousePressed(MouseEvent e) {}
			public void mouseExited(MouseEvent e) {}
			public void mouseEntered(MouseEvent e) {}
			
			
			public void mouseClicked(MouseEvent e)
			{
				if (!e.isPopupTrigger() && e.getClickCount() >= 2)
					okActionCalled();
			}
		});
		
		JScrollPane listScroller = new JScrollPane(formList);
		
		CellConstraints cc = new CellConstraints();
		
		mainPanel.setLayout(new FormLayout(
				"5px, f:p:g, 5px", 
				"5px, f:p, 5px, f:p, 5px"));
		mainPanel.add(descriptionLabel, cc.xy(2, 2));
		mainPanel.add(listScroller, 	cc.xy(2, 4));
	}
	
	
	@Override
	public void setVisible(boolean b)
	{
		if (b)
		{
			pack();
			setLocationRelativeTo(getOwner());
		}
			
		super.setVisible(b);
	}
	
	
	public FormTemplate getSelectedForm ()
	{
		return (FormTemplate) formList.getSelectedValue();
	}
}
