package lu.tudor.santec.gecamed.formeditor.gui.view.dialog;

import java.awt.Component;

import lu.tudor.santec.gecamed.formeditor.gui.model.ComboBoxElement;
import lu.tudor.santec.i18n.Translatrix;

public class StaticDataCSVImportDialog extends FormEditorCSVImportDialog {

	public StaticDataCSVImportDialog(Component parent) {
		super(parent, 
				Translatrix.getTranslationString("formeditor.importCsvFile"),
				Translatrix.getTranslationString("formeditor.importStaticCurvesDescription"));
	}
	
	
	@Override
	protected boolean checkMapping () {
		/* ======================================== */
		if (!super.isFileLoaded()) {
			warningLabel.setText("");
			
			return false;
		}
		
		// are any columns assigned to x and y value
		boolean xMapped = false;
		boolean yMapped = false;
				
		for (ComboBoxElement<?> elem : columnMap.values()) {
			
			if (elem == null 
					|| elem.getTranslation() == null
					|| elem.getTranslation().equals("")) {
				continue;
			}
			
			if ("x".equals(elem.getTranslation())) {
				if (xMapped) {
					/* x was already assigned to another column, 
					 * but may only be assigned to one column
					 */
					this.warningLabel.setText(
							Translatrix.getTranslationString("formeditor.duplicateEntryForStaticChart"));
					return false;
				} else { 
					// this column is assigned to x
					xMapped = true;
				}
			} else if ("y".equals(elem.getTranslation())) {
				if (yMapped) {
					/* y was already assigned to another column, 
					 * but may only be assigned to one column
					 */
					this.warningLabel.setText(
							Translatrix.getTranslationString("formeditor.duplicateEntryForStaticChart"));
					return false;
				} else { 
					// this column is assigned to y
					yMapped = true;
				}
			}
		}
		

		
		if (xMapped && yMapped)
			// every thing OK
			return true;

		// x or y wasn't assigned to a column
		this.warningLabel.setText(
				Translatrix.getTranslationString("formeditor.xyValueNotMapped"));
		return false;
		/* ======================================== */
	}
}
