package lu.tudor.santec.gecamed.formeditor.gui.view.editormenu;

import java.awt.Color;

import javax.swing.JComponent;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.formeditor.gui.FormEditorModule;
import lu.tudor.santec.gecamed.formeditor.gui.component.EditableComponent;
import lu.tudor.santec.gecamed.formeditor.gui.model.FormEditorModel;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;

public abstract class MenuSettingsPanel extends JPanel
{
	private static final long serialVersionUID = 1L;

	public static final Color DISABLED_COLOR = GECAMedColors.c_GECAMedBackground;//new Color(240, 240, 240);
	
	protected static final RowSpec 	DEFAULT_ROW_SPEC = new RowSpec(RowSpec.FILL, 	Sizes.PREFERRED,RowSpec.NO_GROW);
	protected static final RowSpec 	SPACER_ROW_SPEC	 = new RowSpec(RowSpec.DEFAULT, Sizes.DLUY2, 	RowSpec.NO_GROW);
	protected static final CellConstraints CC 		 = new CellConstraints();
	
	
	/* ======================================== */
	// 		NON-STATIC MEMBERS
	/* ======================================== */
	
	protected FormEditorModel 	model;
	protected FormEditorModule 	view;
	
	
	public MenuSettingsPanel (FormEditorModel model)
	{
		this.model = model;
		this.view = model.getView();
		
		initPanel();
	}
	
	
	
	/* ======================================== */
	// 		HELP METHODS
	/* ======================================== */
	
	/**
	 * Appends a new row and a component into this row. 
	 * Afterwards a row as spacer to the next row is appended.
	 *  
	 * @param c the component to add
	 */
	public void appendRow (JComponent c)
	{
		appendRow(c, DEFAULT_ROW_SPEC);
	}
	
	/**
	 * Appends a new row and a component into this row. 
	 * Afterwards a row as spacer to the next row is appended.
	 *  
	 * @param c the component to add
	 * @param rowSpec the specification of the row to enter the column
	 */
	public void appendRow (JComponent c, RowSpec rowSpec)
	{
		appendRow(c, 2, 3, rowSpec);
	}
	
	public void appendRow (JComponent c, int col, int width)
	{
		appendRow(c, col, width, DEFAULT_ROW_SPEC);
	}
	
	public void appendRow (JComponent c, int col, int width, RowSpec rowSpec)
	{
		FormLayout layout = (FormLayout) getLayout();
		layout.appendRow(rowSpec);
		
		int size = layout.getRowCount();
		this.add(c, CC.xyw(col, size, width));
		
		layout.appendRow(SPACER_ROW_SPEC);
	}
	
	
	
	/* ======================================== */
	// 		ABSTRACT METHODS
	/* ======================================== */
	
	protected abstract void initPanel ();
	
	public abstract void preparePanelForSelectedComponent (EditableComponent currentlySelectedComponent);
}
