/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.hl7import.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@Entity
@Table(name = "import_adt", schema = "hl7interface")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = "getAllHL7Admissions", 		query = "SELECT OBJECT(o) FROM HL7Admission o where o.quarantined = false"),
	@NamedQuery(name = "getHL7AdmissionsByEvent",     query = "SELECT OBJECT(o) FROM HL7Admission o WHERE o.triggerEvent = :event AND o.quarantined = false"),
	@NamedQuery(name = "getHL7AdmissionsByMessageId", query = "SELECT OBJECT(o) FROM HL7Admission o WHERE o.messageId = :messageid AND o.quarantined = false")
	})

public class HL7Admission extends HL7Bean implements Serializable
	{
	private static final long serialVersionUID = 1L;

	private Integer		  		m_MessageId;
	private String	  			m_MessageType;
	private String				m_TriggerEvent;
	private Date				m_MessageDate;
	private String				m_SendingApplication;
	private String				m_SendingFacility;
	private String				m_ControlId;
//	private Integer 			m_PatientId;
	private String				m_PatientId;
	private String				m_PatientFirstName;
	private String				m_PatientName;
	private String				m_PatientTitle;
	private Date				m_PatientBirthdate;
	private String				m_PatientSex;
	private String				m_PatientMaidenName;
	private String				m_PatientMaritalStatus;
	private String				m_PatientSSN;
	private String				m_PatientBirthplace;
	private String				m_PatientClass;
	private String				m_PointOfCare;
	private String				m_Bed;
	private String				m_AdmissionType;
	private String				m_AttendingPhysicianID;
	private String				m_AttendingPhysicianName;
	private String				m_ReferringPhysicianID;
	private String				m_ReferringPhysicianName;
	private String				m_HopsitalService;
	private String				m_HospitalisationClass;
	private Integer				m_VisitId;
	private Date				m_AdmissionTime;
	private Date				m_DischargeTime;
	private Date				m_TransferTime;
	private String				m_AdmissionReason;
	private String				m_DischargeReason;
	private Date				m_AccidentDate;
	private String				m_AccidentNumber;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************

	private static final Hashtable <String,Integer> m_ADTEventLookup = new Hashtable <String,Integer> (14);
	
	public static final int	c_Invalid				= -1;
	
	public static final int	c_AdmissionInPatient	= 0;
	public static final int	c_TransferPatient		= 1;
	public static final int	c_DischargePatient		= 2;
	public static final int	c_AdmissionOutPatient	= 3;
	public static final int	c_PreAdmissionInPatient	= 4;
	public static final int	c_OutToInPatient		= 5;
	public static final int	c_InToOutPatient		= 6;
	public static final int	c_UpdatePatient			= 7;
	public static final int	c_CancelAdmission		= 8;
	public static final int	c_CancelTransfer		= 9;
	public static final int	c_CancelDischarge		= 10;
	public static final int	c_SwapPatient			= 11;
	public static final int	c_DeletePatient			= 12;
	public static final int	c_CancelPreAdmission	= 13;
	
	private static final String m_ADTEventTags[] = {"A01",	//	c_AdmissionInPatient
													"A02",	//	c_TransferPatient
													"A03",	//	c_DischargePatient
													"A04",	//	c_AdmissionOutPatient
													"A05",	//	c_PreAdmissionInPatient	
													"A06",	//	c_OutToInPatient
													"A07",	//	c_InToOutPatient
													"A08",	//	c_UpdatePatient
													"A11",	//	c_CancelAdmission
													"A12",	//	c_CancelTransfer
													"A13",	//	c_CancelDischarge
													"A17",	//	c_SwapPatient
													"A29",	//	c_DeletePatient
													"A38" };//	c_CancelPreAdmission

	static {m_ADTEventLookup.put(m_ADTEventTags [c_AdmissionInPatient], 	c_AdmissionInPatient);
			m_ADTEventLookup.put(m_ADTEventTags [c_TransferPatient], 		c_TransferPatient);
			m_ADTEventLookup.put(m_ADTEventTags [c_DischargePatient], 		c_DischargePatient);
			m_ADTEventLookup.put(m_ADTEventTags [c_AdmissionOutPatient], 	c_AdmissionOutPatient);
			m_ADTEventLookup.put(m_ADTEventTags [c_PreAdmissionInPatient],	c_PreAdmissionInPatient);
			m_ADTEventLookup.put(m_ADTEventTags [c_OutToInPatient], 		c_OutToInPatient);
			m_ADTEventLookup.put(m_ADTEventTags [c_InToOutPatient], 		c_InToOutPatient);
			m_ADTEventLookup.put(m_ADTEventTags [c_UpdatePatient], 			c_UpdatePatient);
			m_ADTEventLookup.put(m_ADTEventTags [c_CancelAdmission], 		c_CancelAdmission);
			m_ADTEventLookup.put(m_ADTEventTags [c_CancelTransfer], 		c_CancelTransfer);
			m_ADTEventLookup.put(m_ADTEventTags [c_CancelDischarge], 		c_CancelDischarge);
			m_ADTEventLookup.put(m_ADTEventTags [c_SwapPatient], 			c_SwapPatient);
			m_ADTEventLookup.put(m_ADTEventTags [c_DeletePatient], 			c_DeletePatient);
			m_ADTEventLookup.put(m_ADTEventTags [c_CancelPreAdmission], 	c_CancelPreAdmission);	}
	
	public static final String c_Male				= "M";
	public static final String c_Female				= "F";
	public static final String c_Other				= "O";
	public static final String c_Unknown			= "U";
	
	public static final String c_Separated			= "S";
	public static final String c_Divorced			= "D";
	public static final String c_Married			= "M";
	public static final String c_Single				= "C";
	public static final String c_Widowed			= "V";
	public static final String c_Remarried			= "R";
	//FACT-HIS Add variable and handle in code
	public static final String c_Partnership		= "P";
	public static final String c_MSOther 			= "A";
	
	public static final String c_InPatient			= "I";
	public static final String c_OutPatient			= "O";
	public static final String c_RecurringPatient	= "R";
	
	public static final String c_Accident			= "A";
	public static final String c_Emergency			= "E";
	public static final String c_Recurring			= "R";
	
	public static final String c_FirstClass			= "1";
	public static final String c_SecondClass		= "2";

	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives                                       						*
//***************************************************************************
//---------------------------------------------------------------------------

@Transient	
public int getEvent ()
	{
	Integer l_Event;
		
	if (this.getTriggerEvent() != null)
		{
		l_Event = m_ADTEventLookup.get(this.getTriggerEvent());
		if (l_Event != null) return l_Event.intValue();
					   else return c_Invalid;		
		}
	else return c_Invalid;
	}

//---------------------------------------------------------------------------

@Transient
public static String getEventTag (int p_Event)
	{
	if ((p_Event >= 0) && (p_Event < m_ADTEventTags.length))
		return m_ADTEventTags [p_Event];
	else return "";
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

@Column(name = "messagereceptionid")

public Integer getMessageId() 
	{
	return m_MessageId;
	}

//---------------------------------------------------------------------------

public void setMessageId (Integer p_MessageId) 
	{
	m_MessageId = p_MessageId;
	}

//---------------------------------------------------------------------------

@Column(name = "admitreason")

public String getAdmissionReason() 
	{
	return m_AdmissionReason;
	}

//---------------------------------------------------------------------------

public void setAdmissionReason (String p_AdmissionReason) 
	{
	m_AdmissionReason = p_AdmissionReason;
	}

//---------------------------------------------------------------------------

@Column(name = "admittime")

public Date getAdmissionTime() 
	{
	return m_AdmissionTime;
	}

//---------------------------------------------------------------------------

public void setAdmissionTime (Date p_AdmissionTime) 
	{
	m_AdmissionTime = p_AdmissionTime;
	}

//---------------------------------------------------------------------------

@Column(name = "pattransferdate")

public Date getTransferTime() 
	{
	return m_TransferTime;
	}

//---------------------------------------------------------------------------

public void setTransferTime (Date p_TransferTime) 
	{
	m_TransferTime = p_TransferTime;
	}

//---------------------------------------------------------------------------

@Column(name = "admissiontype")

public String getAdmissionType() 
	{
	return m_AdmissionType;
	}

//---------------------------------------------------------------------------

public void setAdmissionType (String p_AdmissionType) 
	{
	m_AdmissionType = p_AdmissionType;
	}

//---------------------------------------------------------------------------

@Column(name = "attdoctorid")

public String getAttendingPhysicianID() 
	{
	return m_AttendingPhysicianID;
	}

//---------------------------------------------------------------------------

public void setAttendingPhysicianID (String p_AttendingPhysicianID) 
	{
	m_AttendingPhysicianID = p_AttendingPhysicianID;
	}

//---------------------------------------------------------------------------

@Column(name = "attdoctorname")

public String getAttendingPhysicianName() 
	{
	return m_AttendingPhysicianName;
	}

//---------------------------------------------------------------------------

public void setAttendingPhysicianName (String p_AttendingPhysicianName) 
	{
	m_AttendingPhysicianName = p_AttendingPhysicianName;
	}

//---------------------------------------------------------------------------

@Column(name = "patbed")

public String getBed() 
	{
	return m_Bed;
	}

//---------------------------------------------------------------------------

public void setBed(String p_Bed) 
	{
	m_Bed = p_Bed;
	}

//---------------------------------------------------------------------------

@Column(name = "controlid")

public String getControlId() 
	{
	return m_ControlId;
	}

//---------------------------------------------------------------------------

public void setControlId (String p_ControlId) 
	{
	m_ControlId = p_ControlId;
	}

//---------------------------------------------------------------------------

@Column(name = "dischargetime")

public Date getDischargeTime() 
	{
	return m_DischargeTime;
	}

//---------------------------------------------------------------------------

public void setDischargeTime (Date p_DischargeTime) 
	{
	m_DischargeTime = p_DischargeTime;
	}

//---------------------------------------------------------------------------

@Column(name = "dischargereason")

public String getDischargeReason() 
	{
	return m_DischargeReason;
	}

//---------------------------------------------------------------------------

public void setDischargeReason (String p_DischargeReason) 
	{
	m_DischargeReason = p_DischargeReason;
	}

//---------------------------------------------------------------------------

@Column(name = "hospitalservice")

public String getHopsitalService() 
	{
	return m_HopsitalService;
	}

//---------------------------------------------------------------------------

public void setHopsitalService (String p_HopsitalService) 
	{
	m_HopsitalService = p_HopsitalService;
	}

//---------------------------------------------------------------------------

@Column(name = "messagedate")

public Date getMessageDate() 
	{
	return m_MessageDate;
	}

//---------------------------------------------------------------------------

public void setMessageDate (Date p_MessageDate) 
	{
	m_MessageDate = p_MessageDate;
	}

//---------------------------------------------------------------------------

@Column(name = "messagetype")

public String getMessageType() 
	{
	return m_MessageType;
	}

//---------------------------------------------------------------------------

public void setMessageType (String p_MessageType) 
	{
	m_MessageType = p_MessageType;
	}

//---------------------------------------------------------------------------

@Column(name = "patbirthdate")

public Date getPatientBirthdate() 
	{
	return m_PatientBirthdate;
	}

//---------------------------------------------------------------------------

public void setPatientBirthdate (Date p_PatientBirthdate) 
	{
	m_PatientBirthdate = p_PatientBirthdate;
	}

//---------------------------------------------------------------------------

@Column(name = "patbirthplace")

public String getPatientBirthplace() 
	{
	return m_PatientBirthplace;
	}

//---------------------------------------------------------------------------

public void setPatientBirthplace (String p_PatientBirthplace) 
	{
	m_PatientBirthplace = p_PatientBirthplace;
	}

//---------------------------------------------------------------------------

@Column(name = "patclass")

public String getPatientClass() 
	{
	return m_PatientClass;
	}

//---------------------------------------------------------------------------

public void setPatientClass (String p_PatientClass) 
	{
	m_PatientClass = p_PatientClass;
	}

//---------------------------------------------------------------------------

@Column(name = "patgivenname")

public String getPatientFirstName() 
	{
	return m_PatientFirstName;
	}

//---------------------------------------------------------------------------

public void setPatientFirstName (String p_PatientFirstName) 
	{
	m_PatientFirstName = p_PatientFirstName;
	}

//---------------------------------------------------------------------------

@Column(name = "internalpatientid")

//public Integer getPatientId() 
public String getPatientId() 
	{
	return m_PatientId;
	}

//---------------------------------------------------------------------------

//public void setPatientId (Integer p_PatientId) 
public void setPatientId (String p_PatientId) 
	{
	m_PatientId = p_PatientId;
	}

//---------------------------------------------------------------------------

@Column(name = "patmaidenname")

public String getPatientMaidenName() 
	{
	return m_PatientMaidenName;
	}

//---------------------------------------------------------------------------

public void setPatientMaidenName (String p_PatientMaidenName) 
	{
	m_PatientMaidenName = p_PatientMaidenName;
	}

//---------------------------------------------------------------------------

@Column(name = "patmaritalstatus")

public String getPatientMaritalStatus() 
	{
	return m_PatientMaritalStatus;
	}

//---------------------------------------------------------------------------

public void setPatientMaritalStatus (String p_PatientMaritalStatus) 
	{
	m_PatientMaritalStatus = p_PatientMaritalStatus;
	}

//---------------------------------------------------------------------------

@Column(name = "patfamilyname")

public String getPatientName() 
	{
	return m_PatientName;
	}

//---------------------------------------------------------------------------

public void setPatientName (String p_PatientName) 
	{
	m_PatientName = p_PatientName;
	}	

//---------------------------------------------------------------------------

@Column(name = "patsex")

public String getPatientSex() 
	{
	return m_PatientSex;
	}

//---------------------------------------------------------------------------

public void setPatientSex (String p_PatientSex) 
	{
	m_PatientSex = p_PatientSex;
	}

//---------------------------------------------------------------------------

@Column(name = "patssn")

public String getPatientSSN() 
	{
	return m_PatientSSN;
	}

//---------------------------------------------------------------------------

public void setPatientSSN (String p_PatientSSN) 
	{
	m_PatientSSN = p_PatientSSN;
	}

//---------------------------------------------------------------------------

@Column(name = "pattitle")

public String getPatientTitle() 
	{
	return m_PatientTitle;
	}

//---------------------------------------------------------------------------

public void setPatientTitle (String p_PatientTitle) 
	{
	m_PatientTitle = p_PatientTitle;
	}

//---------------------------------------------------------------------------

@Column(name = "pointofcare")

public String getPointOfCare() 
	{
	return m_PointOfCare;
	}

//---------------------------------------------------------------------------

public void setPointOfCare (String p_PointOfCare) 
	{
	m_PointOfCare = p_PointOfCare;
	}

//---------------------------------------------------------------------------

@Column(name = "refdoctorid")

public String getReferringPhysicianID() 
	{
	return m_ReferringPhysicianID;
	}

//---------------------------------------------------------------------------

public void setReferringPhysicianID (String p_ReferringPhysicianID) 
	{
	m_ReferringPhysicianID = p_ReferringPhysicianID;
	}

//---------------------------------------------------------------------------

@Column(name = "refdoctorname")

public String getReferringPhysicianName() 
	{
	return m_ReferringPhysicianName;
	}

//---------------------------------------------------------------------------

public void setReferringPhysicianName (String p_ReferringPhysicianName) 
	{
	m_ReferringPhysicianName = p_ReferringPhysicianName;
	}

//---------------------------------------------------------------------------

@Column(name = "sendingapplication")

public String getSendingApplication() 
	{
	return m_SendingApplication;
	}

//---------------------------------------------------------------------------

public void setSendingApplication (String p_SendingApplication) 
	{
	m_SendingApplication = p_SendingApplication;
	}

//---------------------------------------------------------------------------

@Column(name = "sendingfacility")

public String getSendingFacility() 
	{
	return m_SendingFacility;
	}

//---------------------------------------------------------------------------

public void setSendingFacility (String p_SendingFacility) 
	{
	m_SendingFacility = p_SendingFacility;
	}

//---------------------------------------------------------------------------

@Column(name = "triggerevent")

public String getTriggerEvent() 
	{
	return m_TriggerEvent;
	}

//---------------------------------------------------------------------------

public void setTriggerEvent (String p_TriggerEvent) 
	{
	m_TriggerEvent = p_TriggerEvent;
	}

//---------------------------------------------------------------------------

@Column(name = "visitid")

public Integer getVisitId() 
	{
	return m_VisitId;
	}

//---------------------------------------------------------------------------

public void setVisitId (Integer p_VisitId) 
	{
	m_VisitId = p_VisitId;
	}

//---------------------------------------------------------------------------

@Column(name = "pathospitalclass")

public String getHospitalisationClass() 
	{
	return m_HospitalisationClass;
	}

//---------------------------------------------------------------------------

public void setHospitalisationClass (String p_HospitalisationClass) 
	{
	m_HospitalisationClass = p_HospitalisationClass;
	}

//---------------------------------------------------------------------------

@Column(name = "accidentdate")

public Date getAccidentDate() 
	{
	return m_AccidentDate;
	}

//---------------------------------------------------------------------------

public void setAccidentDate (Date p_AccidentDate) 
	{
	m_AccidentDate = p_AccidentDate;
	}

//---------------------------------------------------------------------------

@Column(name = "accidentnumber")

public String getAccidentNumber() 
	{
	return m_AccidentNumber;
	}

//---------------------------------------------------------------------------

public void setAccidentNumber (String p_AccidentNumber) 
	{
	m_AccidentNumber = p_AccidentNumber;
	}

public String toString() {
	String msg = "ADT ID: ";
	try {
		msg += getMessageId();
		msg += " Type: " + getMessageType();
		msg += " Trigger: " + getTriggerEvent();
		msg += " Patient/RIS ID: " + getPatientId();
		msg += " Pat: " + getPatientName() + "," + getPatientFirstName() + " maiden:" + getPatientMaidenName() + " SSN: " + getPatientSSN();	
	} catch (Exception e) {
		e.printStackTrace();
	}
	return msg;
}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
