/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.hl7import.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@Entity
@Table(name = "import_insurance", schema = "hl7interface")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = "getAllHL7Insurances", 			 query = "SELECT OBJECT(o) FROM HL7Insurance o WHERE o.quarantined = false"),
	@NamedQuery(name = "getHL7InsurancesByMessageId", 	 query = "SELECT OBJECT(o) FROM HL7Insurance o WHERE o.messageId = :messageid AND o.quarantined = false"),
	@NamedQuery(name = "getHL7InsurancesByPatientId", 	 query = "SELECT OBJECT(o) FROM HL7Insurance o WHERE o.patientId = :patientid AND o.quarantined = false")
//	@NamedQuery(name = "deleteHL7InsurancesByMessageId", query = "DELETE FROM HL7Insurance o WHERE o.messageId = :messageid")
	})

public class HL7Insurance extends HL7Bean implements Serializable
	{
	private static final long serialVersionUID = 1L;

	private Integer		m_MessageId;
//	private Integer	  	m_PatientId;
	private String	  	m_PatientId;
	private String		m_InsurancePlan;
	private String		m_InsuranceId;
	private String		m_InsuranceName;
	private String		m_PolicyNumber;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	// TODO now we map the insurance over a mapping in the database so the Hashtable m_HealthInsuranceTranslator
	// UCM affiliated Insurances
	
//	public static final String	c_CNS				= "CNS";	
//	public static final String	c_CNAMO				= "CNAM";	
//	public static final String	c_CMFEP				= "CMFEP";	
//	public static final String	c_CMFEC				= "CMFEC";	
//	public static final String	c_CMEP				= "CMEP";	
//	public static final String	c_CMPI				= "CMPI";	
//	public static final String	c_CMOA				= "CMOA";	
//	public static final String	c_CMEA				= "CMEA";	
//	public static final String	c_CMA				= "CMA";	
//	public static final String	c_EMCFL				= "EMCFL";	
//	public static final String	c_ARMEE				= "ARMEE";
//	public static final String	c_MAMMO				= "MAMMO";
//	public static final String	c_SISTEHL			= "SIST EHL";	
//	public static final String	c_GUERRE			= "DG";	
//	
//	// Private (EU..) Insurances
//
//	public static final String	c_PE				= "PE";	
//	public static final String	c_CE				= "CE";	
//	public static final String	c_BEI				= "BEI";	
//	public static final String	c_CECA				= "CECA";	
//	public static final String	c_NAMSA				= "VAN BREDA-NAMSA";	
//	public static final String	c_EUCTL				= "EUROCONTROL";	
//	public static final String	c_RCAM				= "RCAM";	
//
//	// Associated Insurances	
//
//	public static final String	c_SANTE				= "SANTE";
//	public static final String	c_EPL				= "EPI";
//	public static final String	c_MEPS				= "MEPS";
//	public static final String	c_SMA				= "SMA";	
//	public static final String	c_PARQUET			= "PT";	
//	public static final String	c_CGE				= "COGOET";	
//	
//	
//	
//	public static final String	c_E111				= "E111";
//	public static final String	c_PRIV				= "PARTIC";	
//	
//	// Secondary Insurances	
//
	public static final String	c_CMCM_Normal		= "NORMAL";
	public static final String	c_CMCM_Prestaplus	= "PRESTA-PLUS";
//	
//	// new Insurances FACT-HIS
//	public static final String 	c_ASTF 				= "ASTF";
//	public static final String 	c_ADMAERO 			= "ADMAERO";
//	public static final String 	c_ADMDESBIENS 		= "ADMDESBIENS";
//	public static final String 	c_AIRRESCUE 		= "AIRRESCUE";
//	public static final String 	c_ALLIANZ 			= "ALLIANZ";
//	public static final String 	c_AMELIFE 			= "AMELIFE";
//	public static final String 	c_AXAVIE 			= "AXAVIE";
//	public static final String 	c_AXA 				= "AXA";
//	public static final String 	c_BALOISE 			= "BALOISE";
//	public static final String 	c_CAEAVIATION 		= "CAEAVIATION";
//	public static final String 	c_CNSAAGR 			= "CNSAAGR";
//	public static final String 	c_CARGOLUX 			= "CARGOLUX";
//	public static final String 	c_CNSAAIN 			= "CNSAAIN";
//	public static final String 	c_CONSARBITRAL 		= "CONSARBITRAL";
//	public static final String 	c_DKVLUX 			= "DKVLUX";
//	public static final String 	c_DKV 				= "DKV";
//	public static final String 	c_FOYERSANTE 		= "FOYERSANTE";
//	public static final String 	c_LUXAVIATION 		= "LUXAVIATION";
//	public static final String 	c_FORTIS 			= "FORTIS";
//	public static final String 	c_LUXAIR 			= "LUXAIR";
//	public static final String 	c_OLAI 				= "OLAI";
//	public static final String 	c_PARLEMENT 		= "PARLEMENT";
//	public static final String 	c_RAIFFEISEN 		= "RAIFFEISEN";
//	public static final String 	c_VIVIUM 			= "VIVIUM";
//	public static final String 	c_VLM 				= "VLM";
	

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//---------------------------------------------------------------------------

@Column(name = "messagereceptionid")

public Integer getMessageId() 
	{
	return m_MessageId;
	}

//---------------------------------------------------------------------------

public void setMessageId (Integer p_MessageId) 
	{
	m_MessageId = p_MessageId;
	}

//---------------------------------------------------------------------------

@Column(name = "internalpatientid")

//public Integer getPatientId() 
public String getPatientId() 
	{
	return m_PatientId;
	}

//---------------------------------------------------------------------------


//public void setPatientId (Integer p_PatientId) 
public void setPatientId (String p_PatientId) 
	{
	m_PatientId = p_PatientId;
	}

//---------------------------------------------------------------------------

@Column(name = "insplanid")

public String getInsurancePlan() 
	{
	return m_InsurancePlan;
	}

//---------------------------------------------------------------------------

public void setInsurancePlan (String p_InsurancePlan) 
	{
	m_InsurancePlan = p_InsurancePlan;
	}

//---------------------------------------------------------------------------

@Column(name = "inscompanyid")

public String getInsuranceId() 
	{
	return m_InsuranceId;
	}

//---------------------------------------------------------------------------

public void setInsuranceId (String p_InsuranceId) 
	{
	m_InsuranceId = p_InsuranceId;
	}
//---------------------------------------------------------------------------

@Column(name = "inscompanyname")

public String getInsuranceName() 
	{
	return m_InsuranceName;
	}

//---------------------------------------------------------------------------

public void setInsuranceName (String p_InsuranceName) 
	{
	m_InsuranceName = p_InsuranceName;
	}

//---------------------------------------------------------------------------

@Column(name = "inspolicynumber")

public String getPolicyNumber() 
	{
	return m_PolicyNumber;
	}

//---------------------------------------------------------------------------

public void setPolicyNumber (String p_PolicyNumber) 
	{
	m_PolicyNumber = p_PolicyNumber;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
