/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.hl7import.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@Entity
@Table(name = "import_order", schema = "hl7interface")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = "getAllHL7Passages", 			query = "SELECT OBJECT(o) FROM HL7Passage o WHERE o.quarantined = false"),
	@NamedQuery(name = "getHL7PassagesByMessageId", 	query = "SELECT OBJECT(o) FROM HL7Passage o WHERE o.messageId = :messageid  AND o.quarantined = false ORDER BY o.passageDate DESC")
//	@NamedQuery(name = "deleteHL7PassagesByMessageId",  query = "DELETE FROM HL7Passage o WHERE o.messageId = :messageid")
	})

public class HL7Passage extends HL7Bean implements Serializable
	{
	private static final long serialVersionUID = 1L;

	private Integer		  		m_MessageId;
	private String				m_AccessionNumber;
	private String	  			m_TreatmentName;			
	private String				m_TreatmentCode;
	private Date				m_PassageDate;
	private String				m_Interpreter;
	private String				m_Technician;

//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives                                       						*
//***************************************************************************
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

@Column(name = "messagereceptionid")

public Integer getMessageId() 
	{
	return m_MessageId;
	}

//---------------------------------------------------------------------------

public void setMessageId (Integer p_MessageId) 
	{
	m_MessageId = p_MessageId;
	}

//---------------------------------------------------------------------------

@Column(name = "accessionnumber")

public String getAccessionNumber() 
	{
	return m_AccessionNumber;
	}

//---------------------------------------------------------------------------

public void setAccessionNumber (String p_AccessionNumber) 
	{
	m_AccessionNumber = p_AccessionNumber;
	}

//---------------------------------------------------------------------------

@Column(name = "treatmentname")

public String getTreatmentName() 
	{
	return m_TreatmentName;
	}

//---------------------------------------------------------------------------

public void setTreatmentName (String p_TreatmentName) 
	{
	m_TreatmentName = p_TreatmentName;
	}

//---------------------------------------------------------------------------

@Column(name = "treatmentucmcode")

public String getTreatmentCode() 
	{
	return m_TreatmentCode;
	}

//---------------------------------------------------------------------------

public void setTreatmentCode (String p_TreatmentCode) 
	{
	m_TreatmentCode = p_TreatmentCode;
	}

//---------------------------------------------------------------------------

@Column(name = "observationdate")

public Date getPassageDate() 
	{
	return m_PassageDate;
	}

//---------------------------------------------------------------------------

public void setPassageDate (Date p_PassageDate) 
	{
	m_PassageDate = p_PassageDate;
	}

//---------------------------------------------------------------------------

@Column(name = "resultinterpreter")

public String getInterpreter() 
	{
	return m_Interpreter;
	}

//---------------------------------------------------------------------------

public void setInterpreter (String p_Interpreter) 
	{
	m_Interpreter = p_Interpreter;
	}

//---------------------------------------------------------------------------

@Column(name = "technicianname")

public String getTechnician() 
	{
	return m_Technician;
	}

//---------------------------------------------------------------------------

public void setTechnician (String p_Technician) 
	{
	m_Technician = p_Technician;
	}

//---------------------------------------------------------------------------

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
