/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.hl7import.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@Entity
@Table(name = "import_prescription", schema = "hl7interface")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = "getAllHL7Prescriptions", 			query = "SELECT OBJECT(o) FROM HL7Prescription o WHERE o.quarantined = false"),
	@NamedQuery(name = "getHL7PrescriptionsByMessageId", 	query = "SELECT OBJECT(o) FROM HL7Prescription o WHERE o.messageId = :messageid AND o.quarantined = false")
	})

public class HL7Prescription extends HL7Bean implements Serializable
	{
	private static final long serialVersionUID = 1L;

	private Integer		  		m_MessageId;
	private String				m_ScanNumber;
	private Integer				m_PageNumber;
	private String				m_ContentType;
	private byte[]				m_Scan;

//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
	public static final String c_EncodedData = "ED";
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives                                       						*
//***************************************************************************
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

@Column(name = "messagereceptionid")

public Integer getMessageId() 
	{
	return m_MessageId;
	}

//---------------------------------------------------------------------------

public void setMessageId (Integer p_MessageId) 
	{
	m_MessageId = p_MessageId;
	}

//---------------------------------------------------------------------------

@Column(name = "scannumber")

public String getScanNumber() 
	{
	return m_ScanNumber;
	}

//---------------------------------------------------------------------------

public void setScanNumber (String p_ScanNumber) 
	{
	m_ScanNumber = p_ScanNumber;
	}

//---------------------------------------------------------------------------

@Column(name = "pagenumber")

public Integer getPageNumber() 
	{
	return m_PageNumber;
	}

//---------------------------------------------------------------------------

public void setPageNumber (Integer p_PageNumber) 
	{
	m_PageNumber = p_PageNumber;
	}

//---------------------------------------------------------------------------

@Column(name = "contenttype")

public String getContentType() 
	{
	return m_ContentType;
	}

//---------------------------------------------------------------------------

public void setContentType (String p_ContentType) 
	{
	m_ContentType = p_ContentType;
	}

//---------------------------------------------------------------------------

//@Lob
@Basic(fetch=FetchType.EAGER)
@Column(name = "prescriptionscan")

public byte[] getScan() 
	{
	return m_Scan;
	}

//---------------------------------------------------------------------------

public void setScan (byte[] p_Scan) 
	{
	m_Scan = p_Scan;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
