/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.hl7import.ejb.session.interfaces;

import java.util.Collection;

import lu.tudor.santec.gecamed.hl7import.ejb.entity.beans.HL7Order;

import org.jboss.annotation.ejb.Management;

@Management
public interface OrderInterface 
{
//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

	/**
	* The OrderInterface 
	* @author nmac
	* @created 06/10/19
	*/

	public void start () throws Exception;
	
	public void stop ()  throws Exception;
	
	public Collection <HL7Order> getAllOrders () throws Exception;

	public void processOrder (HL7Order p_Order) throws Exception;
	
	public void dailyTask () throws Exception;
		
//***************************************************************************
//* End of Class															*
//***************************************************************************

}
