package lu.tudor.santec.gecamed.hl7import.utils;

import java.util.Collection;
import java.util.LinkedHashSet;

public class InvoiceChangeTracker 
	{
	Collection <Integer> m_UpdatedInvoiceIds;
	Collection <Integer> m_DeletedInvoiceIds;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public InvoiceChangeTracker ()
	{
	m_UpdatedInvoiceIds = new LinkedHashSet <Integer> ();
	m_DeletedInvoiceIds = new LinkedHashSet <Integer> ();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public void reset ()
	{
	m_UpdatedInvoiceIds.clear();
	m_DeletedInvoiceIds.clear();
	}

//---------------------------------------------------------------------------

public void setAsUpdated (Integer p_UpdatedInvoiceId)
	{
	m_UpdatedInvoiceIds.add(p_UpdatedInvoiceId);
	}
	
//---------------------------------------------------------------------------

public void setAsDeleted (Integer p_DeletedInvoiceId)
	{
	m_DeletedInvoiceIds.add(p_DeletedInvoiceId);
	}

//---------------------------------------------------------------------------

public boolean containsUpdatedInvoiceIds ()
	{
	return !m_UpdatedInvoiceIds.isEmpty();
	}

//---------------------------------------------------------------------------

public boolean containsDeletedInvoiceIds ()
	{
	return !m_DeletedInvoiceIds.isEmpty();
	}

//---------------------------------------------------------------------------

public Collection <Integer> getUpdatedInvoiceIds ()
	{
	return m_UpdatedInvoiceIds;
	}

//---------------------------------------------------------------------------

public Collection <Integer> getDeletedInvoiceIds ()
	{
	return m_DeletedInvoiceIds;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

}
