/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.importexport.ejb.session.interfaces;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;

/**
 * @author martin.heinemann@tudor.lu
 * 22.07.2008
 * 17:25:57
 *
 *
 * @version
 * <br>$Log: ImportExportInterface.java,v $
 * <br>Revision 1.6  2013-06-26 15:28:14  troth
 * <br>Code clean up syso.
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-07-28 16:10:28  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-07-25 14:42:42  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-07-23 09:44:53  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public interface ImportExportInterface {

    public Patient savePatient(Patient p) throws Exception;
    
    public GECAMedEntityBean saveEntity(GECAMedEntityBean entity) throws Exception;
    
    public void newTransaction() throws Exception;
    
    public void commitTransaction() throws Exception;
    
    public void rollbackTransaction() throws Exception;
    
    /**
     * @param b the binary data of the file
     * @param entry containing the incident and the patient
     * @return the entry filled with the new file information
     * @throws Exception
     */
    public IncidentEntry saveGecamedFile(byte[] b, IncidentEntry entry) throws Exception;
    
    /**
     * @param filename
     * @param patientId
     * @throws Exception
     */
    public void deleteGecamedFile(String filename, Integer patientId) throws Exception;
    
    /**
     * @param entry
     * @param patientId
     */
    public IncidentEntry moveTempFile(IncidentEntry entry, Integer patientId) throws Exception;
    
    /**
     * Load the xsl-fo template from server
     * 
     * @param templateName
     * @return the file as byte array
     * @throws Exception
     */
    public byte[] getTemplateBinary(String templateName) throws Exception;
    
}
