/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.importexport.gui.importer;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.ScrollPaneConstants;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.JaasJbossConfiguration;
import lu.tudor.santec.gecamed.core.gui.LoginCallbackHandler;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.animatedicon.AnimatedIcon;
import lu.tudor.santec.gecamed.core.utils.GECAMedUtils;
import lu.tudor.santec.gecamed.importexport.gui.ImporterClass;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author martin.heinemann@tudor.lu
 * 15.07.2008
 * 14:30:45
 *
 *
 * @version
 * <br>$Log: ImportPanel.java,v $
 * <br>Revision 1.9  2013-03-08 15:11:12  kutscheid
 * <br>don't grow the search button
 * <br>
 * <br>Revision 1.8  2013-03-08 15:07:59  kutscheid
 * <br>fix some UI glitches
 * <br>add functionalities tothe import table
 * <br>add a method to calculate string widths easily
 * <br>
 * <br>Revision 1.7  2013-02-18 07:22:11  kutscheid
 * <br>improve the import module
 * <br>fix a NullPointerException in the LineColorCellRenderer
 * <br>update the gecamedData xsd file and libs
 * <br>
 * <br>Revision 1.6  2012-02-02 15:19:15  ferring
 * <br>unnecessary NullpointerException prevented
 * <br>
 * <br>Revision 1.5  2010-03-12 15:03:43  hermen
 * <br>cleanup of panel layouts and icons
 * <br>
 * <br>Revision 1.4  2008-10-08 09:37:26  heinemann
 * <br>fixed icons
 * <br>
 * <br>Revision 1.3  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-07-18 15:41:05  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-07-18 13:44:32  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class ImportPanel extends JPanel{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private static final String EMPTY_PANEL = "emptypanel";
	private static final String TABLE_PANEL = "tablepanel";
	
	public static AnimatedIcon busyWheelIcon = new AnimatedIcon(IconFetcher.getIcon(ImporterClass.class, ImporterClass.BUSY_WHEEL));
	public static ImageIcon    simulateIcon  = IconFetcher.getMediumIcon(ImporterClass.class, ImporterClass.SIMULATE);
	
	public static ImageIcon importIcon = IconFetcher.getMediumIcon(ImporterClass.class, ImporterClass.IMPORT_ICON);
	
	private JLabel explanationLabel;
	private JLabel chooserLabel;
	private JTextField choosertextField;
	private JButton chooserButton;
	private JPanel bottomPanel;
	private CardLayout cardLayout;
	private JPanel contentPanel;
	private JLabel resultSummaryLabel;
	private JButton revalidateButton;
	private JButton simulateButton;
	private JButton importButton;
	protected JTable table;
	protected JScrollPane scroll;
	private JLabel emptyLabel;
	private JPanel emptyPanel;
	private JPanel tablePanel;
	private CellConstraints cc;
	private JPanel infoPanel;
	private JTextArea infoTextarea;
	private JPanel infoBorderPanel;
//	private JLabel fileInfoLabel;
 
	
	
	public static void main (String[] scheisse) {
		/* ================================================== */
		try {
		
	    Properties properties = new Properties();
			properties.load(new FileInputStream( new File("conf/GECAMed.properties")));
	        // copy properties to the system properties
	    	for (Object element : properties.keySet()) {
	        	System.setProperty((String) element, properties.getProperty((String) element));
	        }
	    JaasJbossConfiguration.activateConfiguration();
	    CallbackHandler ch = new LoginCallbackHandler("admin", "admin");
            LoginContext lc = new LoginContext("gecam_login", ch); 
            lc.login();
            new InitialContext();
		
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (LoginException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NamingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		Translatrix.addBundle("lu.tudor.santec.gecamed.importexport.gui.resources.Translatrix");
		JFrame f = new JFrame();
		
		f.getContentPane().setBackground(GECAMedColors.c_GECAMedBackground);
		/* ------------------------------------------------------- */
		ImportPanel p = new ImportPanel();
		ImportControler c = new ImportControler();
		
		c.setPanel(p);
		
		p.enableBottom(false);
		
		/* ------------------------------------------------------- */
		f.add(p);
		
		f.pack();
		
		f.setVisible(true);
		/* ================================================== */
	}
	
	
	/**
	 * 
	 */
	public ImportPanel() {
		/* ================================================== */
		buildPanel();
		
		showEmptyPanel();
		/* ================================================== */
	}


	
	/**
	 * 
	 */
	public void showTablePanel() {
		/* ================================================== */
		cardLayout.show(contentPanel, TABLE_PANEL);
		/* ================================================== */
	}
	
	/**
	 * 
	 */
	public void showEmptyPanel() {
		/* ================================================== */
		cardLayout.show(contentPanel, EMPTY_PANEL);
		/* ================================================== */
	}
	
	public JTable getTable() {
		/* ================================================== */
		return this.table;
		/* ================================================== */
	}

	/**
	 * 
	 */
	private void buildPanel() {
		/* ====================================================== */
		this.setOpaque(false);
		this.setBorder(BorderFactory.createTitledBorder(Translatrix.getTranslationString("import.tab")));
		this.cc = new CellConstraints();
		/* ------------------------------------------------------- */
		// create all components
		/* ------------------------------------------------------- */
		this.explanationLabel = new JLabel(Translatrix.getTranslationString("import.explain"));
		this.chooserLabel 	  = new JLabel(Translatrix.getTranslationString("import.chooserlabel"));
		this.choosertextField = new JTextField();
		choosertextField.setEditable(false);
		this.chooserButton = new JButton(Translatrix.getTranslationString("import.search"));
		
		//Disable buttons if demo mode
		if (GECAMedUtils.isDemo() && !MainFrame.isAdmin()) {
		   	// disables all tabs
			this.chooserButton.setEnabled(false);
			
		} else {
			this.chooserButton.setEnabled(true);
		}
		buildBottomPanel();
		/* ------------------------------------------------------- */
		FormLayout layout = new FormLayout(// cols
											"10dlu," +
											"fill:pref:grow," +
//											"5dlu," +
//											"fill:pref:grow," +
											"5dlu," +
											"fill:pref," +
											"3dlu",
											// rows
											"3dlu," +
											"pref," +
											"center:8dlu," + // separator
											"fill:pref," +
											"3dlu," +
											"16dlu," +
											"5dlu," +
											"fill:pref:grow");
		
		this.setLayout(layout);
		/* ------------------------------------------------------- */
		// place the components
		/* ------------------------------------------------------- */
		
		/* ------------------------------------------------------- */
		this.add(explanationLabel, cc.xyw(2, 2, 3));
		this.add(new JSeparator(), cc.xyw(2, 3, 3));
		this.add(chooserLabel,     cc.xy(2, 4));
		this.add(choosertextField, cc.xy(2, 6));
		this.add(chooserButton,    cc.xy(4, 6));
		
		this.add(bottomPanel,      cc.xyw(2, 8, 4));
		/* ====================================================== */
	}


	/**
	 * 
	 */
	private void buildBottomPanel() {
		/* ====================================================== */
		this.bottomPanel = new JPanel();
		this.bottomPanel.setOpaque(false);
		
		FormLayout bottomLayout = new FormLayout(//cols
												 "0dlu," +
												 "fill:pref:grow," +
												 "3dlu",
												 //rows
												 "3dlu," +
												 "fill:100dlu:grow," +
												 "3dlu," +
												 "fill:pref," +
												 "3dlu," +
												 "fill:pref," +
												 "10dlu," +
												 "fill:pref," +
												 "5dlu," +
												 "fill:pref," +
												 "0dlu");
		
		bottomPanel.setLayout(bottomLayout);
		/* ------------------------------------------------------- */
		// create components
		/* ------------------------------------------------------- */
		this.cardLayout = new CardLayout();
		this.contentPanel = new JPanel(cardLayout);
		contentPanel.setBackground(Color.WHITE);
		
		this.resultSummaryLabel = new JLabel("");
		/* ------------------------------------------------------- */
		// the buttons
		/* ------------------------------------------------------- */
		this.revalidateButton = new JButton(Translatrix.getTranslationString("import.revalidate"),
								IconFetcher.getMediumIcon(ImporterClass.class, ImporterClass.VALIDATE));
		this.simulateButton   = new JButton(Translatrix.getTranslationString("import.simulate"),
								simulateIcon);
		this.importButton	  = new JButton(Translatrix.getTranslationString("import.tab"),
								importIcon);
		/* ------------------------------------------------------- */
		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addFixed(revalidateButton);
		bb.addGlue();
		bb.addGridded(simulateButton);
		bb.addRelatedGap();
		bb.addGridded(importButton);
		bb.getPanel().setOpaque(false);
		/* ------------------------------------------------------- */
		this.infoBorderPanel = new JPanel(new BorderLayout());
		this.infoBorderPanel.setBorder(BorderFactory.createTitledBorder("Info"));
		this.infoBorderPanel.setOpaque(false);
		
		this.infoPanel = new JPanel(new BorderLayout());
		this.infoPanel.setPreferredSize(new Dimension(infoPanel.getPreferredSize().width, 100));
		this.infoPanel.setOpaque(false);
		/* ------------------------------------------------------- */
		this.infoTextarea = new JTextArea();
		
		infoTextarea.setLineWrap(true);
		infoTextarea.setWrapStyleWord(true);
		infoTextarea.setEditable(false);
		
		JScrollPane infoScroll = new JScrollPane(infoTextarea);
		infoScroll.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
		/* ------------------------------------------------------- */
		infoPanel.add(infoScroll, BorderLayout.CENTER);
		
		infoBorderPanel.add(infoPanel, BorderLayout.CENTER);
		/* ------------------------------------------------------- */
		initCardPanels();
		/* ------------------------------------------------------- *
		 * place the components
		 */
		bottomPanel.add(contentPanel,       cc.xy(2, 2));
		bottomPanel.add(resultSummaryLabel, cc.xy(2, 4));
		bottomPanel.add(bb.getPanel(),      cc.xy(2, 6));
		bottomPanel.add(infoBorderPanel,          cc.xy(2, 8));
		/* ====================================================== */
	}


	private void initCardPanels() {
		/* ====================================================== */
		// create the empty panel first
		/* ------------------------------------------------------- */
		emptyPanel = new JPanel(new FormLayout("pref:grow, pref, pref:grow","pref:grow, pref, pref:grow"));
		this.emptyLabel = new JLabel() {
			private static final long serialVersionUID = 1L;
			@Override
			public void paint(Graphics g) {
				g.setColor(new Color(0,0,0,30));
				g.fillRoundRect(0,0,this.getSize().width ,this.getSize().height , 30, 30);
				super.paint(g);
			}
		};
		this.emptyLabel.setBorder(BorderFactory.createEmptyBorder(30,30,30,30));
		this.emptyLabel.setForeground(Color.WHITE);
		this.emptyLabel.setMinimumSize(new Dimension(300,300));
		this.emptyLabel.setFont(new Font("arial", Font.BOLD, 30));
		this.emptyLabel.setOpaque(false);

		this.emptyLabel.setHorizontalAlignment(JLabel.CENTER);
		this.emptyLabel.setVerticalAlignment(JLabel.CENTER);
		this.emptyLabel.setOpaque(false);
		CellConstraints cc = new CellConstraints();
		
		emptyLabel.setText(Translatrix.getTranslationString("import.nofileselected"));
		
		emptyPanel.add(this.emptyLabel, cc.xy(2,2));
		emptyPanel.setOpaque(false);
		/* ------------------------------------------------------- */
		// now the table panel
		/* ------------------------------------------------------- */
		this.tablePanel = new JPanel(new BorderLayout());
		this.table = new JTable();
		
		this.scroll = new JScrollPane(table);
		
		tablePanel.add(scroll, BorderLayout.CENTER);
		/* ------------------------------------------------------- */
		table.setDefaultRenderer(Object.class, new ImportTableCellRenderer());
		
		table.getTableHeader().setReorderingAllowed(false);
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
//		table.getTableHeader().setVisible(false);
		scroll.getViewport().setBackground(Color.WHITE);
		this.contentPanel.add(emptyPanel, EMPTY_PANEL);
		this.contentPanel.add(tablePanel, TABLE_PANEL);
		/* ====================================================== */
	}


	/**
	 * @param b
	 */
	public void enableBottom(boolean b) {
		/* ================================================== */
		bottomPanel.setEnabled(b);
		contentPanel.setEnabled(b);
		tablePanel.setEnabled(b);
		
		infoPanel.setEnabled(b);
		
		revalidateButton.setEnabled(b);
		simulateButton.setEnabled(b);
		importButton.setEnabled(b);
		
		this.resultSummaryLabel.setEnabled(b);
		/* ================================================== */
	}
	
	
	/**
	 * @return the choosertextField
	 */
	public JTextField getChoosertextField() {
		return choosertextField;
	}


	/**
	 * @return the chooserButton
	 */
	public JButton getChooserButton() {
		return chooserButton;
	}


	/**
	 * @return the revalidateButton
	 */
	public JButton getRevalidateButton() {
		return revalidateButton;
	}
	
	
	
	
	
	/**
	 * @return the simulateButton
	 */
	public JButton getSimulateButton() {
		return simulateButton;
	}


	/**
	 * @return the importButton
	 */
	public JButton getImportButton() {
		return importButton;
	}

	/**
	 * @param text
	 */
	public void setResultInfoText(String text) {
		/* ================================================== */
		if (text != null && !"".equals(text.trim())) {
			this.resultSummaryLabel.setText(text);
			
		} else {
			this.resultSummaryLabel.setText("");
		}
		/* ================================================== */
	}

	/**
	 * @param text
	 */
	public void setInfoText(String text) {
		/* ================================================== */
		if (text != null && !"".equals(text.trim())) {
			this.infoTextarea.setText(text);
			
		} else {
			this.infoTextarea.setText("");
		}
		/* ================================================== */
	}
	
//	/**
//	 * @param text
//	 */
//	public void setInfoFileName(String text) {
//		/* ================================================== */
//		if (text != null && !"".equals(text.trim())) {
//			this.fileInfoLabel.setText(text);
//			
//		} else {
//			this.fileInfoLabel.setText("");
//		}
//		/* ================================================== */
//	}
	
	
}
