<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:import="http://gecamed.lu/schemas/import"
	xmlns:java="http://xml.apache.org/xslt/java" exclude-result-prefixes="java"
	>
	
	<xsl:variable name="space1" select="'1mm'"/>
	<xsl:variable name="space3" select="'3mm'"/>
	<xsl:variable name="space5" select="'5mm'"/>
	<xsl:variable name="space10" select="'10mm'"/>
	
	<xsl:variable name="fontSize10" select="'10pt'"/>
	<xsl:variable name="fontSize12" select="'12pt'"/>
	<xsl:variable name="fontSize14" select="'14pt'"/>
	<xsl:variable name="fontSize18" select="'18pt'"/>
	
	<xsl:variable name="fontNTR" select="'Times New Roman'"/>
	<xsl:variable name="fontArial" select="'Arial'"/>
	<xsl:variable name="fontV" select="'Verdana'"/>
	<xsl:variable name="fontH" select="'Helvetica'"/>
	<xsl:variable name="font" select="'Helvetica'"/>
	
	<xsl:variable name="colorBlue" select="'#0060ff'"/>
	<xsl:variable name="colorRed" select="'#ff0000'"/>
	<xsl:variable name="colorGreen" select="'#9acd32'"/>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Template to search and output a physician in different formats 
	// param: physicianID - the id of physician we search
	// param: style - if 1 output is in full format otherwise format is short version for the history table
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<xsl:template name="searchPhysician">
		<xsl:param name="physicianID"/>
		<xsl:param name="style"/>
		<xsl:for-each select="/import:gecamedData/import:physician">
			<xsl:if test="import:physicianID=$physicianID">
				<xsl:choose>
					<xsl:when test="$style=1">
						<fo:block font-weight="bold">
							[pm.doc]
						</fo:block>
						<xsl:call-template name="outputPhysician"/>
					</xsl:when>
					<xsl:otherwise>					
						<xsl:value-of select='substring(import:firstName,1,2)' />
						<xsl:value-of select='substring(import:lastName,1,1)' /> 
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Template to output every physicians only the main physician not
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<xsl:template match="/import:gecamedData/import:physician">
		<xsl:param name="mainPhysicianID"/>
		<xsl:if test="import:physicianID!=$mainPhysicianID">
			<xsl:call-template name="outputPhysician"/>
		</xsl:if>
	</xsl:template>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Template to output physicians name and address
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<xsl:template name="outputPhysician">
		<fo:block>
			<xsl:call-template name="searchPhysician">
   				<xsl:with-param name="physicianID" select="import:physicianID"/>
			</xsl:call-template>
			<xsl:text> | </xsl:text>
			<xsl:value-of select="import:title" />
			<xsl:text> </xsl:text>
			<xsl:value-of select="import:lastName" />
			<xsl:text> </xsl:text>
			<xsl:value-of select="import:firstName" />
			<xsl:if test="import:address/import:street/@number != ''">
				<xsl:text> </xsl:text>
				<xsl:value-of select="import:address/import:street/@number"/>
			</xsl:if>
			<xsl:if test="import:address/import:street/@name != ''">
				<xsl:text>, </xsl:text>
				<xsl:value-of select="import:address/import:street/@name"/>
			</xsl:if>
			<xsl:if test="import:address/import:zip != ''">
				<xsl:text>; </xsl:text>
				<xsl:value-of select="import:address/import:zip"/>
			</xsl:if>
			<xsl:if test="import:address/import:locality != ''">
				<xsl:text> </xsl:text>
				<xsl:value-of select="import:address/import:locality"/>
			</xsl:if>
			<xsl:if test="import:address/import:country != ''">
				<xsl:text>; </xsl:text>
				<xsl:value-of select="import:address/import:country"/>
			</xsl:if>
		</fo:block>
	</xsl:template>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Template to output patient address
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<xsl:template match="import:gecamedData/import:patient/import:address">
		<fo:block>
			<xsl:if test="./@type='billing'">
				<xsl:text>[pm.address.type.billing]: </xsl:text>  
			</xsl:if>
			<xsl:if test="./@type='private'">
				<xsl:text>[pm.address.type.private]: </xsl:text>
			</xsl:if>
			<xsl:if test="./@type='work'">
				<xsl:text>[pm.address.type.work]: </xsl:text>
			</xsl:if>
			<xsl:value-of select="import:street/@number"/>
			<xsl:text>, </xsl:text>
			<xsl:value-of select="import:street/@name"/>
			<xsl:text>; </xsl:text>
			<xsl:value-of select="import:zip"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="import:locality"/>
			<xsl:text>; </xsl:text>
			<xsl:value-of select="import:country"/> <!-- TODO Translation ??? -->
		</fo:block>
	</xsl:template>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Template to output patient phones
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<xsl:template match="import:gecamedData/import:patient/import:phone">
		<fo:block>
			<xsl:if test="./@type='private'">
				<xsl:text>[pm.phoneShort]: </xsl:text>  
			</xsl:if>
			<xsl:if test="./@type='mobile'">
				<xsl:text>[pm.cellular]: </xsl:text>
			</xsl:if>
			<xsl:if test="./@type='office'">
				<xsl:text>[pm.office]: </xsl:text>
			</xsl:if>
			<xsl:if test="./@type='fax'">
				<xsl:text>[pm.fax]: </xsl:text>
			</xsl:if>
			<xsl:value-of select="." />
		</fo:block>		
	</xsl:template>
	
	<xsl:template match="import:gecamedData/import:patient/import:id">
			<fo:block>
				<xsl:if test="./@type='gecamed_origin'">
					<xsl:text>[pm.idGECAM]: </xsl:text>
				</xsl:if>
				<xsl:if test="./@type='medecin_referent'">
					<xsl:text>[pm.idMR]: </xsl:text>
				</xsl:if>
				<xsl:if test="./@type='ris'">
					<xsl:text>[pm.idRIS]: </xsl:text>
				</xsl:if>
				<xsl:if test="./@type='luxembourg'">
					<xsl:text>[pm.idLux]: </xsl:text>
				</xsl:if>
				<xsl:value-of select="." />
			</fo:block>			
	</xsl:template>
	
	<xsl:template match="import:gecamedData/import:patient/import:incident">
		<fo:block>
			<xsl:value-of select="position()" />
			<xsl:text> </xsl:text> 
			<xsl:value-of select="@id" />
			<xsl:text> </xsl:text>
			<xsl:value-of select="import:incidentDate" />
			<xsl:text> </xsl:text>
			<xsl:call-template name="searchPhysician">
   				<xsl:with-param name="physicianID" select="import:physicianID"/>
			</xsl:call-template>
			<!-- <xsl:apply-templates select="import:physicianID"/> -->
			<!-- <xsl:value-of select="import:physicianID" />  -->
		</fo:block>
	</xsl:template>
	
	<xsl:template name="TodaysDate">
    <xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new
        ('MMMM d, yyyy - HH:mm'), java:java.util.Date.new())"/>
	</xsl:template>
	
	<xsl:template match="/">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<fo:simple-page-master master-name="A4" page-height="297mm" page-width="210mm" margin="10mm">
					<fo:region-body region-name="body" margin="15mm" />
					<fo:region-before region-name="header" extent="30mm" />
					<fo:region-after region-name="footer" extent="12mm" />
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="A4">
				<fo:static-content flow-name="header" font-family="{$font}" font-size="{$fontSize10}">
					<fo:block text-align="center">
						<xsl:attribute name="border-bottom">thin solid #a0a8b5</xsl:attribute>
						[$physician]
						 | [patientExport.print.exerptRecord]
						- <xsl:value-of select="import:gecamedData/import:patient/import:firstName" />
						<xsl:text> </xsl:text>
						<xsl:value-of select="import:gecamedData/import:patient/import:lastName" />
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="footer" font-family="{$font}" font-size="{$fontSize10}">
					<fo:block text-align="center">
						<xsl:attribute name="border-top">thin solid #a0a8b5</xsl:attribute>
						<xsl:call-template name="TodaysDate"/> | <fo:page-number/> / <fo:page-number-citation ref-id="LastPage"/> | print by GECAMed www.tudor.lu
					</fo:block>
				</fo:static-content>
				<fo:flow flow-name="body" font-family="{$font}" font-size="{$fontSize12}">
					<!-- <fo:block font-family="{$fontArial}" font-size="{$fontSize10}">Arial</fo:block>
					<fo:block font-family="{$fontArial}" font-size="{$fontSize12}">Arial</fo:block>
					<fo:block font-family="{$fontArial}" font-size="{$fontSize14}">Arial</fo:block>
					<fo:block font-family="{$fontArial}" font-size="{$fontSize18}">Arial</fo:block>
					<fo:block font-family="{$fontNTR}" font-size="{$fontSize10}">Times New Roman</fo:block>
					<fo:block font-family="{$fontNTR}" font-size="{$fontSize12}">Times New Roman</fo:block>
					<fo:block font-family="{$fontNTR}" font-size="{$fontSize14}">Times New Roman</fo:block>
					<fo:block font-family="{$fontNTR}" font-size="{$fontSize18}">Times New Roman</fo:block>
					<fo:block font-family="{$fontV}" font-size="{$fontSize10}">Verdana</fo:block>
					<fo:block font-family="{$fontV}" font-size="{$fontSize12}">Verdana</fo:block>
					<fo:block font-family="{$fontV}" font-size="{$fontSize14}">Verdana</fo:block>
					<fo:block font-family="{$fontV}" font-size="{$fontSize18}">Verdana</fo:block>
					<fo:block font-family="{$fontH}" font-size="{$fontSize10}">Helvetica</fo:block>
					<fo:block font-family="{$fontH}" font-size="{$fontSize12}">Helvetica</fo:block>
					<fo:block font-family="{$fontH}" font-size="{$fontSize14}">Helvetica</fo:block>
					<fo:block font-family="{$fontH}" font-size="{$fontSize18}">Helvetica</fo:block>
					 -->
					<!-- Headline of page -->
					<fo:block font-weight="bold" font-size="{$fontSize18}">
						<xsl:attribute name="space-after"><xsl:value-of select="$space5"/></xsl:attribute>
						[patientExport.print.exerptRecord]
					</fo:block>
					<!-- load base64 image | it not work if the images big and not in pdf and rtf
					<fo:block>
						<xsl:variable name="imageData" select="import:gecamedData/import:patient/import:photo" />
						<fo:inline>
						<fo:external-graphic src="url('data:image/jpeg;base64,{$imageData}')" />
						</fo:inline>
					</fo:block>
					-->
					<!-- Patient main data -->
					<fo:block>
						<!-- Name -->
						<fo:block font-weight="bold" font-size="{$fontSize14}">
							<xsl:attribute name="color"><xsl:value-of select="$colorBlue"/></xsl:attribute>
							[pm.patient]: <xsl:value-of select="import:gecamedData/import:patient/import:title/@translation" />
							<xsl:text> </xsl:text>
							<xsl:value-of select="import:gecamedData/import:patient/import:firstName" />
							<xsl:text> </xsl:text>
							<xsl:value-of select="import:gecamedData/import:patient/import:lastName" />
						</fo:block>
						<!-- ID's -->
						<xsl:apply-templates select="import:gecamedData/import:patient/import:id"/>	
						<!-- Gender -->
						<fo:block>
							[pm.gender]: <xsl:value-of select="import:gecamedData/import:patient/import:gender" /> <!-- TODO Translation ??? -->
						</fo:block> 
						<!-- SSN -->
						<fo:block>
							[pm.socialNumber]: <xsl:value-of select="import:gecamedData/import:patient/import:matricule" />														
						</fo:block>
						<!-- Birthday -->
						<fo:block>
							<xsl:attribute name="space-after"><xsl:value-of select="$space3"/></xsl:attribute>
							[pm.dateOfBirth]: <xsl:value-of select="substring-before(import:gecamedData/import:patient/import:birthday,'+')" />
						</fo:block>						
						<!-- Address -->
						<xsl:if test="count(import:gecamedData/import:patient/import:address) &gt; 0">
							<fo:block>
								<xsl:attribute name="space-after"><xsl:value-of select="$space3"/></xsl:attribute>
								<fo:block font-weight="bold">[pm.addressInfo]</fo:block>
								<xsl:apply-templates select="import:gecamedData/import:patient/import:address"/>
							</fo:block>
						</xsl:if>
						<!-- Additional Infos -->
						<fo:block>
							<xsl:attribute name="space-after"><xsl:value-of select="$space3"/></xsl:attribute>
							<fo:block font-weight="bold">
								[pm.additionalInfo]
							</fo:block>
							<fo:block>
								[pm.insurance]: <xsl:value-of select="import:gecamedData/import:patient/import:insurance/@name" />
							</fo:block>
							<fo:block>
								[pm.complementary]: <xsl:value-of select="import:gecamedData/import:patient/import:complementaryInsurance/@name" />
							</fo:block>
							<fo:block>
								[pm.maritalStatus]: <xsl:value-of select="import:gecamedData/import:patient/import:maritalStatus" />
							</fo:block>
							<fo:block>
								[pm.nrOfChildren]: <xsl:value-of select="import:gecamedData/import:patient/import:childrenNumber" />
							</fo:block>
							<fo:block>
								[pm.job]: <xsl:value-of select="import:gecamedData/import:patient/import:job" />
							</fo:block>
							<fo:block>
								[pm.nationality]: <xsl:value-of select="import:gecamedData/import:patient/import:nationality" />
							</fo:block>
						</fo:block>
						<!-- Contact data -->
						<xsl:if test="count(import:gecamedData/import:patient/import:phone) &gt; 0 or count(import:gecamedData/import:patient/import:phone) &gt; 0">
							<fo:block>
								<xsl:attribute name="space-after"><xsl:value-of select="$space3"/></xsl:attribute>
								<fo:block font-weight="bold">[pm.contact]</fo:block>
								<xsl:apply-templates select="import:gecamedData/import:patient/import:phone"/>
								<fo:block>
									[pm.mail]: <xsl:value-of select="import:gecamedData/import:patient/import:email" />
								</fo:block>
							</fo:block>
						</xsl:if>
						<!-- Main insurant / Guarantor -->
						<xsl:if test="count(import:gecamedData/import:patient/import:guarantor) &gt; 0">
						<fo:block>
							<xsl:attribute name="space-after"><xsl:value-of select="$space3"/></xsl:attribute>
							<!-- TODO if main_insurant -->
							<fo:block font-weight="bold">
								[pm.main_insurant]
							</fo:block>
							<fo:block>
								[pm.name]: <xsl:value-of select="import:gecamedData/import:patient/import:guarantor/import:guarantorName"/>
							</fo:block>
							<fo:block>
								[pm.address]: <xsl:value-of select="import:gecamedData/import:patient/import:guarantor/import:address/import:street/@number"/>
								<xsl:text>, </xsl:text>
								<xsl:value-of select="import:gecamedData/import:patient/import:guarantor/import:address/import:street/@name"/>
								<xsl:text>; </xsl:text>
								<xsl:value-of select="import:gecamedData/import:patient/import:guarantor/import:address/import:zip"/>
								<xsl:text> </xsl:text>
								<xsl:value-of select="import:gecamedData/import:patient/import:guarantor/import:address/import:locality"/>
								<xsl:text>; </xsl:text>
								<xsl:value-of select="import:gecamedData/import:patient/import:guarantor/import:address/import:country"/> <!-- TODO Übersetzung benötigt ??? --> 
							</fo:block>
						</fo:block>
						</xsl:if>
						<!-- Main physician -->
						<fo:block>
							<xsl:attribute name="space-after"><xsl:value-of select="$space3"/></xsl:attribute>
							<xsl:call-template name="searchPhysician">
	   							<xsl:with-param name="physicianID" select="import:gecamedData/import:patient/import:physicianID"/>
								<xsl:with-param name="style" select="1"/>
							</xsl:call-template>
						</fo:block>
						<!-- Treated physicians -->
						 <fo:block>
							<xsl:attribute name="space-after"><xsl:value-of select="$space3"/></xsl:attribute>
							<xsl:if test="(count(import:gecamedData/import:physician) + count(import:gecamedData/import:patient/import:otherPhysicians)) &gt; 1">
								<fo:block font-weight="bold">
									[pm.otherDoctors]
								</fo:block>
							</xsl:if>
							<xsl:apply-templates select="/import:gecamedData/import:physician">
	   							<xsl:with-param name="mainPhysicianID" select="import:gecamedData/import:patient/import:physicianID"/>
							</xsl:apply-templates>
						</fo:block>
						<!-- Other Physicians  -->
						<xsl:if test="import:gecamedData/import:patient/import:otherPhysicians != ''">
							<fo:block>
								<xsl:attribute name="space-after"><xsl:value-of select="$space3"/></xsl:attribute>
								<fo:block font-weight="bold">
									<!-- no headline here -->
								</fo:block>
								<fo:block linefeed-treatment="preserve">
									<xsl:attribute name="font-size"><xsl:value-of select="$fontSize12"/></xsl:attribute>
									<xsl:attribute name="font-family"><xsl:value-of select="$font"/></xsl:attribute>
									<xsl:value-of select="import:gecamedData/import:patient/import:otherPhysicians"/>
								</fo:block>
							</fo:block>
						</xsl:if>
					</fo:block>
					<!-- Patient allergies -->
					<xsl:if test="(count(import:gecamedData/import:patient/import:allergy)) != 0">
						<fo:block page-break-before="always">
							<xsl:attribute name="space-after"><xsl:value-of select="$space3"/></xsl:attribute>
							<fo:block font-weight="bold">
								<xsl:attribute name="font-size"><xsl:value-of select="$fontSize14"/></xsl:attribute>
								<xsl:attribute name="color"><xsl:value-of select="$colorBlue"/></xsl:attribute>
								[patient.allergy.allergies]
							</fo:block>
							<xsl:for-each select="import:gecamedData/import:patient/import:allergy">
								<fo:block>
									<xsl:value-of select="import:allergen" />
									<xsl:text> </xsl:text>
									<xsl:value-of select="import:comment" />
								</fo:block>
							</xsl:for-each>
						</fo:block>
					</xsl:if>
					<!-- Active problems -->
					<xsl:if test="(count(import:gecamedData/import:patient/import:activeProblems)) != 0">
						<fo:block>
							<xsl:attribute name="space-after"><xsl:value-of select="$space3"/></xsl:attribute>
							<fo:block font-weight="bold">
								<xsl:attribute name="font-size"><xsl:value-of select="$fontSize14"/></xsl:attribute>
								<xsl:attribute name="color"><xsl:value-of select="$colorBlue"/></xsl:attribute>
								[patient.activeproblems]
							</fo:block>
							<xsl:for-each select="import:gecamedData/import:patient/import:activeProblems">
								<fo:block linefeed-treatment="preserve" >
								<xsl:attribute name="font-size"><xsl:value-of select="$fontSize12"/></xsl:attribute>
									<xsl:attribute name="font-family"><xsl:value-of select="$font"/></xsl:attribute>
									<xsl:value-of select="." />
								</fo:block>
							</xsl:for-each>
						</fo:block>
					</xsl:if>
					<!-- Chronical treatments -->
					<xsl:if test="(count(import:gecamedData/import:patient/import:chronicalTreatments)) != 0">
						<fo:block>
							<xsl:attribute name="space-after"><xsl:value-of select="$space3"/></xsl:attribute>
							<fo:block font-weight="bold">
								<xsl:attribute name="font-size"><xsl:value-of select="$fontSize14"/></xsl:attribute>
								<xsl:attribute name="color"><xsl:value-of select="$colorBlue"/></xsl:attribute>
								[patient.cronicaltreatment]
							</fo:block>
							<xsl:for-each select="import:gecamedData/import:patient/import:chronicalTreatments">
								<fo:block linefeed-treatment="preserve">
									<xsl:attribute name="font-size"><xsl:value-of select="$fontSize12"/></xsl:attribute>
									<xsl:attribute name="font-family"><xsl:value-of select="$font"/></xsl:attribute>
									<xsl:value-of select="." />
								</fo:block>
							</xsl:for-each>
						</fo:block>
					</xsl:if>
					<!-- Antecedent -->
					<xsl:if test="(count(import:gecamedData/import:patient/import:antecedent)) != 0">
						<fo:block>
							<xsl:attribute name="space-after"><xsl:value-of select="$space3"/></xsl:attribute>
							<fo:block font-weight="bold">
								<xsl:attribute name="font-size"><xsl:value-of select="$fontSize14"/></xsl:attribute>
								<xsl:attribute name="color"><xsl:value-of select="$colorBlue"/></xsl:attribute>
								[patient.antecedents]
							</fo:block>
							<xsl:for-each select="import:gecamedData/import:patient/import:antecedent">
								<fo:block>
								<xsl:attribute name="space-after"><xsl:value-of select="$space1"/></xsl:attribute>
								<fo:block font-weight="bold">
									<xsl:attribute name="space-after"><xsl:value-of select="$space1"/></xsl:attribute>
									<xsl:value-of select="import:antecedentTitle" />
								</fo:block>
								<fo:block linefeed-treatment="preserve">
									<xsl:attribute name="font-size"><xsl:value-of select="$fontSize12"/></xsl:attribute>
									<xsl:attribute name="font-family"><xsl:value-of select="$font"/></xsl:attribute>
									<xsl:value-of select="import:description" />
								</fo:block>
								</fo:block>
							</xsl:for-each>
						</fo:block>
					</xsl:if>
					<!-- Patient history -->
					<xsl:if test="(count(import:gecamedData/import:patient/import:incident)) != 0">
						<fo:block font-weight="bold">
							<xsl:attribute name="font-size"><xsl:value-of select="$fontSize14"/></xsl:attribute>
							<xsl:attribute name="color"><xsl:value-of select="$colorBlue"/></xsl:attribute>
							[patient.history]
						</fo:block>
					<fo:block space-after="5mm">
							<fo:table>
								<fo:table-column column-width="25mm" />
								<fo:table-column column-width="10mm" />
								<fo:table-column column-width="10mm" />
								<fo:table-column column-width="105mm"/>
								<fo:table-body>
									<xsl:for-each select="import:gecamedData/import:patient/import:incident">
									<!-- color the background of the row -->
									<xsl:variable name="rowColor">
								      <xsl:choose>
								        <xsl:when test="position() mod 2 = 1">#ffffff</xsl:when>
								        <xsl:otherwise>#83bdf8</xsl:otherwise> <!-- org frabe gecamed #edf3fe zu hell -->
								      </xsl:choose>
								   	</xsl:variable>
								  	<!-- accident -->
								  	<xsl:call-template name="accident">
   										<xsl:with-param name="rowColor" select="$rowColor"/>
   										<xsl:with-param name="showIncidentsCells" select="0"/>	
									</xsl:call-template>
									<!-- s.o.a.p and formeditor -->
									<xsl:apply-templates select="import:entry">
   										<xsl:with-param name="rowColor" select="$rowColor"/>
   										<xsl:with-param name="showIncidentsCells" select="count(import:accidentParentId) + count(import:accidentDate) + count(import:accidentNr)"/>
									</xsl:apply-templates>
									<!-- measurement -->
									<xsl:apply-templates select="import:measurement">
   										<xsl:with-param name="rowColor" select="$rowColor"/>
   										<xsl:with-param name="showIncidentsCells" select="count(import:accidentParentId) + count(import:accidentDate) + count(import:accidentNr) + count(import:entry)"/>
									</xsl:apply-templates>
									<!-- prescription -->
									<xsl:apply-templates select="import:prescription">
   										<xsl:with-param name="rowColor" select="$rowColor"/>
   										<xsl:with-param name="showIncidentsCells" select="count(import:accidentParentId) + count(import:accidentDate) + count(import:accidentNr) + count(import:entry) + count(import:measurement)"/>
									</xsl:apply-templates>		
									<!-- file and letter -->
									<xsl:apply-templates select="import:fileEntry">
   										<xsl:with-param name="rowColor" select="$rowColor"/>
   										<xsl:with-param name="showIncidentsCells" select="count(import:accidentParentId) + count(import:accidentDate) + count(import:accidentNr) + count(import:entry) + count(import:measurement) + count(import:prescription)"/>
									</xsl:apply-templates>
									<!-- space row -->
									<fo:table-row height="5mm">
									<fo:table-cell>
									<fo:block>
										<xsl:attribute name="space-after"><xsl:value-of select="$space10"/></xsl:attribute>
									</fo:block>
									</fo:table-cell>
									<fo:table-cell>
									<fo:block>
									</fo:block>
									</fo:table-cell>
									<fo:table-cell>
									<fo:block>
									</fo:block>
									</fo:table-cell>
									<fo:table-cell>
									<fo:block>
									</fo:block>
									</fo:table-cell>
									</fo:table-row>
									</xsl:for-each>
								</fo:table-body>
							</fo:table>
					</fo:block>
					</xsl:if>
					<fo:block id="LastPage"/>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Template to render the accident of a incident. Two different types of accident accidentParentId and
	// accidentNrDate.
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<xsl:template name="accident">
		<xsl:param name="rowColor"/>
		<xsl:param name="showIncidentsCells"/>
		<xsl:if test="./import:accidentParentId != ''">
			<xsl:call-template name="accidentParentId">
				<xsl:with-param name="rowColor" select="$rowColor"/>
	   			<xsl:with-param name="showIncidentsCells" select="$showIncidentsCells"/>
			</xsl:call-template>
		</xsl:if>
		<xsl:if test="./import:accidentNr != '' or ./import:accidentDate != ''">
			<xsl:call-template name="accidentNrDate">
				<xsl:with-param name="rowColor" select="$rowColor"/>
	   			<xsl:with-param name="showIncidentsCells" select="$showIncidentsCells"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Template to render accidentParentId 
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<xsl:template name="accidentParentId">
		<xsl:param name="rowColor"/>
		<xsl:param name="showIncidentsCells"/>
		<fo:table-row>
			<xsl:choose>
				<xsl:when test="$showIncidentsCells &lt; 1">
						<xsl:attribute name="border-top">medium solid #a0a8b5</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<xsl:attribute name="border-bottom">thin solid #a0a8b5</xsl:attribute>
			<xsl:choose>
			<xsl:when test="$showIncidentsCells &lt; 1">
				<!-- col 1 Date cell -->
				<fo:table-cell>
						<fo:block>
							<xsl:value-of select="substring-before(./import:incidentDate,'T')" />
						</fo:block>
				</fo:table-cell>
				<!-- col 2 Physician cell-->
				<fo:table-cell>
						<fo:block font-size="70%">
							<xsl:call-template name="searchPhysician">
		  					   <xsl:with-param name="physicianID" select="./import:physicianID"/>
							   <xsl:with-param name="style" select="0"/>
							</xsl:call-template>
						</fo:block>
				</fo:table-cell>
			</xsl:when>
			<xsl:otherwise>
				<!-- col 1 Date cell -->
				<fo:table-cell>
				<!-- do nothing -->
				</fo:table-cell>
				<!-- col 2 Physician cell -->
				<fo:table-cell>
				<!-- do nothing -->
				</fo:table-cell>
			</xsl:otherwise>
		</xsl:choose>
			<fo:table-cell>
				<fo:block font-weight="bold">
				Ac
				</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<xsl:call-template name="searchAccidentParentId">
		  			<xsl:with-param name="parentID" select="./import:accidentParentId"/>
				</xsl:call-template>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Template to render accidentNrDate
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<xsl:template name="accidentNrDate">
		<xsl:param name="rowColor"/>
		<xsl:param name="showIncidentsCells"/>
		<fo:table-row>
			<xsl:choose>
				<xsl:when test="$showIncidentsCells &lt; 1">
					<xsl:attribute name="border-top">medium solid #a0a8b5</xsl:attribute>
				</xsl:when>
			</xsl:choose>
			<xsl:attribute name="border-bottom">thin solid #a0a8b5</xsl:attribute>
			<xsl:choose>
			<xsl:when test="$showIncidentsCells &lt; 1">
				<!-- col 1 Date cell -->
				<fo:table-cell>
						<fo:block>
							<xsl:value-of select="substring-before(./import:incidentDate,'T')" />
						</fo:block>
				</fo:table-cell>
				<!-- col 2 Physician cell-->
				<fo:table-cell>
					<fo:block font-size="70%">
						<xsl:call-template name="searchPhysician">
	  					   <xsl:with-param name="physicianID" select="./import:physicianID"/>
						   <xsl:with-param name="style" select="0"/>
						</xsl:call-template>
					</fo:block>
				</fo:table-cell>
			</xsl:when>
			<xsl:otherwise>
				<!-- col 1 Date cell -->
				<fo:table-cell>
				<!-- do nothing -->
				</fo:table-cell>
				<!-- col 2 Physician cell -->
				<fo:table-cell>
				<!-- do nothing -->
				</fo:table-cell>
			</xsl:otherwise>
		</xsl:choose>
			<fo:table-cell>
				<fo:block font-weight="bold">Ac</fo:block>
			</fo:table-cell>
			<fo:table-cell>
				<fo:block>
					<xsl:if test="./import:accidentNr != ''">
					<xsl:value-of select="./import:accidentNr "/>
				<xsl:text> | </xsl:text>
			</xsl:if>
					 <xsl:value-of select="substring-before(./import:accidentDate,'T') "/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Template to search and output a accident parent 
	// param: parentID - the id of another incidents
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<xsl:template name="searchAccidentParentId">
		<xsl:param name="parentID"/>
		<fo:block>
			<xsl:value-of select="$parentID"/>
		</fo:block>
		<xsl:for-each select="/import:gecamedData/import:patient/import:incident">
			<xsl:if test="./@id=$parentID">
				<fo:block font-weight="bold">
					[id gefunden]
					<xsl:if test="./import:accidentNr != ''">
					<xsl:value-of select="./import:accidentNr "/>
				<xsl:text> | </xsl:text>
				
				</xsl:if>
					 <xsl:value-of select="substring-before(./import:accidentDate,'T') "/>
				</fo:block>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Template to render incident entries s.o.a.p and formeditor
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<xsl:template match="import:entry">
		<xsl:param name="rowColor"/>
		<xsl:param name="showIncidentsCells"/>
		<fo:table-row>
			<xsl:choose>
				<xsl:when test="$showIncidentsCells &lt; 1">
					<xsl:if test="(position( )) = 1">
						<xsl:attribute name="border-top">medium solid #a0a8b5</xsl:attribute>
					</xsl:if>
				</xsl:when>
			</xsl:choose>
			<xsl:attribute name="border-bottom">thin solid #a0a8b5</xsl:attribute>
			<xsl:choose>
			<xsl:when test="$showIncidentsCells &lt; 1">
				<!-- col 1 Date cell -->
				<fo:table-cell>
					<xsl:if test="(position( )) = 1"> <!-- print cell only first time -->
						<fo:block>
							<xsl:value-of select="substring-before(../import:incidentDate,'T')" />
						</fo:block>
					</xsl:if>
				</fo:table-cell>
				<!-- col 2 Physician cell-->
				<fo:table-cell>
					<xsl:if test="(position( )) = 1"> <!-- print cell only first time -->
						<fo:block font-size="70%">
							<xsl:call-template name="searchPhysician">
		  					   <xsl:with-param name="physicianID" select="../import:physicianID"/>
							   <xsl:with-param name="style" select="0"/>
							</xsl:call-template>
						</fo:block>
					</xsl:if>
				</fo:table-cell>
			</xsl:when>
			<xsl:otherwise>
				<!-- col 1 Date cell -->
				<fo:table-cell>
				<!-- do nothing -->
				</fo:table-cell>
				<!-- col 2 Physician cell -->
				<fo:table-cell>
				<!-- do nothing -->
				</fo:table-cell>
			</xsl:otherwise>
		</xsl:choose>
			<!-- col 3 Incident type cell -->
			<fo:table-cell>							
				<xsl:variable name="soaptype" select="./@type" />
				<xsl:if test="contains($soaptype,'soap.s')">
					<fo:block font-weight="bold">
						<xsl:text>[$soap.s]</xsl:text>
					</fo:block>	
				</xsl:if>
				<xsl:if test="contains($soaptype,'soap.o')">
					<fo:block font-weight="bold">
						<xsl:text>[$soap.o]</xsl:text>
					</fo:block>	
				</xsl:if>
				<xsl:if test="contains($soaptype,'soap.a')">
					<fo:block font-weight="bold">
						<xsl:text>[$soap.a]</xsl:text>
					</fo:block>	
				</xsl:if>
				<xsl:if test="contains($soaptype,'soap.p')">
					<fo:block font-weight="bold">
						<xsl:text>[$soap.p]</xsl:text>
					</fo:block>	
				</xsl:if>
				<xsl:if test="contains($soaptype,'cons.1')">
					<fo:block font-weight="bold">
						<xsl:text>[$cons.1]</xsl:text>
					</fo:block>	
				</xsl:if>
				<xsl:if test="contains($soaptype,'cons.2')">
					<fo:block font-weight="bold">
						<xsl:text>[$cons.2]</xsl:text>
					</fo:block>	
				</xsl:if>
				<xsl:if test="contains($soaptype,'cons.3')">
					<fo:block font-weight="bold">
						<xsl:text>[$cons.3]</xsl:text>
					</fo:block>	
				</xsl:if>
				<xsl:if test="contains($soaptype,'sick_leave')">
					<fo:block font-weight="bold">
						<xsl:text>[$sick_leave]</xsl:text>
					</fo:block>	
				</xsl:if>
				<xsl:if test="contains($soaptype,'form')">
					<fo:block font-weight="bold">
						<xsl:text>Fm</xsl:text>
					</fo:block>
				</xsl:if>
			</fo:table-cell>
			<!-- col 4 Incident entry text cell-->
			<fo:table-cell>
				<xsl:variable name="soaptype" select="./@type" />
				<xsl:choose>
					<xsl:when test="contains($soaptype,'sick_leave') and count(./import:code) &gt; 0">
						<fo:block>
							<xsl:value-of select="./import:code" />
							<xsl:text> | </xsl:text>
							<xsl:value-of select="substring-before(./import:sickLeaveStartDate,'+')" />
							<xsl:text> - </xsl:text>
							<xsl:value-of select="substring-before(./import:sickLeaveEndDate,'+')" />
						</fo:block>
					</xsl:when>
					<xsl:otherwise>
						<xsl:if test="count(./import:code) &gt; 0">
							<fo:block>
								<xsl:text>[pm.code] </xsl:text>
								<xsl:value-of select="./import:code" />
							</fo:block>	
						</xsl:if>
					</xsl:otherwise>
				</xsl:choose>
				<!-- text -->
				<fo:block linefeed-treatment="preserve">
					<xsl:attribute name="font-size"><xsl:value-of select="$fontSize12"/></xsl:attribute>
					<xsl:attribute name="font-family"><xsl:value-of select="$font"/></xsl:attribute>													
					<xsl:value-of select="./import:text" />
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:template>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Template to render incident entries prescription
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<xsl:template match="import:prescription">
		<xsl:param name="rowColor"/>
		<xsl:param name="showIncidentsCells"/>
		<fo:table-row>
			<xsl:choose>
				<xsl:when test="$showIncidentsCells &lt; 1">
					<xsl:if test="(position( )) = 1">
						<xsl:attribute name="border-top">medium solid #a0a8b5</xsl:attribute>
					</xsl:if>
				</xsl:when>
			</xsl:choose>
			<xsl:attribute name="border-bottom">thin solid #a0a8b5</xsl:attribute>
			<!-- <fo:table-row border-bottom="thin solid #000000"> -->
			<!-- <xsl:attribute name="background-color"><xsl:value-of select="$rowColor"/></xsl:attribute> -->
			<xsl:choose>
			<xsl:when test="$showIncidentsCells &lt; 1">
				<!-- col 1 Date cell -->
				<fo:table-cell>
					<xsl:if test="(position( )) = 1"> <!-- print cell only first time -->
						<fo:block>
							<xsl:value-of select="substring-before(../import:incidentDate,'T')" />
						</fo:block>
					</xsl:if>
				</fo:table-cell>
				<!-- col 2 Physician cell-->
				<fo:table-cell>
					<xsl:if test="(position( )) = 1"> <!-- print cell only first time -->
						<fo:block font-size="70%">
							<xsl:call-template name="searchPhysician">
		  					   <xsl:with-param name="physicianID" select="../import:physicianID"/>
							   <xsl:with-param name="style" select="0"/>
							</xsl:call-template>
						</fo:block>
					</xsl:if>
				</fo:table-cell>
			</xsl:when>
			<xsl:otherwise>
				<!-- col 1 Date cell -->
				<fo:table-cell>
				<!-- do nothing -->
				</fo:table-cell>
				<!-- col 2 Physician cell -->
				<fo:table-cell>
				<!-- do nothing -->
				</fo:table-cell>
			</xsl:otherwise>
		</xsl:choose>
			<!-- col 3 Incitent type-->
			<fo:table-cell>
				<fo:block font-weight="bold">
					<xsl:text>M</xsl:text>
				</fo:block>
			</fo:table-cell>
			<!-- col 4 Incident entry text cell -->
			<fo:table-cell>
				<fo:block linefeed-treatment="preserve">
					<xsl:attribute name="font-size"><xsl:value-of select="$fontSize12"/></xsl:attribute>
					<xsl:attribute name="font-family"><xsl:value-of select="$font"/></xsl:attribute>
					<xsl:value-of select="./import:prescriptionContent" />
				</fo:block>
			</fo:table-cell>
		</fo:table-row>							
	</xsl:template>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Template to render incident entries file and letter
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<xsl:template match="import:fileEntry">
		<xsl:param name="rowColor"/>
		<xsl:param name="showIncidentsCells"/>
		<!--<xsl:variable name="border">
			<xsl:choose>
				<xsl:when test="$showIncidentsCells &lt; 1">2px solid #FF0000</xsl:when>
				<xsl:otherwise>1px solid #000000</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>-->
		<fo:table-row>
			<xsl:choose>
				<xsl:when test="$showIncidentsCells &lt; 1">
					<xsl:if test="(position( )) = 1">
						<xsl:attribute name="border-top">medium solid #a0a8b5</xsl:attribute>
					</xsl:if>
				</xsl:when>
			</xsl:choose>
			<xsl:attribute name="border-bottom">thin solid #a0a8b5</xsl:attribute>	
			<!-- <fo:table-row border-bottom="thin solid #000000"> -->
			<!-- <xsl:attribute name="background-color"><xsl:value-of select="$rowColor"/></xsl:attribute> -->
			<xsl:choose>
			<xsl:when test="$showIncidentsCells &lt; 1">
				<!-- col 1 Date cell -->
				<fo:table-cell>
					<xsl:if test="(position( )) = 1"> <!-- print cell only first time -->
						<fo:block>
							<xsl:value-of select="substring-before(../import:incidentDate,'T')" />
						</fo:block>
					</xsl:if>
				</fo:table-cell>
				<!-- col 2 Physician cell-->
				<fo:table-cell>
					<xsl:if test="(position( )) = 1"> <!-- print cell only first time -->
						<fo:block font-size="70%">
							<xsl:call-template name="searchPhysician">
		  					   <xsl:with-param name="physicianID" select="../import:physicianID"/>
							   <xsl:with-param name="style" select="0"/>
							</xsl:call-template>
						</fo:block>
					</xsl:if>
				</fo:table-cell>
			</xsl:when>
			<xsl:otherwise>
				<!-- col 1 Date cell -->
				<fo:table-cell>
				<!-- do nothing -->
				</fo:table-cell>
				<!-- col 2 Physician cell -->
				<fo:table-cell>
				<!-- do nothing -->
				</fo:table-cell>
			</xsl:otherwise>
		</xsl:choose>						
			<!-- col 3 Incident type cell -->
			<fo:table-cell>
				<xsl:variable name="entrietype" select="./@type" />
				<xsl:if test="contains($entrietype,'file')">
					<fo:block font-weight="bold">
						<xsl:text>F</xsl:text>
					</fo:block>	
				</xsl:if>
				<xsl:if test="contains($entrietype,'letter')">
					<fo:block font-weight="bold">
						<xsl:text>L</xsl:text>
					</fo:block>
				</xsl:if>
			</fo:table-cell>
			<!-- col 3 entry text cell -->
			<fo:table-cell>
				<fo:block>													
					<xsl:value-of select="./import:text" />
				</fo:block>
				<fo:block>													
					<xsl:value-of select="./import:fileName" />
				</fo:block>
			</fo:table-cell>
		</fo:table-row>						
	</xsl:template>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Template to render incident entry measurement
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<!-- TODO pos after soap -->
	<xsl:template match="import:measurement">
		<xsl:param name="rowColor"/>
		<xsl:param name="showIncidentsCells"/>
		<!--<xsl:variable name="border">
			<xsl:choose>
				<xsl:when test="$showIncidentsCells &lt; 1">2px solid #FF0000</xsl:when>
				<xsl:otherwise>1px solid #000000</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>-->
		<fo:table-row>
			<xsl:choose>
				<xsl:when test="$showIncidentsCells &lt; 1">
					<xsl:if test="(position( )) = 1">
						<xsl:attribute name="border-top">medium solid #a0a8b5</xsl:attribute>
					</xsl:if>
				</xsl:when>
			</xsl:choose>
			<xsl:attribute name="border-bottom">thin solid #a0a8b5</xsl:attribute>	
			<!-- <fo:table-row border-bottom="thin solid #000000"> -->
			<!-- <xsl:attribute name="background-color"><xsl:value-of select="$rowColor"/></xsl:attribute> -->
			<xsl:choose>
			<xsl:when test="$showIncidentsCells &lt; 1">
				<!-- col 1 Date cell -->
				<fo:table-cell>
					<xsl:if test="(position( )) = 1"> <!-- print cell only first time -->
						<fo:block>
							<xsl:value-of select="substring-before(../import:incidentDate,'T')" />
						</fo:block>
					</xsl:if>
				</fo:table-cell>
				<!-- col 2 Physician cell-->
				<fo:table-cell>
					<xsl:if test="(position( )) = 1"> <!-- print cell only first time -->
						<fo:block font-size="70%">
							<xsl:call-template name="searchPhysician">
		  					   <xsl:with-param name="physicianID" select="../import:physicianID"/>
							   <xsl:with-param name="style" select="0"/>
							</xsl:call-template>
						</fo:block>
					</xsl:if>
				</fo:table-cell>
			</xsl:when>
			<xsl:otherwise>
				<!-- col 1 Date cell -->
				<fo:table-cell>
				<!-- do nothing -->
				</fo:table-cell>
				<!-- col 2 Physician cell -->
				<fo:table-cell>
				<!-- do nothing -->
				</fo:table-cell>
			</xsl:otherwise>
		</xsl:choose>						
			<!-- col 3 Incident type cell -->
			<fo:table-cell>
				<!--<xsl:variable name="entrietype" select="./@type" />
				<xsl:if test="contains($entrietype,'file')">
					<fo:block font-weight="bold">
						<xsl:text>F</xsl:text>
					</fo:block>	
				</xsl:if>
				<xsl:if test="contains($entrietype,'letter')">
					<fo:block font-weight="bold">
						<xsl:text>L</xsl:text>
					</fo:block>
				</xsl:if>
				-->
				<xsl:if test="(position( )) = 1">
					<fo:block font-weight="bold">
						<xsl:text>[$measurement]</xsl:text>
					</fo:block>
				</xsl:if>
			</fo:table-cell>
			<!-- col 3 entry text cell -->
			<fo:table-cell>
				<fo:block>													
					<xsl:value-of select="./@measurementType" /> 
					<xsl:text>: </xsl:text>
					<xsl:value-of select="./import:value" />
					<xsl:text> </xsl:text>
					<xsl:value-of select="./@unit" />
				</fo:block>
			</fo:table-cell>
		</fo:table-row>						
	</xsl:template>
	
	<!--
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	// Renders the first to cells of the incident entries because the cells represent infos of the incident
	// that are valid for all entries of the incident.
	///////////////////////////////////////////////////////////////////////////////////////////////////////
	-->
	<xsl:template name="renderIncidentCells">
		<xsl:param name="showIncidentsCells"/>
		<!--<xsl:choose>
			<xsl:when test="$showIncidentsCells &lt; 1">
				 col 1 Date cell 
				<fo:table-cell>
					<xsl:if test="(position( )) = 1">  print cell only first time 
						<fo:block>
							<xsl:value-of select="substring-before(../import:incidentDate,'T')" />
						</fo:block>
					</xsl:if>
				</fo:table-cell>
				 col 2 Physician cell
				<fo:table-cell>
					<xsl:if test="(position( )) = 1">  print cell only first time 
						<fo:block font-size="70%">
							<xsl:call-template name="searchPhysician">
		  					   <xsl:with-param name="physicianID" select="../import:physicianID"/>
							   <xsl:with-param name="style" select="0"/>
							</xsl:call-template>
						</fo:block>
					</xsl:if>
				</fo:table-cell>
			</xsl:when>
			<xsl:otherwise>
				 col 1 Date cell 
				<fo:table-cell>
				 do nothing 
				</fo:table-cell>
				 col 2 Physician cell 
				<fo:table-cell>
				 do nothing 
				</fo:table-cell>
			</xsl:otherwise>
		</xsl:choose>
	--></xsl:template>
</xsl:stylesheet>