/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.entity.beans;

import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

@Entity
@Table(name = "antibiotic", schema = "labo")

public class Antibiotic extends GECAMedEntityBean
	{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Integer	m_AntibiogramId;
	private String	m_Name;

	private Set <Reaction>	m_Reactions;

//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns the Id of the antibiogram this antibiotic is part of
 * @return the Id of the antibiogram this antibiotic is part of
 */
//---------------------------------------------------------------------------

@Column(name = "antibiogram_id", updatable=false, insertable=false)
public Integer getAntibiogramId()
	{
	return m_AntibiogramId;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Id of the antibiogram this antibiotic is to be part of
 * @param p_AntibiogramId specifies the new Id of the owning antibiogram
 */
//---------------------------------------------------------------------------

public void setAntibiogramId(Integer p_AntibiogramId)
	{
	m_AntibiogramId = p_AntibiogramId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the name of this antibiotic
 * @return the name of this antibiotic
 */
//---------------------------------------------------------------------------

@Column(name = "name")
public String getName()
	{
	return m_Name;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the name for this antibiotic
 * @param p_Name specifies the new name for this antibiotic
 */
//---------------------------------------------------------------------------

public void setName (String p_Name)
	{
	m_Name = p_Name;
	}

//---------------------------------------------------------------------------
/**
 * Returns the reactions of this antibiograms cultures to this antibiotic
 * Reactions are fetched eagerly
 * @return All the reactions to this antibiotic.
  */
//---------------------------------------------------------------------------

@OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
@JoinColumn(name = "antibiotic_id")
@OrderBy("sequenceNumber ASC")
public Set<Reaction> getReactions ()
	{
	return m_Reactions;
	}

//---------------------------------------------------------------------------
/**
 * Associates the specified set of reactions to this antibiotic
 * @param p_Reactions specifies the new set of reactions.
 */
//---------------------------------------------------------------------------

public void setReactions (Set<Reaction> p_Reactions )
	{
	m_Reactions = p_Reactions;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
