/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * @author nico.mack@tudor.lu
 * @since 08/03/17 
 */

@Entity
@Table(name = "labo_address", schema = "labo")

public class LaboratoryAddress extends GECAMedEntityBean
	{
	private static final long serialVersionUID = 1L;
	
	private Integer m_LaboratoryId;
	private String  m_StreetName;
	private String  m_StreetNumber;
	private String  m_PoBox;
	private String  m_Zip;
	private String  m_Locality;
	private Integer m_LocalityId;
	private String  m_Country;

//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns the Id of the laboratory this address is attached to
 * @return the Id of the laboratory this address is attached to
 */
//---------------------------------------------------------------------------

@Column(name = "laboratory_id", updatable=false, insertable=false)
public Integer getLaboratoryId()
	{
	return m_LaboratoryId;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Id of the laboratory this address is to be attached to
 * @param p_LaboratoryId specifies the new Id of the owning laboratory
 */
//---------------------------------------------------------------------------

public void setLaboratoryId(Integer p_LaboratoryId)
	{
	m_LaboratoryId = p_LaboratoryId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the name of the street defined by this address
 * @return the name of the street
 */
//---------------------------------------------------------------------------

@Column(name = "streetname")
public String getStreetName()
	{
	return m_StreetName;
	}

//---------------------------------------------------------------------------
/**
 * Sets the specified name as the new street name for this address
 * @param p_StreetName specifies the new street name
 */
//---------------------------------------------------------------------------

public void setStreetName (String p_StreetName)
	{
	m_StreetName = p_StreetName;
	}

//---------------------------------------------------------------------------
/**
 * Returns the street number defined by this address
 * @return the street number defined by this address
 */
//---------------------------------------------------------------------------

@Column(name = "streetnumber")
public String getStreetNumber()
	{
	return m_StreetNumber;
	}

//---------------------------------------------------------------------------
/**
 * Sets the specified number as the new street number for this address
 * @param p_StreetNumber specifies the new street number
 */
//---------------------------------------------------------------------------

public void setStreetNumber (String p_StreetNumber)
	{
	m_StreetNumber = p_StreetNumber;
	}

//---------------------------------------------------------------------------
/**
 * Returns the PO (Post Office) Box defined by this address
 * @return the PO Box defined by this address
 */
//---------------------------------------------------------------------------

@Column(name = "pobox")
public String getPoBox()
	{
	return m_PoBox;
	}

//---------------------------------------------------------------------------
/**
 * Sets the specified PO Box as the new PO Box for this address
 * @param p_PoBox specifies the new PO Box
 */
//---------------------------------------------------------------------------

public void setPoBox (String p_PoBox)
	{
	m_PoBox = p_PoBox;
	}

//---------------------------------------------------------------------------
/**
 * Returns the zip code defined by this address
 * @return the zip code defined by this address
 */
//---------------------------------------------------------------------------

@Column(name = "zip")
public String getZip()
	{
	return m_Zip;
	}

//---------------------------------------------------------------------------
/**
 * Sets the specified zip code as the new zip for this address
 * @param p_Zip specifies the new zip code
 */
//---------------------------------------------------------------------------

public void setZip (String p_Zip)
	{
	m_Zip = p_Zip;
	}

//---------------------------------------------------------------------------
/**
 * Returns the name of the locality defined by this address
 * @return the name of the locality defined by this address
 */
//---------------------------------------------------------------------------

@Column(name = "locality")
public String getLocality()
	{
	return m_Locality;
	}

//---------------------------------------------------------------------------
/**
 * Sets the specified name as the new locality name for this address
 * @param p_Locality specifies the new locality name
 */
//---------------------------------------------------------------------------

public void setLocality (String p_Locality)
	{
	m_Locality = p_Locality;
	}

//---------------------------------------------------------------------------
/**
 * Returns the Id of the locality defined by this address
 * @return the Id of the locality if zip/locality defined by this address could 
 * be matched with address database, <code>null</code> otherwise
 */
//---------------------------------------------------------------------------

@Column(name = "locality_id")
public Integer getLocalityId()
	{
	return m_LocalityId;
	}

//---------------------------------------------------------------------------
/**
 * Sets the specified Id as the new locality Id for this address
 * @param p_LocalityId specifies the new locality Id
 */
//---------------------------------------------------------------------------

public void setLocalityId (Integer p_LocalityId)
	{
	m_LocalityId = p_LocalityId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the name of the country defined by this address
 * @return the name of the country defined by this address
 */
//---------------------------------------------------------------------------

@Column(name = "country")
public String getCountry()
	{
	return m_Country;
	}

//---------------------------------------------------------------------------
/**
 * Sets the specified name as the new country name for this address
 * @param p_Country specifies the new country name
 */
//---------------------------------------------------------------------------

public void setCountry (String p_Country)
	{
	m_Country = p_Country;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
