/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.entity.beans;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

@Entity
@Table(name = "physician_key", schema = "labo")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = PhysicianKey.c_KeyByLabel, 		   query = "SELECT OBJECT(o) FROM PhysicianKey o WHERE o.label = :" + PhysicianKey.c_LabelParameter),
	@NamedQuery(name = PhysicianKey.c_KeysByPhysicianId,   query = "SELECT OBJECT(o) FROM PhysicianKey o WHERE o.physicianId = :" + PhysicianKey.c_PhysicianIdParameter),
	@NamedQuery(name = PhysicianKey.c_KeysByOfficeId,      query = "SELECT OBJECT(o) FROM PhysicianKey o WHERE o.officeId = :"    + PhysicianKey.c_OfficeIdParameter)
	})

	public class PhysicianKey extends GECAMedEntityBean
	{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private Integer   m_OfficeId;
	private Integer   m_PhysicianId;
	private String	  m_Label;
	private Date	  m_ExpiryDate;
	private String	  m_Password;
	private byte[]	  m_PEMPrivate;
	private byte[]	  m_PEMPublic;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	public static final transient String c_KeyByLabel	      = "getKeyLabel";
	public static final transient String c_KeysByPhysicianId  = "getKeysByPhysicianId";
	public static final transient String c_KeysByOfficeId     = "getKeysByOfficeId";

	public static final transient String c_LabelParameter	  		= "label";
	public static final transient String c_PhysicianIdParameter	    = "physicianId";
	public static final transient String c_OfficeIdParameter	    = "officeId";

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns the Id of the office this private key belongs to
 * @return the Id of the office this private key belongs to, or <code>null</code>
 * if private key is owned by a single physician
 */
//---------------------------------------------------------------------------

@Column(name = "office_id")
public Integer getOfficeId()
	{
	return m_OfficeId;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Id of the office this private key belongs to
 * @param p_OfficeId specifies the new Id of the owning office
 */
//---------------------------------------------------------------------------

public void setOfficeId(Integer p_OfficeId)
	{
	m_OfficeId = p_OfficeId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the Id of the phyisican this private key belongs to
 * @return the Id of the phyisican this private key belongs to, or <code>null</code>
 * if private key is owned by an office
 */
//---------------------------------------------------------------------------

@Column(name = "physician_id")
public Integer getPhysicianId()
	{
	return m_PhysicianId;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Id of the physician this private key belongs to
 * @param p_PhysicianId specifies the new Id of the owning physician
 */
//---------------------------------------------------------------------------

public void setPhysicianId(Integer p_PhysicianId)
	{
	m_PhysicianId = p_PhysicianId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the label or filename of this private key
 * @return This private key's label or filename
 */
//---------------------------------------------------------------------------

@Column (name ="label")

public String getLabel() 
	{
	return m_Label;
	}

//---------------------------------------------------------------------------
/**
 * Sets the label or filename of this private key
 * @param p_Label specifies the new label for this private key
 */
//---------------------------------------------------------------------------

public void setLabel (String p_Label) 
	{
	m_Label = p_Label;
	}

//---------------------------------------------------------------------------
/**
 * Returns this private key's expiry date
 * @return The date this private key expires, i.e. the date it looses its
 * validity.
 */
//---------------------------------------------------------------------------

@Column(name = "expiry")

public Date getExpiryDate() 
	{
	return m_ExpiryDate;
	}

//---------------------------------------------------------------------------
/**
 * Sets the specified date as this private key's expiry date
 * @param p_ExpiryDate specifies the new private key expiry date
 */
//---------------------------------------------------------------------------

public void setExpiryDate (Date p_ExpiryDate) 
	{
	m_ExpiryDate = (p_ExpiryDate != null) ? new Date (p_ExpiryDate.getTime()) : null;
	}

//---------------------------------------------------------------------------
/**
 * Returns the encrypted password of this private key
 * @return This private key's encrypted password
 */
//---------------------------------------------------------------------------

@Column (name ="password")

public String getPassword() 
	{
	return m_Password;
	}

//---------------------------------------------------------------------------
/**
 * Sets the encrypted password for this private key
 * @param p_Password specifies the new encrypted password for this private key
 */
//---------------------------------------------------------------------------

public void setPassword (String p_Password) 
	{
	m_Password = p_Password;
	}

//---------------------------------------------------------------------------
/**
 * Returns the PEM (Privacy Enhanced Mail) encoded data for the private key
 * @return The private key's PEM data
 */
//---------------------------------------------------------------------------

@Column(name = "pem_private")

public byte[] getPemPrivate () 
	{
	return m_PEMPrivate;
	}

//---------------------------------------------------------------------------
/**
 * Sets the PEM encoded data for this private key
 * @return p_PEMPrivate specifies the new PEM data for the  private key
 */
//---------------------------------------------------------------------------

public void setPemPrivate (byte[] p_PEMPrivate) 
	{
	m_PEMPrivate = p_PEMPrivate;
	}

//---------------------------------------------------------------------------
/**
 * Returns the PEM (Privacy Enhanced Mail) encoded data for the public key
 * @return The public key's PEM data
 */
//---------------------------------------------------------------------------

@Column(name = "pem_public")

public byte[] getPemPublic () 
	{
	return m_PEMPublic;
	}

//---------------------------------------------------------------------------
/**
 * Sets the PEM encoded data for the public key
 * @return p_PEMPublic specifies the new PEM data for the  public key
 */
//---------------------------------------------------------------------------

public void setPemPublic (byte[] p_PEMPublic) 
	{
	m_PEMPublic = p_PEMPublic;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
