/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

@Entity
@Table(name = "reaction", schema = "labo")

public class Reaction extends GECAMedEntityBean
	{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Integer	m_AntibioticId;
	private Integer m_SequenceNumber;
	private String	m_Interpretation;
	private String  m_MIC;
	private String  m_Unit;
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Returns the Id of the antibiotic this reaction refers to
 * @return the Id of the antibiotic this reaction referes to
 */
//---------------------------------------------------------------------------

@Column(name = "antibiotic_id", updatable=false, insertable=false)
public Integer getAntibioticId()
	{
	return m_AntibioticId;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the Id of the antibiotic this reaction refers to
 * @param p_AntibioticId specifies the new Id of the refering antibiotic
 */
//---------------------------------------------------------------------------

public void setAntibioticId (Integer p_AntibioticId)
	{
	m_AntibioticId = p_AntibioticId;
	}

//---------------------------------------------------------------------------
/**
 * Returns the sequence number for this reaction. The sequence number
 * corresponds to the sequence number of the culture in the antibiogram. The
 * sequence number links this reaction to the corresponding culture.
 * @return sequence number for this reaction.
 */
//---------------------------------------------------------------------------

@Column (name = "culture_seq_number")
public Integer getSequenceNumber ()
	{
	return m_SequenceNumber;	
	}

//---------------------------------------------------------------------------

public void setSequenceNumber (Integer p_SequenceNumber)
	{
	m_SequenceNumber = 	p_SequenceNumber;
	}

//---------------------------------------------------------------------------
/**
 * Returns the interpretation of this reaction. Reaction interpretation usually
 * is either Sensitive, Intermediate or Resistent.
 * @return this reaction's interpretation
 */
//---------------------------------------------------------------------------

@Column (name = "interpretation")
public String getInterpretation ()
	{
	return m_Interpretation;	
	}

//---------------------------------------------------------------------------
/**
 * Sets the interpretation of this reaction.
 * @param p_Interpretation specifies the value for this reaction's interpretation
 */
//---------------------------------------------------------------------------

public void setInterpretation (String p_Interpretation)
	{
	m_Interpretation =  p_Interpretation;
	}

//---------------------------------------------------------------------------
/**
 * Returns the MIC (Minimal Inhibiting Concentration) specified for this reaction.
 * @return this reaction's MIC value
 */
//---------------------------------------------------------------------------

@Column (name = "MIC")
public String getMic ()
	{
	return m_MIC;	
	}

//---------------------------------------------------------------------------
/**
 * Sets the MIC value for this reaction.
 * @param p_MIC specifies the new MIC value for this reaction
 */
//---------------------------------------------------------------------------

public void setMic (String p_MIC)
	{
	m_MIC =  p_MIC;
	}

//---------------------------------------------------------------------------
/**
 * Returns the unit of the MIC value for this reaction
 * @return the unit of this reaction's MIC value
 */
//---------------------------------------------------------------------------

@Column(name = "unit")
public String getUnit()
	{
	return m_Unit;
	}
	
//---------------------------------------------------------------------------
/**
 * Sets the unit of this reaction's MIC value
 * @param p_Unit specifies the new unit for this reaction's MIC value
 */
//---------------------------------------------------------------------------

public void setUnit (String p_Unit)
	{
	m_Unit = p_Unit;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
