/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.entity.beans;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

@Entity
@Table(name = "result_stub", schema = "labo")

@javax.persistence.NamedQueries 
	({
	@NamedQuery(name = ResultStub.c_ResultStubsForPhysician        ,  query = "SELECT OBJECT(o) FROM ResultStub o WHERE o.prescriberId = :" + ResultStub.c_PhysicianIdParameter +
			 																				                " ORDER BY o.downloaded DESC"),
	@NamedQuery(name = ResultStub.c_ResultStubsForPhysicianByPeriod,  query = "SELECT OBJECT(o) FROM ResultStub o WHERE o.prescriberId = :" + ResultStub.c_PhysicianIdParameter +
			 																				                " AND o.downloaded >= :" + ResultStub.c_BeginOfPeriodParameter +
																							                " AND o.downloaded <= :" + ResultStub.c_EndOfPeriodParameter +
																							                " ORDER BY o.downloaded DESC"),
	@NamedQuery(name = ResultStub.c_ResultStubsForPatient          ,  query = "SELECT OBJECT(o) FROM ResultStub o WHERE o.patientId = :" + ResultStub.c_PatientIdParameter +
			 																				                " ORDER BY o.examinationDate DESC")
	})

	public class ResultStub extends GECAMedEntityBean
	{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private Integer				m_LaboratoryId;
	private String				m_LaboratoryName;
	private Integer				m_PrescriberId;
	private Integer				m_PatientId;
	private String  			m_PatientFirstName;
	private String  			m_PatientName;
	private String				m_PatientSSN;
	private Integer				m_ResultNumber;
	private Date				m_PrescriptionDate;
	private Date				m_ExaminationDate;
	private Date				m_SpecimenDate;
	private Date				m_Downloaded;
	private String				m_Reference;
	private String				m_ExaminationStatus;
	private String				m_ResultStatus;

//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	public static final String c_ResultStubsForPhysician		 = "getResultStubsForPhysician";
	public static final String c_ResultStubsForPhysicianByPeriod = "getResultStubsForPhysicianByPeriod";
	public static final String c_ResultStubsForPatient		 	 = "getResultStubsForPatient";
	
	public static final String c_PhysicianIdParameter    = "PhysicianId";
	public static final String c_BeginOfPeriodParameter  = "BeginOfPeriod";
	public static final String c_EndOfPeriodParameter    = "EndOfPeriod";
	public static final String c_PatientIdParameter      = "PatientId";
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * returns the ID of the laboratory that performed the tests contained in 
 * this result
 * @return the ID of the laboratory that performed the tests
 */
//---------------------------------------------------------------------------

@Column(name = "laboratory_id", insertable =false, updatable = false)

public Integer getLaboratoryId()
	{
	return m_LaboratoryId;
	}

//---------------------------------------------------------------------------
/**
 * @param p_laboratoryId specifies the new ID of the performing laboratory to 
 * be set for this result.
 */
//---------------------------------------------------------------------------

public void setLaboratoryId (Integer p_laboratoryId)
	{
    m_LaboratoryId = p_laboratoryId;
	}

//---------------------------------------------------------------------------
/**
 * returns the name of the laboratory that performed the tests contained in 
 * this result
 * @return the name of the laboratory that performed the tests
 */
//---------------------------------------------------------------------------

@Column(name = "laboratory_name", insertable =false, updatable = false)

public String getLaboratoryName()
	{
	return m_LaboratoryName;
	}

//---------------------------------------------------------------------------
/**
 * @param p_laboratoryName specifies the new name of the performing laboratory to 
 * be set for this result.
 */
//---------------------------------------------------------------------------

public void setLaboratoryName (String p_laboratoryName)
	{
    m_LaboratoryName = p_laboratoryName;
	}

//---------------------------------------------------------------------------
/**
 * returns the ID of the physician who prescribed the laboratory tests stored 
 * in this result
 * @return the ID of the prescribing physician
 */
//---------------------------------------------------------------------------

@Column(name = "prescriber_id", insertable =false, updatable = false)

public Integer getPrescriberId()
	{
	return m_PrescriberId;
	}

//---------------------------------------------------------------------------
/**
 * Sets the ID of the prescribing physician for this result to one specified
 * @param p_PrescriberId specifies the new Id of the prescribing physician for
 * this result
 */
//---------------------------------------------------------------------------

public void setPrescriberId (Integer p_PrescriberId)
	{
	m_PrescriberId = p_PrescriberId;
	}
	
//---------------------------------------------------------------------------
/**
 * returns the ID of the patient the analysis at the origin of this result was
 * done for.
 * @return the ID of the patient the analysis was performed for.
 */
//---------------------------------------------------------------------------

@Column(name = "patient_id", insertable =false, updatable = false)

public Integer getPatientId()
	{
	return m_PatientId;
	}

//---------------------------------------------------------------------------
/**
 * Sets the ID of the patient the analysis was done for.
 * @param p_PatientId specifies the new Id of the patient.
 */
//---------------------------------------------------------------------------

public void setPatientId (Integer p_PatientId)
	{
	m_PatientId = p_PatientId;
	}
	
//---------------------------------------------------------------------------
/**
 * Returns the first name of the patient associated with this invoice stub
 * @return first name of patient this stub is associated with
 */
//---------------------------------------------------------------------------

@Column(name = "patient_first_name", insertable =false, updatable = false)

public String getPatientFirstName ()
	{
	return m_PatientFirstName;
	}

//---------------------------------------------------------------------------
/**
 * Sets the first name of the patient associated with this invoice stub
 * @param p_PatientFirstName specifies the first name of the patient this stub 
 * is associated with
 */
//---------------------------------------------------------------------------

public void setPatientFirstName (String p_PatientFirstName)
	{
	m_PatientFirstName = p_PatientFirstName;
	}

//---------------------------------------------------------------------------
/**
 * Returns the name of the patient associated with this invoice stub
 * @return name of patient this stub is associated with
 */
//---------------------------------------------------------------------------

@Column(name = "patient_name", insertable =false, updatable = false)

public String getPatientName ()
	{
	return m_PatientName;
	}

//---------------------------------------------------------------------------
/**
 * Sets the name of the patient associated with this invoice stub
 * @param p_PatientName specifies the name of the patient this stub 
 * is associated with
 */
//---------------------------------------------------------------------------

public void setPatientName (String p_PatientName)
	{
	m_PatientName = p_PatientName;
	}

//---------------------------------------------------------------------------
/**
 * Returns the social security number of the patient associated with this invoice stub
 * @return social security number of patient this stub is associated with
 */
//---------------------------------------------------------------------------

@Column(name = "patient_ssn", insertable =false, updatable = false)

public String getPatientSSN ()
	{
	return m_PatientSSN;
	}

//---------------------------------------------------------------------------
/**
 * Sets the social security number of the patient associated with this invoice stub
 * @param p_PatientSSN specifies the social security number of the patient 
 * this stub is associated with
 */
//---------------------------------------------------------------------------

public void setPatientSSN (String p_PatientSSN)
	{
	m_PatientSSN = p_PatientSSN;
	}


//---------------------------------------------------------------------------
/**
 * returns the number of the result which was contained in the downloaded
 * result file name.
 * @return the result number given to this result by the laboratory
 */
//---------------------------------------------------------------------------

@Column(name = "result_number")
public Integer getResultNumber()
	{
	return m_ResultNumber;
	}

//---------------------------------------------------------------------------
/**
 * Sets the number of the result which was contained in the downloaded
 * result file name.
 * @param p_ResultNumber specifies the new result number
 */
//---------------------------------------------------------------------------

public void setResultNumber(Integer p_ResultNumber)
	{
	m_ResultNumber = p_ResultNumber;
	}

//---------------------------------------------------------------------------
/**
 * returns the date the prescribing physician prescribed the tests contained
 * in this result
 * @return the prescription date
 */
//---------------------------------------------------------------------------

@Column(name = "prescription_date")
public Date getPrescriptionDate()
	{
	return m_PrescriptionDate;
	}

//---------------------------------------------------------------------------
/**
 * Sets the date the prescribing physician prescribed the tests contained in
 * this result
 * @param prescriptionDate specifies the new prescription date
 */
//---------------------------------------------------------------------------

public void setPrescriptionDate (Date p_PrescriptionDate)
	{
	m_PrescriptionDate = (p_PrescriptionDate != null) ? new Date (p_PrescriptionDate.getTime()) : null;
	}
	
//---------------------------------------------------------------------------
/**
 * returns the date the specimen or samples required for the tests were taken 
 * from the patient.
 * @return the date the samples were taken.
 */
//---------------------------------------------------------------------------

@Column(name = "specimen_date")
public Date getSpecimenDate()
	{
	return m_SpecimenDate;
	}

//---------------------------------------------------------------------------
/**
 * Sets the date the specimen or samples required for the tests were taken 
 * from the patient.
 * @param p_SpecimenDate specifies the new sampling date
 */
//---------------------------------------------------------------------------

public void setSpecimenDate (Date p_SpecimenDate)
	{
	m_SpecimenDate = (p_SpecimenDate != null) ? new Date (p_SpecimenDate.getTime()) : null;
	}
	
//---------------------------------------------------------------------------
/**
 * returns the date the specimen or samples were analyzed 
 * @return the date the samples were analyzed.
 */
//---------------------------------------------------------------------------

@Column(name = "examination_date")
public Date getExaminationDate()
	{
	return m_ExaminationDate;
	}

//---------------------------------------------------------------------------
/**
 * Sets the date the specimen or samples were analyzed
 * @param p_ExaminationDate specifies the new analyzing date
 */
//---------------------------------------------------------------------------

public void setExaminationDate (Date p_ExaminationDate)
	{
	m_ExaminationDate = (p_ExaminationDate != null) ? new Date (p_ExaminationDate.getTime()) : null;
	}

//---------------------------------------------------------------------------
/**
 * returns the date and time this result was downloaded
 * @return the date and time this result was downloaded
 */
//---------------------------------------------------------------------------

@Column(name = "downloaded")
public Date getDownloaded()
	{
	return m_Downloaded;
	}

//---------------------------------------------------------------------------
/**
 * Sets the date and time this result was downloaded
 * @param p_Downloaded specifies the new download date and time
 */
//---------------------------------------------------------------------------

public void setDownloaded (Date p_Downloaded)
	{
	m_Downloaded = (p_Downloaded != null) ? new Date (p_Downloaded.getTime()) : null;
	}

//---------------------------------------------------------------------------
/**
 * returns the reference defined by the laboratory to clearly identify this
 * result.
 * @return the reference given to this result by the laboratory
 */
//---------------------------------------------------------------------------

@Column(name = "reference")
public String getReference()
	{
	return m_Reference;
	}

//---------------------------------------------------------------------------
/**
 * Sets the reference to clearly identify this result.
 * @param p_Reference specifies the new reference
 */
//---------------------------------------------------------------------------

public void setReference(String p_Reference)
	{
	m_Reference = p_Reference;
	}

//---------------------------------------------------------------------------
/**
 * Returns the status of the examination (or analysis) that generated this
 * result
 * @return the status of the examination
 */
//---------------------------------------------------------------------------

@Column(name = "examination_status")
public String getExaminationStatus()
	{
	return m_ExaminationStatus;
	}

//---------------------------------------------------------------------------
/**
 * Sets the status of the examination that generated this result
 * @param p_ExaminationStatus specifies the new status
 */
//---------------------------------------------------------------------------

public void setExaminationStatus (String p_ExaminationStatus)
	{
	m_ExaminationStatus = p_ExaminationStatus;
	}
	
//---------------------------------------------------------------------------
/**
 * Returns the status of this result
 * @return the status of this result
 */
//---------------------------------------------------------------------------

@Column(name = "result_status")
public String getResultStatus()
	{
	return m_ResultStatus;
	}

//---------------------------------------------------------------------------
/**
 * Sets the status for this result
 * @param p_ResultStatus specifies the new status
 */
//---------------------------------------------------------------------------

public void setResultStatus (String p_ResultStatus)
	{
	m_ResultStatus = p_ResultStatus;
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
