/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.session.beans;

import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.persistence.NoResultException;

import lu.tudor.santec.gecamed.core.ejb.session.beans.GECAMedSessionBean;
import lu.tudor.santec.gecamed.labo.ejb.entity.beans.LaboratoryCertificate;
import lu.tudor.santec.gecamed.labo.ejb.entity.beans.PhysicianKey;
import lu.tudor.santec.gecamed.labo.ejb.session.interfaces.CryptoInterface;
import lu.tudor.santec.gecamed.labo.ejb.session.interfaces.ImportInterface;
import lu.tudor.santec.gecamed.labo.ejb.session.interfaces.LaboratoryInterface;
import lu.tudor.santec.gecamed.labo.utils.DecryptException;
import lu.tudor.santec.gecamed.labo.utils.PasswordEncrypter;
import lu.tudor.santec.gecamed.labo.utils.SmimeDecoder;

@Stateful
@Local (CryptoInterface.class)
@Remote (CryptoInterface.class)
public class CryptoBean extends GECAMedSessionBean implements CryptoInterface
	{
	/** the logger Object for this class */
//	private static Logger logger = Logger.getLogger(CryptoBean.class.getName());
	
//	private static Date		m_RootCertificateDate;
	
	@EJB
	LaboratoryInterface		m_LaboManager;
	
	private SmimeDecoder	m_SmimeDecoder      = null;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

@PostConstruct
public void postConstruct ()
	{
	if (m_SmimeDecoder == null)    m_SmimeDecoder      = new SmimeDecoder ();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public void setPasswordEncrypter (PasswordEncrypter p_Encrypter)
	{
	m_SmimeDecoder.setPasswordEncrpyter(p_Encrypter);
	}

//---------------------------------------------------------------------------

public PhysicianKey getKeyByLabel (String	p_Label) throws Exception
	{
	PhysicianKey l_Key = null;

	if (p_Label == null) return l_Key;
	
	try	{
		l_Key = (PhysicianKey) m_EntityManager.createNamedQuery(PhysicianKey.c_KeyByLabel)
									 		  .setParameter (PhysicianKey.c_LabelParameter,p_Label)
									 		  .setMaxResults (1)
									 		  .getSingleResult();
		}
	catch (NoResultException p_Exception)
		{
		l_Key = null;
		}

	return l_Key;
	}
	
//---------------------------------------------------------------------------

public void setupKeystore (PhysicianKey p_Key, String p_KeyPassword) throws Exception
	{
	if (p_Key == null) return;
	
	m_SmimeDecoder.setupKeystore (p_Key, p_KeyPassword, m_LaboManager);
	}

//---------------------------------------------------------------------------

public byte[] decrypt (byte[] p_Encrypted, PhysicianKey p_Key,LaboratoryCertificate p_Certificate) throws Exception
	{
	byte [] l_Signed;
		
	l_Signed = m_SmimeDecoder.decrypt (p_Encrypted, p_Key.getLabel());
	try {
		return m_SmimeDecoder.verify (l_Signed, p_Certificate, m_LaboManager);
		}
	catch (Exception p_Exception)
		{
		throw new DecryptException("Unable to verify the encrypted data", p_Exception, ImportInterface.UNABLE_TO_VERIFY, l_Signed);
		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
