/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.session.interfaces;

import lu.tudor.santec.gecamed.labo.ejb.entity.beans.LaboratoryCertificate;
import lu.tudor.santec.gecamed.labo.ejb.entity.beans.PhysicianKey;
import lu.tudor.santec.gecamed.labo.utils.PasswordEncrypter;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

public interface CryptoInterface
	{
	public void				setPasswordEncrypter	(PasswordEncrypter p_Encrypter);
		
	public PhysicianKey		getKeyByLabel			(String p_Label)		throws Exception;
	
	public void				setupKeystore			(PhysicianKey	p_Key, String p_KeyPassword) throws Exception;
	
	public byte[]			decrypt					(byte[] p_Encrypted, PhysicianKey p_Key, LaboratoryCertificate p_Certificate) throws Exception;
	}
