/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.session.interfaces;

import java.util.Collection;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.labo.ejb.entity.beans.Connection;
import lu.tudor.santec.gecamed.labo.ejb.entity.beans.MasterPassword;
import lu.tudor.santec.gecamed.labo.ejb.entity.beans.PhysicianKey;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

@Remote
public interface KeyChainInterface
	{

//***************************************************************************
//* Interface	  					                                        *
//***************************************************************************
	
	public MasterPassword		   getMasterPasswordByOfficeId  (Integer p_OfficeId)	    throws Exception;
		
	public MasterPassword		   saveMasterPassword			(MasterPassword p_Password) throws Exception;
	
	public Collection<Connection>  getConnectionsByOfficeId     (Integer p_OfficeId)    	throws Exception;
		
	public Collection<Connection>  getConnectionsByPhysicianId  (Integer p_PhysicianId) 	throws Exception;

	public Connection			   saveConnection   			(Connection p_Connection) 	throws Exception;
	
	public void					   deleteConnection 			(Connection p_Connection) 	throws Exception;

	public Collection<PhysicianKey> getKeysByOfficeId    		(Integer p_OfficeId)    	throws Exception;
		
	public Collection<PhysicianKey> getKeysByPhysicianId 		(Integer p_PhysicianId) 	throws Exception;

	public Integer					isValidKey  				(PhysicianKey p_Key, String p_Password);
	
	public PhysicianKey			    saveKey     				(PhysicianKey p_Key) 		throws Exception;
	
	public void					    deleteKey   				(PhysicianKey p_Key) 		throws Exception;

//***************************************************************************
//* End of Interface														*
//***************************************************************************
	
	}
