/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.ejb.session.interfaces;

import java.util.Collection;
import java.util.Date;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.labo.ejb.entity.beans.Result;
import lu.tudor.santec.gecamed.labo.ejb.entity.beans.ResultStub;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

@Remote
public interface ResultInterface
	{
	public static final int c_LaboratoryDependency 		= 1;
	public static final int c_PatientDependency 		= 2;
	public static final int c_PrescriberDependency 		= 3;
	public static final int c_ContactsDependency 		= 4;
	public static final int c_AnalysesDependency 		= 5;
	public static final int c_AntibiogramsDependency 	= 6;

//***************************************************************************
//* Interface	  					                                        *
//***************************************************************************

	public Collection <ResultStub> 	getResultStubsForPhysician 	(Physician p_Physician, Date p_BeginOfPeriod, Date p_EndOfPeriod) throws Exception;	
	
	public Collection <ResultStub> 	getResultStubsForPatient   	(Patient p_Patient) throws Exception;
	
	public Result			   		getResultById				(Integer p_Id) throws Exception;
	
	public Result 					getResultByIdFetchAll 		(Integer p_ResultId, boolean fetchPatient, boolean fetchPrescriber, 
																boolean fetchLabo) throws Exception;
	
	public Result			   		getResultByIncidentEntryId	(Integer p_IncidentEntryId) throws Exception;

	public Result					getAlreadyExistingResult	(Integer p_LaboratoryId, Integer p_PhysicianId, Integer p_ResultNumber) throws Exception; 
	
	public Result			   		fetchLazyDependency 	  	(Result p_Result, Integer p_Dependency) throws Exception;
	
	public Result			   		fetchLazyDependencies  		(Result p_Result, Collection <Integer> p_Dependencies) 	throws Exception;
		
//***************************************************************************
//* End of Interface														*
//***************************************************************************
		
	}
