/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.admin;

import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.core.gui.GECAMedTab;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.widgets.GenericListBox;
import lu.tudor.santec.gecamed.core.utils.Logger;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.labo.gui.LaboModule;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.office.ejb.session.beans.OfficeManagerBean;
import lu.tudor.santec.gecamed.office.ejb.session.interfaces.OfficeManagerInterface;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Relocalizer;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class LaboAdminPanel extends GECAMedTab implements ListSelectionListener,
														  Relocalizable
	{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private GenericListBox		m_PhysiciansListBox;
	private PhysicianListModel	m_Physicians;
	
	private ConnectionPanel		m_ConnectionPanel;
	private PhysicianKeyPanel	m_KeyPanel;
	
	private boolean				m_Initialized	= false;
	
	private static Logger	m_Logger = new Logger (LaboAdminPanel.class);
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	private final static String c_Columns				= "3dlu,fill:pref:grow,3dlu," + 
														  "fill:pref:grow,3dlu";
	
	private final static String c_Rows					= "3dlu,fill:pref," +
														  "3dlu,fill:pref:grow,3dlu";

	private final static String c_PhysicianColumns		= "3dlu,fill:pref:grow,3dlu";
	
	private final static String c_PhysicianRows			= "3dlu,fill:pref:grow,3dlu";
		
	private final static String c_Title					 = "LaboAdminPanel.Title";
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public LaboAdminPanel ()
	{
	this.setOpaque(false);
	Translatrix.addBundle("lu.tudor.santec.gecamed.labo.gui.resources.WidgetResources");
	this.setTitle(Translatrix.getTranslationString("LaboAdminPanel.Title"));
	this.setIcon (IconFetcher.getIcon (LaboModule.class,LaboModule.c_i32_Labo));
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

private OfficeManagerInterface	getOfficeInterface ()
	{
	OfficeManagerInterface	l_Interface = null;

	try {
		l_Interface = (OfficeManagerInterface) ManagerFactory.getRemote (OfficeManagerBean.class);
		} 
	catch (Exception p_Exception) 
		{
		m_Logger.log(Level.FATAL, "Failed to lookup OfficeManagerInterface!",p_Exception);
		}

	return l_Interface;
	}

//---------------------------------------------------------------------------

//private Collection <Physician> getPhysicians ()
//	{
//	OfficeManagerInterface	l_Interface = null;
//	Collection <Physician>	l_Physicians = null;
//	
//	l_Interface = this.getOfficeInterface();
//	if (l_Interface == null) return null;
//	
//	try	{
//		l_Physicians = l_Interface.getAllPhysicians();
//		}
//	catch (Exception p_Exception)
//		{
//		m_Logger.log(Level.FATAL, "Error while fetching all physicians from database!",p_Exception);			
//		}
//	
//	return l_Physicians;
//	}

//---------------------------------------------------------------------------

public void initialize ()
	{	
	CellConstraints		l_Constraints;
	FormLayout			l_Layout;

	l_Constraints  	= new CellConstraints();
	l_Layout		= new FormLayout(c_Columns, c_Rows);

	this.setLayout(l_Layout);
	this.add( this.buildPhysicianPanel (), l_Constraints.xywh(2, 2, 1, 3));
	
	m_ConnectionPanel = new ConnectionPanel ();
	
	this.add( m_ConnectionPanel, l_Constraints.xywh(4, 2, 1, 1));
	
	m_KeyPanel = new PhysicianKeyPanel ();
	
	this.add( m_KeyPanel, l_Constraints.xywh(4, 4, 1, 1));
	}

//---------------------------------------------------------------------------

private JPanel	buildPhysicianPanel ()
	{
	CellConstraints		l_Constraints;
	FormLayout			l_Layout;
	JPanel				l_PhysicianPanel;
		
	l_PhysicianPanel = new JPanel ();			
	
	l_Constraints  	= new CellConstraints();
	l_Layout		= new FormLayout(c_PhysicianColumns, c_PhysicianRows);

	l_PhysicianPanel.setLayout(l_Layout);	
	l_PhysicianPanel.setOpaque(false);
	
	m_Physicians = new PhysicianListModel ();
		
	m_PhysiciansListBox = new GenericListBox (m_Physicians);
	m_PhysiciansListBox.setRenderer (new PhysicianRenderer ());
	m_PhysiciansListBox.addListSelectionListener (this);
	
	m_Physicians.setPhysicians (GECAMedLists.getListCopy(Physician.class));
	
	m_PhysiciansListBox.packRows();
	m_PhysiciansListBox.packColumns();
	
	l_PhysicianPanel.add (m_PhysiciansListBox, 	l_Constraints.xywh(2, 2, 1, 1));

	return l_PhysicianPanel;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public void preparetoShowup ()
	{
	if (!m_Initialized) 
		{
		this.initialize ();
		m_Initialized = true;
		}
	}

//---------------------------------------------------------------------------

public void relocalize()
	{
	this.setTitle(Translatrix.getTranslationString(c_Title));
	
	
	Relocalizer.relocalizeChildren (this);		
	}

//---------------------------------------------------------------------------

public void valueChanged (ListSelectionEvent p_Event)
	{
	int			l_SelectedRow;
	Physician	l_Physician;
	
	if (!p_Event.getValueIsAdjusting())
		{
		if (p_Event.getSource().equals(m_PhysiciansListBox.getTable().getSelectionModel()))
			{
			l_SelectedRow = m_PhysiciansListBox.getSelectedRow();
			if (l_SelectedRow >= 0)
				{
				l_Physician = m_Physicians.getPhysicianAt(l_SelectedRow);
				m_ConnectionPanel.setPhysician(l_Physician);
				m_KeyPanel.setPhysician(l_Physician);
				}
			}
		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
