/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.admin;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.widgets.GenericRenderer;

public class PhysicianRenderer extends GenericRenderer
	{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static ImageIcon m_ServerIcon = IconFetcher.getScaledIcon (GECAMedModule.class,GECAMedIconNames.PHYSICIAN,16);
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value,
        										 boolean p_IsSelected, 
        										 boolean p_HasFocus, 
        										 int p_Row, int p_Column)
	{
	Component	l_Renderer;
	JLabel		l_Label = null;
	int			l_Column;
	
	l_Renderer = super.getTableCellRendererComponent(p_Table, p_Value, 
												     p_IsSelected, p_HasFocus, 
												     p_Row, p_Column);		
	if (l_Renderer instanceof JLabel)
		{
		l_Label = (JLabel) l_Renderer;
		l_Column = modelColumn (p_Table,p_Column);
		
		switch (l_Column)
			{
			case PhysicianListModel.c_NameColumn:
				
				l_Label.setIcon(m_ServerIcon);
				l_Label.setText((String)p_Value);
				l_Label.setHorizontalAlignment(SwingConstants.LEFT);
				break;
			
			case PhysicianListModel.c_UCMCodeColumn:
				
				l_Label.setIcon (null);
				l_Label.setText((String)p_Value);
				l_Label.setHorizontalAlignment(SwingConstants.LEFT);
				break;
			}	
		
		l_Renderer = l_Label;
		}
	
	return l_Renderer;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	}
