/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.event.result;

import lu.tudor.santec.gecamed.labo.ejb.entity.beans.Result;

public class ResultChangeEvent
	{
	private	Object					m_Source;
	private int						m_Type;
	private Integer					m_ResultId;
	private Result					m_Result;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	public static final int	c_None			   = 0;
	public static final int	c_SelectionChanged = 1;
	public static final int	c_ResultOpened     = 2;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Creates a new empty instance of ResultChangeEvent
 */
//---------------------------------------------------------------------------

public 	ResultChangeEvent ()
	{
	m_Source   		= null;
	m_Type	   		= c_None;
	m_Result 		= null;
	m_ResultId		= null;
	}

//---------------------------------------------------------------------------
/**
 * Creates a new instance of ResultChangeEvent initialized with the
 * specified properties.
 * @param p_Source specifies the object that generated to event.
 * @param p_Type specifies the type of event. Possible values are:
 * <ul>
 * <li>c_None : Nothing happened. (Hardly every used)</li>
 * <li>c_ResultSelectionChanged : Another result has been selected</li>
 * <li>c_ResultOpened           : A result has been opened</li>
  * </ul>
 * @param p_Result specifies the result this event refers to.
 */
//---------------------------------------------------------------------------

public ResultChangeEvent (Object p_Source, int p_Type, Result p_Result)
	{
	this.setSource(p_Source);
	this.setType(p_Type);
	this.setResult(p_Result);
	m_ResultId		= null;
	}

//---------------------------------------------------------------------------
/**
 * Creates a new instance of ResultChangeEvent initialized with the
 * specified properties.
 * @param p_Source specifies the object that generated to event.
 * @param p_Type specifies the type of event. Possible values are:
 * <ul>
 * <li>c_None : Nothing happened. (Hardly every used)</li>
 * <li>c_ResultSelectionChanged : Another result has been selected</li>
 * <li>c_ResultOpened           : A result has been opened</li>
  * </ul>
 * @param p_ResultId specifies the Id of the result this event refers to.
 */
//---------------------------------------------------------------------------

public ResultChangeEvent (Object p_Source, int p_Type, Integer p_ResultId)
	{
	this.setSource (p_Source);
	this.setType (p_Type);
	this.setResultId (p_ResultId);
	m_Result 		= null;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public Object getSource ()
	{
	return m_Source;
	}

//---------------------------------------------------------------------------

public void setSource (Object p_Source)
	{
	m_Source = p_Source;
	}

//---------------------------------------------------------------------------

public int getType ()
	{
	return m_Type;
	}

//---------------------------------------------------------------------------

public void setType (int p_Type)
	{
	if ((p_Type >= c_None) && (p_Type <= c_ResultOpened))
		{
		m_Type = p_Type;
		}
	else m_Type = c_None;
	}

//---------------------------------------------------------------------------

public Integer getResultId ()
	{
	return m_ResultId;
	}

//---------------------------------------------------------------------------

public void setResultId (Integer p_ResultId)
	{
	m_ResultId = p_ResultId;
	}

//---------------------------------------------------------------------------

public Result getResult ()
	{
	return m_Result;
	}

//---------------------------------------------------------------------------

public void setResult (Result p_Result)
	{
	m_Result = p_Result;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
