/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.event.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

//***************************************************************************
//* Class Definition                                                        *
//***************************************************************************

/**
 * The ResultEventDispatcher class basically encapsulates functionality
 * required to manage ResultChangeEvents Listeners. It offers methods to add and
 * remove ResultListeners as well as a method to call every registered
 * listener's resultChanged method.
 * @author nico.mack@tudor.lu
 */

public class ResultEventDispatcher 
{
	private Collection <ResultListener> m_ResultListeners;
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Creates a new instance of InvoiceEventDispatcher class.
 */
//---------------------------------------------------------------------------

public ResultEventDispatcher ()
	{
	m_ResultListeners = new ArrayList <ResultListener> ();
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
/**
 * Adds the specified ResultListener to the list of listeners to be
 * notified.
 * @param p_Listener specifies the ResultListener to be added
 */
//---------------------------------------------------------------------------

public void addResultListener (ResultListener p_Listener)
	{
	if ((m_ResultListeners == null) || (p_Listener == null)) return;
	
	m_ResultListeners.add(p_Listener);
	}

//---------------------------------------------------------------------------
/**
 * Removes the specified ResultListener from the list of listeners to be
 * notified.
 * @param p_Listener specifies the ResultListener to be removed
 */
//---------------------------------------------------------------------------

public void removeResultListener (ResultListener p_Listener)
	{
	if ((m_ResultListeners == null) || (p_Listener == null)) return;

	m_ResultListeners.remove(p_Listener);
	}

//---------------------------------------------------------------------------
/**
 * the notifyResultListeners will notify all the registered Listener's
 * about the result change represented by the specified result event.
 * Notification is done by calling every listener's <code>resultChanged</code>
 * method.
 * @param p_Event specifies the result change event to be passed to every
 * listener's <code>resultChanged</code> method.
 */
//---------------------------------------------------------------------------

public void notifyResultListeners (ResultChangeEvent p_Event)
	{
	Iterator <ResultListener>	l_ListenerIterator;
	ResultListener				l_Listener;
	
	if (m_ResultListeners == null) return;
	
	l_ListenerIterator = m_ResultListeners.iterator();
	while (l_ListenerIterator.hasNext())
		{
		l_Listener = l_ListenerIterator.next();
		l_Listener.resultChanged(p_Event);
		}
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End Of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

}

