/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.history;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import javax.persistence.Transient;
import javax.swing.tree.DefaultMutableTreeNode;

import lu.tudor.santec.gecamed.labo.ejb.entity.beans.ResultStub;

public class HistoryNode extends DefaultMutableTreeNode
	{
	/**
	 * 
	 */
	private Date		m_Day;
	private ResultStub	m_ResultStub;	
		
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	private static final long serialVersionUID = 1L;

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public static Date stripTime (Date p_OriginalDate)
	{
	GregorianCalendar	l_StrippedDate;

	if (p_OriginalDate == null) return null;

	l_StrippedDate = new GregorianCalendar ();
	l_StrippedDate.setTime (p_OriginalDate);
	l_StrippedDate.set (Calendar.HOUR_OF_DAY,0);
	l_StrippedDate.set (Calendar.MINUTE,0);
	l_StrippedDate.set (Calendar.SECOND,0);
	l_StrippedDate.set (Calendar.MILLISECOND,0);
	return l_StrippedDate.getTime();
	}
	
//---------------------------------------------------------------------------
/**
 * Given a date and a number of days, the method will return a date
 * the specified number of days earlier then the original date.
 * @param p_OriginalDate specifies the original date
 * @param p_NumberOfDays specifies the number of days to go back in time.
 * @return a date, p_NumberOfDays earlier than p_OriginalDate.
 */
//---------------------------------------------------------------------------

@Transient
public static Date getEarlierDate (Date p_OriginalDate, Integer p_NumberOfDays)
	{
	GregorianCalendar	l_EarlierDate;
	
	if (p_OriginalDate == null) return null;
	
	l_EarlierDate = new GregorianCalendar ();
	l_EarlierDate.setTime (p_OriginalDate);
	l_EarlierDate.add (Calendar.DAY_OF_MONTH, - p_NumberOfDays);
	
	return l_EarlierDate.getTime();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public Date getDay ()
	{
	return 	m_Day;
	}
	
//---------------------------------------------------------------------------

public void setDay (Date p_Day)
	{
	m_Day = stripTime (p_Day);
	}
	
//---------------------------------------------------------------------------

public ResultStub getResultStub ()
	{
	return 	m_ResultStub;
	}
	
//---------------------------------------------------------------------------

public void setResultStub (ResultStub p_ResultStub)
	{
	m_ResultStub = p_ResultStub;
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
