/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.history;

import java.awt.Component;

import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.labo.gui.LaboModule;

public class HistoryTreeCellRenderer extends DefaultTreeCellRenderer
	{
	private static final long serialVersionUID = 1L;

	private static ImageIcon m_ResultIcon = IconFetcher.getScaledIcon (LaboModule.class,LaboModule.c_i32_Labo,16);
	private static ImageIcon m_NodeIcon   = IconFetcher.getIcon (LaboModule.class,LaboModule.c_i16_HistoryNode);
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public HistoryTreeCellRenderer ()
	{
	this.setOpaque(true);	
	}
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public Component getTreeCellRendererComponent(JTree p_Tree, Object p_Value, 
											  boolean p_IsSelected, boolean p_IsExpanded, boolean p_IsLeaf, 
											  int p_Row, boolean p_HasFocus) 
	{
    HistoryNode					l_Node;
	Component 					l_Component;
//	DefaultTreeCellRenderer		l_Renderer;
//	Icon						l_Icon;
	
	l_Component = super.getTreeCellRendererComponent(p_Tree, p_Value, 
													 p_IsSelected, p_IsExpanded, p_IsLeaf,
													 p_Row, p_HasFocus);	
	
	if (l_Component instanceof DefaultTreeCellRenderer)
		{
//		l_Renderer = (DefaultTreeCellRenderer)l_Component;
		l_Node =     (HistoryNode) p_Value;
		if (p_IsLeaf) 
			{
			this.setIcon(m_ResultIcon);
			}
		else
			{
			//l_Icon = (p_IsSelected)?l_Renderer.getOpenIcon():l_Renderer.getClosedIcon();
			this.setIcon(m_NodeIcon);	
			this.setText(HistoryTreeTableModel.formatDayEntry (l_Node));
			}
		}
	
	return this;
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                             *
//***************************************************************************
//---------------------------------------------------------------------------

	}
