/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.patientview;

import java.awt.Component;

import javax.swing.JTable;

import lu.tudor.santec.gecamed.core.gui.utils.LineColorCellRenderer;
import lu.tudor.santec.gecamed.labo.gui.LaboModule;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;

public class PatientHistoryRenderer extends LineColorCellRenderer
	{
				
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
		
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private final static int c_FontSize = 9;

	private static String m_LaboIcon = LaboModule.class.getResource("resources/icons/"+ LaboModule.c_i32_Labo).toString();
		
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public Component getTableCellRendererComponent (JTable p_Table, Object p_Value, 
											   boolean p_IsSelected, boolean p_HasFocus, 
											   int p_Row, int p_Column) 
	{
	Component 		l_Component = null;	
	IncidentEntry	l_Entry;
	StringBuffer	l_HTML;
	
	if (p_Value instanceof IncidentEntry) 
		{
		l_Entry = (IncidentEntry) p_Value;		
		
		switch (p_Column)
			{
			case 2: l_Component = super.getTableCellRendererComponent(p_Table, "LA", 
															   		  p_IsSelected, p_HasFocus, 
															   		  p_Row, p_Column);
		    		break;

			case 3: l_HTML = new StringBuffer ();
		    		l_HTML.append("<html><span style=\"font-family:Arial;font-size:" + c_FontSize + "px;\">");
		    		l_HTML.append("<table border=\"0\"><tr vAlign=\"top\"><td>");
		    		l_HTML.append("<img src=\"" + m_LaboIcon +"\" width=\"24\" height=\"24\"></td>");
					
		    		if (l_Entry.getTextContent() != null) l_HTML.append("<td>" + l_Entry.getTextContent()+"</td>");

		    		l_HTML.append("</table></html>");

		    		l_Component = super.getTableCellRendererComponent(p_Table, l_HTML.toString(), 
		    												  		  p_IsSelected, p_HasFocus,
		    												  		  p_Row, p_Column);
		    		break;
			}
		}
	else l_Component = super.getTableCellRendererComponent(p_Table, p_Value, 
												    	   p_IsSelected, p_HasFocus, 
												    	   p_Row, p_Column);
	
	return l_Component;
	}	
		
//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
