/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.patientview;

import java.awt.Cursor;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.SwingWorker;
import lu.tudor.santec.gecamed.core.utils.Logger;
import lu.tudor.santec.gecamed.labo.ejb.entity.beans.Result;
import lu.tudor.santec.gecamed.labo.utils.ResultRenderer;
import lu.tudor.santec.i18n.Translatrix;

import org.apache.log4j.Level;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class ResultViewer extends JPanel
	{
	private JTextPane		m_HTMLViewer;
	private Result			m_Result;
	
	private SwingWorker		m_RenderWorker;
	
	private Logger	m_Logger = new Logger (ResultViewer.class);	

//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	private static final long serialVersionUID = 1L;
	
	private final static String c_Columns= "fill:pref:grow";		
	private final static String c_Rows=    "fill:pref:grow";

//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public ResultViewer ()
	{	
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
 	
	l_Constraints  	= new CellConstraints();
	l_Layout		= new FormLayout(c_Columns, c_Rows);
		
	this.setLayout (l_Layout); 
	this.setOpaque(false);

	m_HTMLViewer = new JTextPane ();
	m_HTMLViewer.setEditable (false);
    m_HTMLViewer.setContentType ("text/html; charset=utf-8");

	this.add(m_HTMLViewer,l_Constraints.xywh(1, 1, 1, 1));
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************

//---------------------------------------------------------------------------

Object RenderWorker ()
	{
	this.renderAsHTML();
	return "";
	}

//---------------------------------------------------------------------------

private void renderAsHTML ()
    {
    ResultRenderer	l_ResultRenderer;
    HTMLEditorKit   l_EditorKit;
    HTMLDocument    l_Document;
    StringReader    l_Reader;
     
    String          l_RenderedText; 
    int             l_Tries   = 0;
    boolean         l_Done    = false;

	l_ResultRenderer = new ResultRenderer (m_Result);
	l_ResultRenderer.setTemplate(ResultRenderer.c_HTMLFormat);
    l_ResultRenderer.setOffice(MainFrame.getCurrentOffice());
	
	try {
        l_RenderedText = new String (l_ResultRenderer.renderAsHTML(),"UTF-8");         
        }
    catch (UnsupportedEncodingException p_Exception)
        {
        l_RenderedText = new String ("");
        }
        
    l_EditorKit = (HTMLEditorKit) m_HTMLViewer.getEditorKit ();        
    l_Document  = (HTMLDocument)  m_HTMLViewer.getDocument ();
    l_Document.putProperty("IgnoreCharsetDirective", Boolean.TRUE);

    do  {
        try {
            l_Tries++;
            l_Reader = new StringReader(l_RenderedText);
            l_Document.remove(0, l_Document.getLength());
            l_EditorKit.read(l_Reader, l_Document, 0);                
            l_Done = true;
            }
        catch (ChangedCharSetException p_Exception)
            {
            m_Logger.log (Level.ERROR,"UnsupportedEncodingException while displaying Result");
            m_Logger.log (Level.INFO,p_Exception.getCharSetSpec());
            m_HTMLViewer.setContentType (p_Exception.getCharSetSpec().toLowerCase());                
            }
        catch (Exception p_Exception)    
            {
            m_Logger.log (Level.ERROR,"Exception while displaying Result",p_Exception);
            }
         }
    while (!l_Done && (l_Tries < 2));
    
    m_HTMLViewer.validate();
    }

//---------------------------------------------------------------------------

public void doRender ()
	{
	m_RenderWorker = new SwingWorker() 
	{
	public Object construct() 
		{
		return RenderWorker ();
		}
	public void start ()
		{
		MainFrame.getInstance().showMessage(Translatrix.getTranslationString("ResultViewer.RenderingResult"));
		MainFrame.getInstance().setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		super.start();
		}
	public void finished ()
		{
		MainFrame.getInstance().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		}
	public void interrupt ()
		{
		super.interrupt();
		MainFrame.getInstance().setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
		}
	};

	m_RenderWorker.start ();  	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public void clear ()
	{
	m_HTMLViewer.setText (null);
	m_HTMLViewer.validate();
	}

//---------------------------------------------------------------------------

public void renderResult (Result p_Result)
	{
	m_Result = p_Result;
	this.doRender();	
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
