/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.settings;

import java.awt.Color;

import lu.tudor.santec.gecamed.core.gui.utils.DefaultComboBoxRenderer;
import lu.tudor.santec.gecamed.labo.utils.LaboAdminSettings;
import lu.tudor.santec.i18n.Translatrix;


/**
 * a renderer for Insurance objects in comboboxes
 *
 * @author Nico MACK
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class DownloadRouteComboBoxRenderer extends DefaultComboBoxRenderer
	{
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	  
	private static final String	c_DownloadViaClient = "DownloadRouteComboBoxRenderer.DownloadViaClient";
	private static final String	c_DownloadViaServer = "DownloadRouteComboBoxRenderer.DownloadViaServer";
	
//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

public void setEnabled (boolean p_EnableIt)
	{
	if (p_EnableIt)
		 this.setForeground (Color.BLACK);
	else this.setForeground (Color.LIGHT_GRAY);
	}

//---------------------------------------------------------------------------

protected String getRenderString (Object p_Object)
    {
	int l_Style;
    
	if (p_Object instanceof Integer)
		{
		l_Style = ((Integer)p_Object).intValue();

		switch (l_Style)
			{
		case LaboAdminSettings.c_DownloadViaClient:
			return Translatrix.getTranslationString (c_DownloadViaClient);
			
		case LaboAdminSettings.c_DownloadViaServer:
			return Translatrix.getTranslationString (c_DownloadViaServer);
			}
		}
	return "";
    }

//***************************************************************************
//* End of Class															*
//***************************************************************************
}

