/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.labo.gui.settings;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.labo.gui.LaboModule;
import lu.tudor.santec.gecamed.labo.utils.LaboAdminSettings;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class LaboAdminSettingsPlugin extends SettingsPlugin implements Relocalizable
	{
	/**
	 * 
	 */
		
	private JPanel		m_DownloadSettingsPanel;
	
	private JLabel		m_DownloadRouteLabel;
	private JComboBox	m_DownloadRoute;
			
	private static final long serialVersionUID = 1L;
//---------------------------------------------------------------------------
//***************************************************************************
//* Constants	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	public static final String c_LaboSettingsName = LaboAdminSettings.c_ModuleName;

	public static final int c_DownloadRouteStationary  = LaboAdminSettings.c_DownloadViaServer;
	
	private final static String c_DownloadColumns	= 	"3dlu,fill:max(100dlu;pref)," +
														"3dlu,fill:max(50dlu;pref)," +
														"3dlu,fill:max(20dlu;pref),3dlu";

	private final static String c_DownloadRows		=   "3dlu,fill:pref,3dlu";

	private static final String c_Title					= "LaboAdminSettingsPlugin.Title";
	private static final String c_DownloadPanelTitle	= "LaboAdminSettingsPlugin.DownloadPanelTitle";
	private static final String c_DownloadRouteLabel	= "LaboAdminSettingsPlugin.DownloadRouteLabel";
	
//---------------------------------------------------------------------------
//***************************************************************************
//* Constructor	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------
	
public LaboAdminSettingsPlugin (String p_Name)
	{
	super(p_Name);
	this.init();
	}

//---------------------------------------------------------------------------
	
public LaboAdminSettingsPlugin ()
	{
	super(c_LaboSettingsName);
	this.init();
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* Primitives	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

private void init ()
	{
	this.setIcon (IconFetcher.getIcon (LaboModule.class,LaboModule.c_i32_Labo));
	this.setStationaryValues();
	buildPanel();	
	}

//---------------------------------------------------------------------------

private void buildPanel ()
	{
	CellConstraints	l_Constraints;
	FormLayout		l_Layout;
		
	l_Layout = new FormLayout(c_DownloadColumns, c_DownloadRows);
	l_Constraints  = new CellConstraints();
	
	m_DownloadSettingsPanel = createSubPanel("");
	m_DownloadSettingsPanel.setLayout(l_Layout);
	
	m_DownloadRouteLabel  = new JLabel ();
	m_DownloadRoute		  = new JComboBox ();
	m_DownloadRoute.setRenderer (new DownloadRouteComboBoxRenderer ());	
	this.populateDownloadRouteChooser();
	
	m_DownloadSettingsPanel.add (m_DownloadRouteLabel,  	l_Constraints.xywh(2, 2, 1, 1));
	m_DownloadSettingsPanel.add (m_DownloadRoute,   		l_Constraints.xywh(4, 2, 3, 1));
	
	this.addSubPanel(m_DownloadSettingsPanel);
	
	this.relocalize();
	}

//---------------------------------------------------------------------------

private void populateDownloadRouteChooser ()
	{
	m_DownloadRoute.addItem (Integer.valueOf (LaboAdminSettings.c_DownloadViaClient));
	m_DownloadRoute.addItem (Integer.valueOf (LaboAdminSettings.c_DownloadViaServer));
	}

//***************************************************************************
//* Class Body	                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

public void setStationaryValues() 
	{
	setStationary (LaboAdminSettings.c_DownloadRouteSetting, c_DownloadRouteStationary);
	}

//---------------------------------------------------------------------------

public void revertToDefaults() 
	{
	m_DownloadRoute.setSelectedItem	  ((Integer) this.getDefault (LaboAdminSettings.c_DownloadRouteSetting));
	}

//---------------------------------------------------------------------------

public void updateSettings() 
	{
	Integer	l_Route;
		
	l_Route = (Integer)m_DownloadRoute.getSelectedItem();	
	if (l_Route != null)
		{
		this.setValue (LaboAdminSettings.c_DownloadRouteSetting, l_Route);
		}
	}

//---------------------------------------------------------------------------

public void reflectSettings() 
	{
	m_DownloadRoute.setSelectedItem ((Integer)this.getValue (LaboAdminSettings.c_DownloadRouteSetting));
	}

//---------------------------------------------------------------------------
		
public void relocalize ()
	{
	this.setLabel (Translatrix.getTranslationString(c_Title));
	this.setSubPanelTitle (m_DownloadSettingsPanel, Translatrix.getTranslationString(c_DownloadPanelTitle));
	
	if (m_DownloadRouteLabel != null)
		m_DownloadRouteLabel.setText(Translatrix.getTranslationString(c_DownloadRouteLabel));
	}

//---------------------------------------------------------------------------
//***************************************************************************
//* End of Class                                                            *
//***************************************************************************
//---------------------------------------------------------------------------

	}
