<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format">

<xsl:include href="fo_common.xsl"/>

<xsl:template match="/">
 <fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
  <!--set page layout!-->
   <fo:layout-master-set>
     <fo:simple-page-master master-name="simple"
                   page-height="29.7cm" 
                   page-width="21cm"
                   margin-top="1cm" 
                   margin-bottom="1.5cm" 
                   margin-left="1cm" 
                   margin-right="1cm">
       <fo:region-body margin-top="1cm"/>
       <fo:region-before extent="1cm"/>
       <fo:region-after extent="1cm"/>
     </fo:simple-page-master>
   </fo:layout-master-set>

    <!--set page layout!-->
    <fo:page-sequence master-reference="simple">
        <fo:flow flow-name="xsl-region-body">
            <fo:block text-align="center" font-size="18pt" font-family="sans-serif" line-height="21pt" space-after.optimum="20pt">
                Laboratory Results
            </fo:block>
            
            <fo:table table-layout="fixed" width="100%">
                <fo:table-column column-width="proportional-column-width(1)"/>
                <fo:table-column column-width="0.8cm"/>
                <fo:table-column column-width="proportional-column-width(1)"/>
                <fo:table-body>
                    <fo:table-row>
                        <fo:table-cell>
                            <fo:block font-size="14pt" font-family="sans-serif" line-height="20pt" font-weight="bold">
                                <xsl:apply-templates select="File/Record/Body/Sender/Organisation/OrganisationName"/>
                            </fo:block>					
                            <fo:block font-family="sans-serif" font-size="10pt">
                    			<xsl:apply-templates select="File/Record/Body/Sender/Organisation/Address/Street"/>
                            </fo:block>		
                            <xsl:if test="File/Record/Body/Sender/Organisation/Address/POBox">
                                <fo:block  font-family="sans-serif" font-size="10pt">
                                    PO Box: <xsl:apply-templates select="File/Record/Body/Sender/Organisation/Address/POBox"/>	
                                </fo:block>					
                            </xsl:if>
			
                            <fo:block font-family="sans-serif" font-size="10pt" space-after.optimum="15pt" padding-top="0pt">
 								<xsl:if test="File/Record/Body/Sender/Organisation/Address/CountryCode">
		    						<xsl:call-template name="uppercase">
        								<xsl:with-param name="p_Text" select="substring(File/Record/Body/Sender/Organisation/Address/CountryCode,1,1)"/>
      								</xsl:call-template>
      								-
 								</xsl:if>
                                <xsl:apply-templates select="File/Record/Body/Sender/Organisation/Address/ZipCode"/>
                                &#xA0;
 								<xsl:call-template name="uppercase">
        							<xsl:with-param name="p_Text" select="File/Record/Body/Sender/Organisation/Address/Town"/>
      							</xsl:call-template>                            
      						</fo:block>					
						</fo:table-cell>
			
                        <fo:table-cell>
                            <fo:block>
                            </fo:block>					
						</fo:table-cell>
			
                        <fo:table-cell>
                            <fo:block font-family="sans-serif" font-size="10pt">
                                <fo:inline font-weight="bold">
                                    Contact:
								</fo:inline>			
 								<xsl:call-template name="uppercase">
        							<xsl:with-param name="p_Text" select="File/Record/Body/Sender/Organisation/ContactPerson/LastName"/>
      							</xsl:call-template>
 								&#xA0;
 								<xsl:apply-templates select="File/Record/Body/Sender/Organisation/ContactPerson/FirstName"/>
                           </fo:block>												
						
                            <fo:block font-family="sans-serif" font-size="10pt">
                                <xsl:apply-templates select="File/Record/Body/Sender/Organisation/ContactPerson/Function"/>
                            </fo:block>
                                                
                            <xsl:if test="File/Record/Body/Sender/Organisation/Phone">
                                <fo:block font-family="sans-serif" font-size="10pt">
                                    <fo:inline font-weight="bold">
                                        Phone:
                                    </fo:inline>			
                                    <xsl:apply-templates select="File/Record/Body/Sender/Organisation/Phone"/>
                                </fo:block>
                            </xsl:if>

                            <xsl:if test="File/Record/Body/Sender/Organisation/GSM">
                                <fo:block font-family="sans-serif" font-size="10pt">
                                    <fo:inline font-weight="bold">
                                        Mobile:
                                    </fo:inline>			
                                    <xsl:apply-templates select="File/Record/Body/Sender/Organisation/GSM"/>					
                                </fo:block>
                            </xsl:if>

                            <xsl:if test="File/Record/Body/Sender/Organisation/Fax">
                                <fo:block font-family="sans-serif" font-size="10pt">
                                    <fo:inline font-weight="bold">
                                        Fax:
                                    </fo:inline>			
                                    <xsl:apply-templates select="File/Record/Body/Sender/Organisation/Fax"/>				
                                </fo:block>
                            </xsl:if>

                            <xsl:if test="File/Record/Body/Sender/Organisation/EMail">
                                <fo:block font-family="sans-serif" font-size="10pt">
                                    <fo:inline font-weight="bold">
                                        EMail:
                                    </fo:inline>
                                    <xsl:apply-templates select="File/Record/Body/Sender/Organisation/EMail"/>				
                                </fo:block>
                            </xsl:if>
                                                
                        </fo:table-cell>
                    </fo:table-row>
                </fo:table-body>
            </fo:table>
		
            <fo:table table-layout="fixed" width="100%" padding-left="10pt">
                <fo:table-column/>
				<fo:table-column column-width="0.8cm"/>
				<fo:table-column/>
				<fo:table-body start-indent="5pt">
					<fo:table-row>
                    	<fo:table-cell background-color="#BBBBBB">
                        	<fo:block font-size="12pt" font-family="sans-serif" line-height="16pt" padding-top="3pt">
                            	PATIENT:
							</fo:block>					
                    	</fo:table-cell>
		
                    	<fo:table-cell background-color="#FFFFFF">
                        	<fo:block>
                        	</fo:block>					
                    	</fo:table-cell>
					
                    	<fo:table-cell  background-color="#BBBBBB">
                        	<fo:block font-size="12pt" font-family="sans-serif" line-height="16pt" padding-top="3pt">
                            	PRESCRIBER:
                        	</fo:block>					
                    	</fo:table-cell>
					</fo:table-row>
			
                	<fo:table-row>
                    	<fo:table-cell background-color="#DDDDDD" padding-top="5pt">
                        	<fo:block font-size="10pt" font-family="sans-serif" padding-bottom="5pt">
                            	<fo:inline font-weight="bold">
									<xsl:call-template name="uppercase">
        								<xsl:with-param name="p_Text" select="File/Record/Body/Patient/Person/LastName"/>
      								</xsl:call-template>
      								&#xA0;					
									<xsl:apply-templates select="File/Record/Body/Patient/Person/FirstName"/> 
                            	</fo:inline>
							</fo:block>	
			
                        	<fo:block font-size="10pt" font-family="sans-serif">	
                            	<fo:inline font-weight="bold">SSN: </fo:inline>
                            	<xsl:apply-templates select="File/Record/Header/SSNPatient"/>
							</fo:block>	

                        	<xsl:if test="File/Record/Body/Patient/Person/Refext"> 
                            	<fo:block font-size="10pt" font-family="sans-serif">
                                	<fo:inline font-weight="bold">External Reference: </fo:inline> 
                                	<xsl:apply-templates select="File/Record/Body/Patient/Person/Refext"/>
                            	</fo:block>
                        	</xsl:if>
			
                        	<fo:block font-size="10pt" font-family="sans-serif" padding-top="5pt">
                            	<xsl:apply-templates select="File/Record/Body/Patient/Person/Address/Street"/>
							</fo:block>             

                        	<xsl:if test="File/Record/Body/Patient/Person/Address/POBox">
                            	<fo:block font-size="10pt" font-family="sans-serif">
                                	<fo:inline font-weight="bold">PO Box: </fo:inline>
									<xsl:apply-templates select="File/Record/Body/Patient/Person/Address/POBox"/>
                            	</fo:block>             
                        	</xsl:if>
			
                        	<fo:block font-size="10pt" font-family="sans-serif" padding-top="0pt">
								<xsl:if test="File/Record/Body/Patient/Person/Address/CountryCode">
   									<xsl:call-template name="uppercase">
     									<xsl:with-param name="p_Text" select="substring(File/Record/Body/Patient/Person/Address/CountryCode,1,1)"/>
   									</xsl:call-template>
   									-
								</xsl:if>
								<xsl:apply-templates select="File/Record/Body/Patient/Person/Address/ZipCode"/>
								&#xA0;
								<xsl:call-template name="uppercase">
     								<xsl:with-param name="p_Text" select="File/Record/Body/Patient/Person/Address/Town"/>
   								</xsl:call-template>
							</fo:block>             
						
  							<xsl:if test="File/Record/Body/Patient/Person/Phone">
                				<fo:block font-size="10pt" font-family="sans-serif" padding-top="9pt" space-after.optimum="7pt">
                    				<fo:inline font-weight="bold">
                        				Tél:
                        			</fo:inline>
                        			<xsl:apply-templates select="File/Record/Body/Patient/Person/Phone"/>
								</fo:block>             
							</xsl:if>
                    </fo:table-cell>
					
                    <fo:table-cell background-color="#FFFFFF">
                        <fo:block>
                        </fo:block>					
                    </fo:table-cell>

                    <fo:table-cell  background-color="#DDDDDD" padding-top="5pt">

                        <xsl:if test="File/Record/Body/Destination/Organisation/OrganisationName">
                            <fo:block font-weight="bold" font-size="10pt" font-family="sans-serif" >
                                <xsl:apply-templates select="File/Record/Body/Destination/Organisation/OrganisationName"/>
                            </fo:block>					
                        </xsl:if>

                        <fo:block font-size="10pt" font-family="sans-serif" padding-top="5pt">
                            <xsl:if test="File/Record/Body/Destination/Organisation/OrganisationName">
                                c/o
                            </xsl:if>
                            <fo:inline font-weight="bold">
 								<xsl:call-template name="uppercase">
									<xsl:with-param name="p_Text" select="File/Record/Body/Destination/Organisation/ContactPerson/LastName"/>
								</xsl:call-template>
								&#xA0;
								<xsl:apply-templates select="File/Record/Body/Destination/Organisation/ContactPerson/FirstName"/> 
                            </fo:inline>
                        </fo:block>	

                        <xsl:if test="File/Record/Body/Destination/Organisation/ContactPerson/Function">
                            <fo:block font-size="10pt" font-family="sans-serif">
                                <xsl:apply-templates select="File/Record/Body/Destination/Organisation/ContactPerson/Function"/>
                            </fo:block>					
                        </xsl:if>

                        <xsl:if test="File/Record/Header/CodePrescriterUCM">
                            <fo:block font-size="10pt" font-family="sans-serif" padding-top="5pt">
                                <fo:inline font-weight="bold">Physician Code: </fo:inline>
                                <xsl:apply-templates select="File/Record/Header/CodePrescriterUCM"/>
                            </fo:block>	
                        </xsl:if>			

                        <fo:block font-size="10pt" font-family="sans-serif" padding-top="5pt">
                            <xsl:apply-templates select="File/Record/Body/Destination/Organisation/Address/Street"/>
                        </fo:block>					

                        <xsl:if test="File/Record/Body/Destination/Organisation/Address/POBox">
                            <fo:block font-size="10pt" font-family="sans-serif">
                                <fo:inline font-weight="bold">PO Box: </fo:inline>
                                <xsl:apply-templates select="File/Record/Body/Destination/Organisation/Address/POBox"/>
                            </fo:block>					
                        </xsl:if>

                        <fo:block font-size="10pt" font-family="sans-serif">
 							<xsl:if test="File/Record/Body/Destination/Organisation/Address/CountryCode">
								<xsl:call-template name="uppercase">
									<xsl:with-param name="p_Text" select="substring(File/Record/Body/Destination/Organisation/Address/CountryCode,1,1)"/>
								</xsl:call-template>
								-
							</xsl:if>
							<xsl:apply-templates select="File/Record/Body/Destination/Organisation/Address/ZipCode"/> 
							&#xA0;
							<xsl:call-template name="uppercase">
								<xsl:with-param name="p_Text" select="File/Record/Body/Destination/Organisation/Address/Town"/>
							</xsl:call-template>						
                        </fo:block>					
                    </fo:table-cell>
                </fo:table-row>

                <fo:table-row>
                    <fo:table-cell background-color="#FFFFFF" border-collapse="separate" padding-left="5pt" padding-right="5pt">
                        <fo:block padding-top="9pt">
                            <fo:table table-layout="fixed" width="10%" border-style="solid" border-width="1pt" border-color="black">
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-column column-width="0.5cm"/>
                                <fo:table-column column-width="proportional-column-width(1)"/>

                                <fo:table-body>
                                    <fo:table-row padding-top="5pt">
                                        <fo:table-cell  start-indent="5pt">
                                            <fo:block  font-weight="bold" font-size="10pt">
                                                Examination Date:
                                            </fo:block>					
                                        </fo:table-cell>

                                        <fo:table-cell>
                                            <fo:block>						
                                            </fo:block>					
                                        </fo:table-cell>

                                        <fo:table-cell>
                                            <fo:block font-size="10pt" font-family="sans-serif">
                                                <xsl:value-of select="/File/Record/Body/ExaminationDate/Date/@day"/>.<xsl:value-of select="/File/Record/Body/ExaminationDate/Date/@month"/>.<xsl:value-of select="/File/Record/Body/ExaminationDate/Date/@year"/>
                                                <xsl:if test="/File/Record/Body/ExaminationDate/Date/@hour">
                                                    at
                                                    <xsl:value-of select="/File/Record/Body/ExaminationDate/Date/@hour"/>:<xsl:value-of select="/File/Record/Body/ExaminationDate/Date/@minute"/>
                                                </xsl:if>	
                                            </fo:block>					
                                        </fo:table-cell>
                                    </fo:table-row>
									<fo:table-row padding-top="3pt">
										<fo:table-cell  start-indent="5pt">
											<fo:block  font-weight="bold" font-size="10pt">
												Sample Date:
											</fo:block>					
										</fo:table-cell>

										<fo:table-cell>
											<fo:block>						
											</fo:block>					
										</fo:table-cell>

										<fo:table-cell>
											<fo:block font-size="10pt" font-family="sans-serif">
												<xsl:value-of select="/File/Record/Body/SpecimenDate/Date/@day"/>.<xsl:value-of select="/File/Record/Body/SpecimenDate/Date/@month"/>.<xsl:value-of select="/File/Record/Body/SpecimenDate/Date/@year"/>
												<xsl:if test="/File/Record/Body/SpecimenDate/Date/@hour">
													at
													<xsl:value-of select="/File/Record/Body/SpecimenDate/Date/@hour"/>:<xsl:value-of select="/File/Record/Body/SpecimenDate/Date/@minute"/>
												</xsl:if>	
											</fo:block>					
										</fo:table-cell>
									</fo:table-row>

									<fo:table-row padding-top="3pt">
										<fo:table-cell  start-indent="5pt">
											<fo:block  font-weight="bold" font-size="10pt" font-family="sans-serif">
												Prescription Date:
											</fo:block>					
										</fo:table-cell>

										<fo:table-cell>
											<fo:block>						
											</fo:block>					
										</fo:table-cell>

										<fo:table-cell>
											<fo:block font-size="10pt" font-family="sans-serif">
												<xsl:value-of select="/File/Record/Body/PrescriptionDate/Date/@day"/>.<xsl:value-of select="/File/Record/Body/PrescriptionDate/Date/@month"/>.<xsl:value-of select="/File/Record/Body/PrescriptionDate/Date/@year"/>
												<xsl:if test="/File/Record/Body/PrescriptionDate/Date/@hour">
													at
													<xsl:value-of select="/File/Record/Body/PrescriptionDate/Date/@hour"/>:<xsl:value-of select="/File/Record/Body/PrescriptionDate/Date/@minute"/>
												</xsl:if>	
											</fo:block>					
										</fo:table-cell>
									</fo:table-row>

                                </fo:table-body>
                            </fo:table>
			</fo:block>					
                    </fo:table-cell>
                    
                    <fo:table-cell background-color="#FFFFFF">
                        <fo:block>
                        </fo:block>					
                    </fo:table-cell>
					
                    <fo:table-cell  background-color="#DDDDDD">
                        <xsl:if test="File/Record/Body/Destination/Organisation/Phone">
                            <fo:block font-size="10pt" font-family="sans-serif" padding-top="1pt">
                                <fo:inline font-weight="bold">Phone: </fo:inline>			
				<xsl:apply-templates select="File/Record/Body/Destination/Organisation/Phone"/>
                            </fo:block>					
			</xsl:if>
						
			<xsl:if test="File/Record/Body/Destination/Organisation/GSM">
                            <fo:block font-size="10pt" font-family="sans-serif" padding-top="1pt">
                                <fo:inline font-weight="bold">Mobile: </fo:inline>			
				<xsl:apply-templates select="File/Record/Body/Destination/Organisation/GSM"/>
                            </fo:block>					
			</xsl:if>
						
			<xsl:if test="File/Record/Body/Destination/Organisation/Fax">
                            <fo:block font-size="10pt" font-family="sans-serif" padding-top="1pt">
                                <fo:inline font-weight="bold">Fax: </fo:inline>			
				<xsl:apply-templates select="File/Record/Body/Destination/Organisation/Fax"/>
                            </fo:block>					
			</xsl:if>
						
			<xsl:if test="File/Record/Body/Destination/Organisation/EMail">
                            <fo:block font-size="10pt" font-family="sans-serif" padding-top="1pt">
                                <fo:inline font-weight="bold">EMail: </fo:inline>			
				<xsl:apply-templates select="File/Record/Body/Destination/Organisation/EMail"/>
                            </fo:block>					
			</xsl:if>
                    </fo:table-cell>
                </fo:table-row>
                </fo:table-body>
            </fo:table>
	
            <fo:block padding-top="3pt">	  
                <fo:table width="100%" border-collapse="separate" table-layout="fixed" border-top-color="black" border-top-width="2pt" border-top-style="solid" border-bottom-color="black" border-bottom-width="2pt" border-bottom-style="solid">
                    <fo:table-column column-width="proportional-column-width(1)"/>
                    <fo:table-column column-width="proportional-column-width(1)"/>
                    <fo:table-body>
                        <fo:table-row>
                            <fo:table-cell padding-top="3pt" padding-bottom="3pt">
                                <fo:block  font-weight="bold" font-size="12pt">
                                    Results
				</fo:block>					
                            </fo:table-cell>
			
                            <fo:table-cell>
                                <fo:block text-align="end" font-size="10pt" padding-top="3pt" padding-bottom="3pt">
                                    <fo:inline font-weight="bold">Reference Number: </fo:inline> 
                                    <xsl:apply-templates select="/File/Record/Body/ReferenceNumber"/> 
				</fo:block>					
                            </fo:table-cell>
                        </fo:table-row>
                       
                        <fo:table-row border-bottom-color="black" border-bottom-width="2pt" border-bottom-style="solid">
                            <fo:table-cell number-columns-spanned="2">
                                <xsl:if test="File/Record/Body/RecordComments">    
                                    <fo:block font-size="10pt">
                                        <fo:inline font-weight="bold">Remark: </fo:inline>                      
                                        <xsl:choose>
                                            <xsl:when test="$c_TemplateMode = 'LINEBREAKS'">
                                                <xsl:call-template name="break">
                                                    <xsl:with-param name="p_Text" select="File/Record/Body/RecordComments"/>
                                                </xsl:call-template>					
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:apply-templates select="File/Record/Body/RecordComments"/>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </fo:block>					
                                </xsl:if>
                            </fo:table-cell>
                        </fo:table-row>   
                    
                    </fo:table-body>
		</fo:table>
            </fo:block>					

            <fo:block>
                <fo:table width="100%" border-collapse="separate" table-layout="fixed" border-bottom-color="black" border-bottom-width="2pt" border-bottom-style="solid">
                    <fo:table-column column-width="auto"/>
                    <fo:table-column column-width="auto"/>
                    <fo:table-column column-width="auto"/>
                    <fo:table-column column-width="auto"/>
                    <fo:table-column column-width="auto"/>
                    <fo:table-column column-width="auto"/>
                    <fo:table-column column-width="auto"/>				
                    <!-- <fo:table-column column-width="proportional-column-width(1)"/>
                    <fo:table-column column-width="proportional-column-width(5)"/>
                    <fo:table-column column-width="proportional-column-width(2)"/>
                    <fo:table-column column-width="proportional-column-width(1)"/>
                    <fo:table-column column-width="proportional-column-width(2)"/>
                    <fo:table-column column-width="proportional-column-width(3)"/>
                    <fo:table-column column-width="proportional-column-width(1)"/>	-->			
                    <fo:table-body>
                    
                        <fo:table-row>
                            <fo:table-cell></fo:table-cell>
                            <fo:table-cell><fo:block font-weight="bold" text-align="left"   font-size="10pt" padding-top="3pt" padding-bottom="3pt">Description (LOINC)</fo:block></fo:table-cell>
                            <fo:table-cell><fo:block font-weight="bold" text-align="right"  font-size="10pt" padding-top="3pt" padding-bottom="3pt">Value</fo:block></fo:table-cell>
                            <fo:table-cell><fo:block font-weight="bold" text-align="center" font-size="10pt" padding-top="3pt" padding-bottom="3pt">Unit</fo:block></fo:table-cell>
                            <fo:table-cell><fo:block font-weight="bold" text-align="center" font-size="10pt" padding-top="3pt" padding-bottom="3pt">Reference</fo:block></fo:table-cell>
                            <fo:table-cell><fo:block font-weight="bold" text-align="center" font-size="10pt" padding-top="3pt" padding-bottom="3pt">Previous Value</fo:block></fo:table-cell>
                            <fo:table-cell><fo:block font-weight="bold" text-align="center" font-size="10pt" padding-top="3pt" padding-bottom="3pt">Alarm</fo:block></fo:table-cell>
                        </fo:table-row>	

                        <xsl:for-each select="File/Record/Result">

                            <xsl:if test="Title">
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="7">
                                        <fo:block font-size="12pt" font-weight="bold">
                                            <xsl:apply-templates select="Title"/>
                                        </fo:block>	
                                    </fo:table-cell>
                                </fo:table-row>				
                            </xsl:if>

                            <xsl:if test="SubTitle">
                                <fo:table-row>
                                    <fo:table-cell number-columns-spanned="7">
                                        <fo:block font-size="11pt" font-weight="bold">
                                            <xsl:apply-templates select="SubTitle"/>
                                        </fo:block>	
                                    </fo:table-cell>
                                </fo:table-row>				
                            </xsl:if>

                            <xsl:choose>
                                <xsl:when test="Alarm[not(. = '')]">
                                    <xsl:if test="Alarm[(. = '+')]">
                                        <xsl:call-template name="displayDetailedResultLine">
                                            <xsl:with-param name="p_Result" select="."/>
                                            <xsl:with-param name="p_ResultTableLabel">Complex Result</xsl:with-param>
                                            <xsl:with-param name="p_ResultCommentLabel">Remark</xsl:with-param>
                                            <xsl:with-param name="p_Background">#fff0f0</xsl:with-param>
                                            <xsl:with-param name="p_Foreground">#b0171e</xsl:with-param>
                                            <xsl:with-param name="p_FontWeight">normal</xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:if>    
                                    <xsl:if test="Alarm[(. = '-')]">
                                        <xsl:call-template name="displayDetailedResultLine">
                                            <xsl:with-param name="p_Result" select="."/>
                                            <xsl:with-param name="p_ResultTableLabel">Complex Result</xsl:with-param>
                                            <xsl:with-param name="p_ResultCommentLabel">Remark</xsl:with-param>
                                            <xsl:with-param name="p_Background">#f0f0ff</xsl:with-param>
                                            <xsl:with-param name="p_Foreground">#1e17b0</xsl:with-param>
                                            <xsl:with-param name="p_FontWeight">normal</xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:if>    
                                    <xsl:if test="Alarm[(. = '!')]">
                                        <xsl:call-template name="displayDetailedResultLine">
                                            <xsl:with-param name="p_Result" select="."/>
                                            <xsl:with-param name="p_ResultTableLabel">Complex Result</xsl:with-param>
                                            <xsl:with-param name="p_ResultCommentLabel">Remark</xsl:with-param>
                                            <xsl:with-param name="p_Background">#ffffc0</xsl:with-param>
                                            <xsl:with-param name="p_Foreground">#2f2f2f</xsl:with-param>
                                            <xsl:with-param name="p_FontWeight">bold</xsl:with-param>
                                        </xsl:call-template>
                                    </xsl:if>    
                                </xsl:when>
                                <xsl:otherwise>	
                                    <xsl:call-template name="displayDetailedResultLine">
                                        <xsl:with-param name="p_Result" select="."/>
                                        <xsl:with-param name="p_ResultTableLabel">Complex Result</xsl:with-param>
                                        <xsl:with-param name="p_ResultCommentLabel">Remark</xsl:with-param>
                                        <xsl:with-param name="p_Background">#ffffff</xsl:with-param>
                                        <xsl:with-param name="p_Foreground">#000000</xsl:with-param>
                                        <xsl:with-param name="p_FontWeight">normal</xsl:with-param>
                                    </xsl:call-template>
                                </xsl:otherwise>
                            </xsl:choose>
                        </xsl:for-each>
                    </fo:table-body>
                </fo:table>
            </fo:block>

            <xsl:for-each select="File/Record/Bacteriology">
                            
                <fo:block font-weight="bold" padding-top="5pt" padding-bottom="5pt" font-size="12pt" text-align="left">
                    <xsl:apply-templates select="Title"/>
                </fo:block>    
                        
                <fo:block font-weight="bold" padding-top="3pt" padding-bottom="3pt" font-size="11pt" text-align="left">
                    Cultures
                </fo:block>    
                        
                <fo:block>
                    <fo:table width="auto" border-collapse="separate" table-layout="fixed">
                        <fo:table-column column-width="proportional-column-width(1)"/>
                        <fo:table-column column-width="proportional-column-width(5)"/>
                        <fo:table-column column-width="proportional-column-width(2)"/>
                        <fo:table-column column-width="proportional-column-width(2)"/>
		        <fo:table-body>
                            <xsl:for-each select="Culture">
                                <fo:table-row>
                                    <fo:table-cell  padding-top="2pt" padding-bottom="2pt">
                                        <fo:block text-align="left" font-size="10pt">
                                            <xsl:apply-templates select="CultureID"/>
                                        </fo:block>    
                                    </fo:table-cell>

                                    <fo:table-cell  padding-top="2pt" padding-bottom="2pt">
                                        <fo:block text-align="left" font-size="10pt">
                                            <xsl:apply-templates select="CultureName"/>
                                        </fo:block>    
                                    </fo:table-cell>
                                        
                                    <fo:table-cell padding-right="2pt" padding-top="2pt" padding-bottom="2pt">
                                        <fo:block wrap-option="no-wrap" text-align="right" font-size="10pt">
                                            <xsl:apply-templates select="CultureConcentration"/>
                                        </fo:block>    
                                    </fo:table-cell>
                                        
                                    <fo:table-cell padding-left="2pt" padding-top="2pt" padding-bottom="2pt">
                                        <fo:block wrap-option="no-wrap" text-align="left" font-size="10pt">
                                            <xsl:apply-templates select="Unit"/>
                                        </fo:block>    
                                    </fo:table-cell>
                                </fo:table-row>       
                            </xsl:for-each>
                        </fo:table-body>	
                    </fo:table>
                </fo:block>    
                    
                <fo:block font-weight="bold" padding-top="3pt" padding-bottom="3pt" font-size="11pt" text-align="left">
                    Antibiogram
                    <xsl:if test="Unit">                            
                        <fo:block font-weight="plain" padding-top="3pt" padding-bottom="3pt" font-size="9pt" text-align="left">        
                            MIC values expressed in <xsl:apply-templates select="Unit"/>
                        </fo:block>
                    </xsl:if>
                </fo:block>    
                        
                <fo:block>
                    <fo:table width="100%" border-collapse="separate" table-layout="fixed" border-bottom-color="black" border-bottom-width="2pt" border-bottom-style="solid">
                        <fo:table-column column-width="proportional-column-width(5)"/>
                        <fo:table-column column-width="proportional-column-width(2)"/>
                        <fo:table-column column-width="proportional-column-width(2)"/>
                        <fo:table-column column-width="proportional-column-width(2)"/>
                        <fo:table-column column-width="proportional-column-width(2)"/>
                        <fo:table-body>
                            <fo:table-row>
                                <fo:table-cell><fo:block font-weight="bold" text-align="left" font-size="10pt" padding-top="3pt" padding-bottom="3pt" background-color="#f0f0f0">Antibiotic</fo:block></fo:table-cell>
                                <fo:table-cell><fo:block font-weight="bold" text-align="left" font-size="10pt" padding-top="3pt" padding-bottom="3pt" background-color="#f0f0f0">1 MIC</fo:block></fo:table-cell>
                                <fo:table-cell><fo:block font-weight="bold" text-align="left" font-size="10pt" padding-top="3pt" padding-bottom="3pt" background-color="#f0f0f0">2 MIC</fo:block></fo:table-cell>
                                <fo:table-cell><fo:block font-weight="bold" text-align="left" font-size="10pt" padding-top="3pt" padding-bottom="3pt" background-color="#f0f0f0">3 MIC</fo:block></fo:table-cell>
                                <fo:table-cell><fo:block font-weight="bold" text-align="left" font-size="10pt" padding-top="3pt" padding-bottom="3pt" background-color="#f0f0f0">4 MIC</fo:block></fo:table-cell>
                            </fo:table-row>	

                            <xsl:for-each select="Antibiogram/Test">         
                                <xsl:call-template name="displayAntibiogramLine">
                                    <xsl:with-param name="p_Test"  select="."/>
                                    <xsl:with-param name="p_Count"><xsl:number count="Antibiogram/Test" format="1"/></xsl:with-param>
                                </xsl:call-template>    
                            </xsl:for-each>				
                        </fo:table-body>                            
                    </fo:table>
                </fo:block>
            </xsl:for-each>
 		
            <fo:block>	  
            	<fo:table width="100%" border-collapse="separate" table-layout="fixed">
                	<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-column column-width="proportional-column-width(1)"/>
					<fo:table-body>
                    	<fo:table-row>
                        	<fo:table-cell padding-top="3pt" padding-bottom="3pt">
                            	<fo:block  font-weight="bold" font-size="12pt">
                                	Examination Status:
									<fo:inline font-weight="normal">
                                    	<xsl:apply-templates select="/File/Record/Body/ExaminationStatus"/> 
									</fo:inline>
                               	</fo:block>					
							</fo:table-cell>
							
                            <fo:table-cell padding-top="3pt" padding-bottom="3pt">
                            	<fo:block  text-align="end" font-weight="bold" font-size="12pt">
                                	Record Status:
									<fo:inline font-weight="normal">
                                    	<xsl:apply-templates select="/File/Record/Body/RecordStatus"/> 
									</fo:inline>
                             	</fo:block>					
							</fo:table-cell>
                    	</fo:table-row>
					</fo:table-body>
                </fo:table>
            </fo:block>					
        
        </fo:flow>
  	</fo:page-sequence>
</fo:root>
</xsl:template>

</xsl:stylesheet>