<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:fo="http://www.w3.org/1999/XSL/Format">
<!-- fo_common.xsl -->


<xsl:variable name="c_TemplateMode" select="'LINEBREAKS'"/>
<!-- <xsl:variable name="c_TemplateMode" select="'Normal'"/> -->

<!-- ============================ -->
<!-- Display Detailed Result Line -->
<!-- ============================ -->

<xsl:template name="displayDetailedResultLine">
    <xsl:param name="p_Result"/>
    <xsl:param name="p_ResultTableLabel"/>
    <xsl:param name="p_ResultCommentLabel"/>
    <xsl:param name="p_Foreground"/>
    <xsl:param name="p_Background"/>
    <xsl:param name="p_FontWeight"/>
	<fo:table-row>	
		<fo:table-cell padding-top="5pt" padding-bottom="5pt" >	
			<fo:block font-size="10pt" text-align="left" color="{$p_Foreground}" background-color="{$p_Background}">
				<fo:inline font-weight="{$p_FontWeight}">
					<xsl:apply-templates select="CodeTestInternal"/>			
					<xsl:if test="CodeTestLOINC">
						<fo:inline font-style="italic">(<xsl:apply-templates select="CodeTestLOINC"/>)</fo:inline>
					</xsl:if>
				</fo:inline>
			</fo:block>
		</fo:table-cell>	
								
		<fo:table-cell padding-top="5pt" padding-bottom="5pt" >	
			<fo:block font-size="10pt" text-align="left" color="{$p_Foreground}" background-color="{$p_Background}">
				<fo:inline font-weight="{$p_FontWeight}">
					<xsl:apply-templates select="DescriptionInternal"/>
					<xsl:if test="DescriptionLOINC">
						<fo:inline font-style="italic">(<xsl:apply-templates select="DescriptionLOINC"/>)</fo:inline>
					</xsl:if>
				</fo:inline>
			</fo:block>
		</fo:table-cell>
						
		<fo:table-cell padding-top="5pt" padding-bottom="5pt" >
                    <fo:block font-size="10pt" text-align="right" wrap-option="wrap" color="{$p_Foreground}" background-color="{$p_Background}">
                        <xsl:choose>
                            <xsl:when test="$c_TemplateMode = 'LINEBREAKS'">
                                <xsl:call-template name="break">
                                    <xsl:with-param name="p_Text" select="ResultValue"/>
                                </xsl:call-template>					
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:apply-templates select="ResultValue" />
                            </xsl:otherwise>
                        </xsl:choose>
                    </fo:block>
		</fo:table-cell>
		
		<fo:table-cell padding-top="5pt" padding-bottom="5pt" >
			<fo:block font-size="10pt" text-align="center" wrap-option="no-wrap" color="{$p_Foreground}" background-color="{$p_Background}">
				<fo:inline font-weight="{$p_FontWeight}">
					<xsl:call-template name="superscript">
						<xsl:with-param name="p_Text" select="Unit"/>
					</xsl:call-template>&#xA0;
				</fo:inline>	
			</fo:block>
		</fo:table-cell>
		
		<fo:table-cell padding-top="5pt" padding-bottom="5pt" >
			<fo:block font-size="10pt" text-align="center" wrap-option="no-wrap" color="{$p_Foreground}" background-color="{$p_Background}">
				<fo:inline font-weight="{$p_FontWeight}"><xsl:apply-templates select="ReferenceValue"/></fo:inline>
			</fo:block>
		</fo:table-cell>
						
		<fo:table-cell padding-top="5pt" padding-bottom="5pt" >
			<fo:block font-size="10pt" text-align="center" wrap-option="no-wrap" color="{$p_Foreground}" background-color="{$p_Background}">
				<xsl:choose>
					<xsl:when test="PrecedingValue">
						<fo:inline font-weight="{$p_FontWeight}">
							<xsl:apply-templates select="PrecedingValue"/>
							(<xsl:apply-templates select="PrecedingDate/Date/@day"/>.<xsl:apply-templates select="PrecedingDate/Date/@month"/>.<xsl:apply-templates select="PrecedingDate/Date/@year"/>)
						</fo:inline>
					</xsl:when>
					<xsl:otherwise>&#xA0;</xsl:otherwise>
				</xsl:choose>		
			</fo:block>
		</fo:table-cell>
						
		<fo:table-cell padding-top="5pt" padding-bottom="5pt" >
			<fo:block font-size="10pt" text-align="center" wrap-option="no-wrap" color="{$p_Foreground}" background-color="{$p_Background}">
				<!-- <fo:external-graphic src="file://icn_warning.gif"/> -->
							
				<fo:inline font-weight="{$p_FontWeight}"><xsl:apply-templates select="Alarm"/></fo:inline>
			</fo:block>	
		</fo:table-cell>
	</fo:table-row>
	
	<xsl:if test="ResultTable[not(. = '')]">					
		<fo:table-row>
			<fo:table-cell></fo:table-cell>
			<fo:table-cell number-columns-spanned="6">
				<fo:block font-size="10pt" text-align="left" wrap-option="no-wrap" color="{$p_Foreground}" background-color="{$p_Background}">
					<fo:inline font-weight="{$p_FontWeight}">			
						<xsl:value-of select="$p_ResultTableLabel" />:&#xA0;<xsl:value-of select="ResultTable" />
					</fo:inline>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:if>

	<xsl:if test="ResultComments[not(. = '')]">					
		<fo:table-row>
			<fo:table-cell></fo:table-cell>
			<fo:table-cell number-columns-spanned="6">
				<fo:block font-size="10pt" text-align="left" wrap-option="wrap" color="{$p_Foreground}" background-color="{$p_Background}">
					<fo:inline font-weight="bold">
						<xsl:value-of select="$p_ResultCommentLabel" />
					</fo:inline>
					<fo:inline font-weight="{$p_FontWeight}">:&#xA0;
						<xsl:choose>
							<xsl:when test="$c_TemplateMode = 'LINEBREAKS'">
								<xsl:call-template name="break">
									<xsl:with-param name="p_Text" select="ResultComments"/>
								</xsl:call-template>					
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="ResultComments"/>
							</xsl:otherwise>
						</xsl:choose>
					</fo:inline>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:if>

</xsl:template>	

<!-- =========================== -->
<!-- Display Compact Result Line -->
<!-- =========================== -->

<xsl:template name="displayCompactResultLine">
    <xsl:param name="p_Result"/>
    <xsl:param name="p_Count"/>
    <xsl:param name="p_ResultTableLabel"/>
    <xsl:param name="p_ResultCommentLabel"/>
    <xsl:param name="p_Foreground"/>
    <xsl:param name="p_Background"/>
    <xsl:param name="p_FontWeight"/>
	<fo:table-row>	
		<xsl:choose>
			<xsl:when test="DescriptionInternal[. = '']">
				<fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt">
					<fo:block font-size="10pt" text-align="center" color="{$p_Foreground}" background-color="{$p_Background}"> 
						<xsl:value-of select="$p_Count"/>
					</fo:block>
				</fo:table-cell>
				
				<fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >
					<fo:block font-size="10pt" text-align="left" wrap-option="no-wrap" color="{$p_Foreground}" background-color="{$p_Background}">	
						<xsl:choose>
							<xsl:when test="$c_TemplateMode = 'LINEBREAKS'">
								<xsl:call-template name="break">
									<xsl:with-param name="p_Text" select="ResultValue"/>
								</xsl:call-template>					
							</xsl:when>
							<xsl:otherwise>
								<xsl:apply-templates select="ResultValue" />
							</xsl:otherwise>
						</xsl:choose>
					</fo:block>
				</fo:table-cell>					
			</xsl:when>	
			
			<xsl:otherwise>	
				<fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >							
					<fo:block font-size="10pt" text-align="center" color="{$p_Foreground}" background-color="{$p_Background}">
						<fo:inline font-weight="{$p_FontWeight}"><xsl:value-of select="$p_Count"/></fo:inline>
					</fo:block>
				</fo:table-cell>
					

				<fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >
					<fo:block font-size="10pt" text-align="left" wrap-option="no-wrap" color="{$p_Foreground}" background-color="{$p_Background}">
						<fo:inline font-weight="{$p_FontWeight}">
							<xsl:apply-templates select="DescriptionInternal" />
							<xsl:if test="DescriptionLOINC">
        						<fo:inline font-style="italic">&#xA0;(<xsl:apply-templates select="DescriptionLOINC" />)</fo:inline>
							</xsl:if>
						</fo:inline>					
					</fo:block>
				</fo:table-cell>        								
				
				<fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >
                                    <fo:block font-size="10pt" text-align="right" wrap-option="wrap" color="{$p_Foreground}" background-color="{$p_Background}">
                                        <fo:inline font-weight="{$p_FontWeight}">
                                            <xsl:choose>
                                                <xsl:when test="$c_TemplateMode = 'LINEBREAKS'">
                                                    <xsl:call-template name="break">
                                                        <xsl:with-param name="p_Text" select="ResultValue"/>
                                                    </xsl:call-template>					
                                                </xsl:when>
                                                <xsl:otherwise>
                                                    <xsl:apply-templates select="ResultValue" />
                                                </xsl:otherwise>
                                            </xsl:choose>
					</fo:inline>	
                                    </fo:block>
				</fo:table-cell>

				<fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >
					<fo:block font-size="10pt" text-align="center" wrap-option="no-wrap" color="{$p_Foreground}" background-color="{$p_Background}">
						<fo:inline font-weight="{$p_FontWeight}">
							<xsl:call-template name="superscript">
								<xsl:with-param name="p_Text" select="Unit"/>
							</xsl:call-template>&#xA0;
						</fo:inline>	
					</fo:block>
				</fo:table-cell>

				<fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >
					<fo:block font-size="10pt" text-align="center" wrap-option="no-wrap" color="{$p_Foreground}" background-color="{$p_Background}">
						<fo:inline font-weight="{$p_FontWeight}">
							<xsl:apply-templates select="ReferenceValue" />&#xA0;
						</fo:inline>	
					</fo:block>
				</fo:table-cell>

				<fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >
					<fo:block font-size="10pt" text-align="center" wrap-option="no-wrap" color="{$p_Foreground}" background-color="{$p_Background}">							
						<xsl:choose>
							<xsl:when test="PrecedingValue">
								<fo:inline font-weight="{$p_FontWeight}">
									<xsl:apply-templates select="PrecedingValue" />
									( <xsl:apply-templates select="PrecedingDate/Date/@day" />.<xsl:apply-templates select="PrecedingDate/Date/@month" />.<xsl:apply-templates select="PrecedingDate/Date/@year" /> )
								</fo:inline>
							</xsl:when>
							<xsl:otherwise>&#xA0;</xsl:otherwise>
						</xsl:choose>
					</fo:block>
				</fo:table-cell>        								

				<fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >
					<fo:block font-size="10pt" text-align="center" wrap-option="no-wrap" color="{$p_Foreground}" background-color="{$p_Background}">
						<fo:inline font-weight="{$p_FontWeight}">
							<xsl:apply-templates select="Alarm" />
						</fo:inline>	
					</fo:block>
				</fo:table-cell>
			</xsl:otherwise>
		</xsl:choose>
	</fo:table-row>
	<xsl:if test="ResultTable[not(. = '')]">
		<fo:table-row>	
			<fo:table-cell></fo:table-cell>
			<fo:table-cell number-columns-spanned="6" padding-top="3pt" padding-left="3pt" padding-bottom="3pt" padding-right="3pt">
				<fo:block font-size="10pt" text-align="left" color="{$p_Foreground}" background-color="{$p_Background}">
					<fo:inline font-weight="{$p_FontWeight}">			
						<xsl:value-of select="$p_ResultTableLabel" />:&#xA0;<xsl:value-of select="ResultTable" />
					</fo:inline>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:if>
	<xsl:if test="ResultComments[not(. = '')]">
		<fo:table-row>	
			<fo:table-cell></fo:table-cell>
			<fo:table-cell number-columns-spanned="6" padding-top="3pt" padding-left="3pt" padding-bottom="3pt" padding-right="3pt">
				<fo:block font-size="10pt" text-align="left" color="{$p_Foreground}" background-color="{$p_Background}">
					<fo:inline font-weight="bold">
						<xsl:value-of select="$p_ResultCommentLabel" />
					</fo:inline>
					<fo:inline font-weight="{$p_FontWeight}">:&#xA0;
						<xsl:choose>
							<xsl:when test="$c_TemplateMode = 'LINEBREAKS'">
								<xsl:call-template name="break">
									<xsl:with-param name="p_Text" select="ResultComments"/>
								</xsl:call-template>					
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="ResultComments"/>
							</xsl:otherwise>
						</xsl:choose>
					</fo:inline>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:if>
</xsl:template>	

<!-- ======================== -->
<!-- Display Antibiogram Line -->
<!-- ======================== -->

<xsl:template name="displayAntibiogramLine">
    <xsl:param name="p_Test"/>
    <xsl:param name="p_Count"/>
    
    <xsl:choose> 
        <xsl:when test="$p_Count mod 2">
            <fo:table-row>
                <fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >
                    <fo:block font-size="10pt" text-align="left" wrap-option="no-wrap" color="#000000" background-color="#ffffff">
                        <xsl:apply-templates select="Antibiotic"/>
                    </fo:block>
                </fo:table-cell>        
                        
                <xsl:for-each select="Reaction">
                    <xsl:choose>
                        <xsl:when test="Interpretation[(. = 'R')]">    
                            <fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >
                                <fo:block font-size="10pt" text-align="left" wrap-option="no-wrap" color="#b0171e" background-color="#fff0f0">
                                    <fo:inline font-weight="bold">    
                                        <xsl:apply-templates select="Interpretation"/>
                                        &#xA0;
                                        <xsl:apply-templates select="MIC"/>
                                        &#xA0;
                                        <xsl:apply-templates select="Unit"/>
                                    </fo:inline>
                                </fo:block>
                            </fo:table-cell>
                       </xsl:when>
                        <xsl:otherwise>
                            <fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >
                                <fo:block font-size="10pt" text-align="left" wrap-option="no-wrap" color="#000000" background-color="#ffffff">
                                    <xsl:apply-templates select="Interpretation"/>
                                    &#xA0;
                                    <xsl:apply-templates select="MIC"/>
                                    &#xA0;
                                    <xsl:apply-templates select="Unit"/>
                                </fo:block>
                            </fo:table-cell>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>        
             </fo:table-row>
        </xsl:when>
        <xsl:otherwise>
            <fo:table-row>
                <fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >
                    <fo:block font-size="10pt" text-align="left" wrap-option="no-wrap" color="#000000" background-color="#f0f0f0">
                        <xsl:apply-templates select="Antibiotic"/>
                    </fo:block>
                </fo:table-cell>        
                        
                <xsl:for-each select="Reaction">
                    <xsl:choose>
                        <xsl:when test="Interpretation[(. = 'R')]">    
                            <fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >
                                <fo:block font-size="10pt" text-align="left" wrap-option="no-wrap" color="#b0171e" background-color="#ffe0e0">
                                    <fo:inline font-weight="bold">    
                                        <xsl:apply-templates select="Interpretation"/>
                                        &#xA0;
                                        <xsl:apply-templates select="MIC"/>
                                        &#xA0;
                                        <xsl:apply-templates select="Unit"/>
                                    </fo:inline>
                                </fo:block>
                            </fo:table-cell>
                       </xsl:when>
                        <xsl:otherwise>
                            <fo:table-cell padding-top="3pt" padding-left="0pt" padding-bottom="3pt" padding-right="5pt" >
                                <fo:block font-size="10pt" text-align="left" wrap-option="no-wrap" color="#000000" background-color="#f0f0f0">
                                    <xsl:apply-templates select="Interpretation"/>
                                    &#xA0;
                                    <xsl:apply-templates select="MIC"/>
                                    &#xA0;
                                    <xsl:apply-templates select="Unit"/>
                                </fo:block>
                            </fo:table-cell>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>        
             </fo:table-row>
        </xsl:otherwise>
    </xsl:choose>        
</xsl:template>

<!-- ========= -->
<!-- Uppercase -->
<!-- ========= -->

<xsl:template name="uppercase">
   <xsl:param name="p_Text"/>
   <xsl:value-of select="translate($p_Text,'abcdefghijklmnopqrstuvwxyzéèêëàâäôöùüîï','ABCDEFGHIJKLMNOPQRSTUVWXYZÉÈÊËÀÂÄÔÖÙÜÎÏ')"/> 
</xsl:template>

<!-- =========== -->
<!-- Superscript -->
<!-- =========== -->

<xsl:template name="superscript">
   <xsl:param name="p_Text"/>
   	<xsl:choose>
   	<xsl:when test="contains($p_Text, '^')">
      	<fo:inline>
      		<xsl:value-of select="substring-before($p_Text, '^')"/>
      		<xsl:variable name="position" select="string-length(substring-before($p_Text, '^')) + 2"/>	
      		<!-- vertical-align is a workaround for apache fop which does not implement baseline-shift -->
      		<fo:inline vertical-align="super" font-size="6pt">
      			<xsl:value-of select="substring($p_Text, $position, 1)"/>
      		</fo:inline>
      		<xsl:value-of select="substring($p_Text, $position + 1)"/>
      	</fo:inline>
    </xsl:when>
    <xsl:otherwise>
    	<xsl:choose>
   			<xsl:when test="contains($p_Text, '.e')">
      			<fo:inline>
      				<xsl:value-of select="substring-before($p_Text, '.e')"/>
      				<xsl:variable name="position" select="string-length(substring-before($p_Text, '.e')) + 3"/>	
      				<!-- vertical-align is a workaround for apache fop which does not implement baseline-shift -->
      				<fo:inline vertical-align="super" font-size="6pt">
      					<xsl:value-of select="substring($p_Text, $position, 1)"/>
      				</fo:inline>
      				<xsl:value-of select="substring($p_Text, $position + 1)"/>
      			</fo:inline>
    		</xsl:when>
    		<xsl:otherwise>
    			<xsl:value-of select="$p_Text"/>
    		</xsl:otherwise>
   		</xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- ===== -->
<!-- Break -->
<!-- ===== -->

<xsl:template name="break">
   <xsl:param name="p_Text"/>
   <xsl:choose>
   <xsl:when test="contains($p_Text, '\.br\')">
      <xsl:value-of select="substring-before($p_Text, '\.br\')"/>
      <fo:block/>
      <xsl:call-template name="break">
          <xsl:with-param name="p_Text" select="substring-after($p_Text, '\.br\')"/>
      </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
		<xsl:choose>
   			<xsl:when test="starts-with($p_Text, '.br\')">
      			<br/>
      			<xsl:call-template name="break">
          			<xsl:with-param name="p_Text" select="substring-after($p_Text, '.br\')"/>
      			</xsl:call-template>
   			</xsl:when>
   			<xsl:otherwise>
				<xsl:value-of select="$p_Text"/>
   			</xsl:otherwise>
   		</xsl:choose>
   </xsl:otherwise>
   </xsl:choose>
</xsl:template>


</xsl:stylesheet>