<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
							  xmlns:xalan="http://xml.apache.org/xalan">
<!-- detailed_html_common.xsl -->

<xsl:variable name="c_TemplateMode" select="'LINEBREAKS'"/>
<!-- <xsl:variable name="c_TemplateMode" select="'Normal'"/> -->

<xsl:template name="ResultStyles">
	<style>
p
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#00000;  font-size :9pt;  font-weight :normal; }
h1 
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#00000;  font-size :12pt;  font-weight :bold;}
h2 
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#00000;  font-size :10pt;  font-weight :bold; display: inline;}
th
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#00000;  font-size :9pt;  font-weight :bold; }
th.inverse
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#ffffff;  background-color:#707070; font-size :9pt;  font-weight :bold; }
td.inverse
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#ffffff;  background-color:#707070; font-size :9pt;  font-weight :bold; }
td
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#00000;  font-size :9pt;  font-weight :normal; }
td.red
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#b02020;  background-color:#fff0f0; font-size :9pt;  font-weight :normal; }
td.green
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#20b020;  background-color:#f0fff0; font-size :9pt;  font-weight :normal; }
td.odd
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#000000;  background-color:#f0f0f0; font-size :9pt;  font-weight :normal; }
td.even
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#000000;  background-color:#ffffff; font-size :9pt;  font-weight :normal; }
div.alarm-over
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#b0171e;  background-color:#fff0f0; font-size :9pt;  font-weight :normal; }
div.alarm-under
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#1e17b0;  background-color:#f0f0ff; font-size :9pt;  font-weight :normal; }
div.alarm-pathologic
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#2f2f2f;  background-color:#ffffc0; font-size :9pt;  font-weight :bold; }
div.complex
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#00000;  background-color:#dddddd; font-size :9pt;  font-weight :normal; }
div.comment
{ font-family :Verdana, Arial, Helvetica, Sans-serif;  color :#00000;  background-color:#eeeeee; font-size :9pt;  font-weight :normal; }
tr.odd
{ background-color:#ffffff; }
tr.even
{ background-color:#f0f0f0; }
td.odd-resistant
{ color :#b0171e;  background-color:#fff0f0; }
td.even-resistant
{ color :#b0171e;  background-color:#ffe0e0; }

	</style>
</xsl:template>

<!-- ============================ -->
<!-- Display Detailed Result Line -->
<!-- ============================ -->

<xsl:template name="displayDetailedResultLine">
    <xsl:param name="p_Result"/>
    <xsl:param name="p_ResultTableLabel"/>
    <xsl:param name="p_ResultCommentLabel"/>
    <xsl:param name="p_Style"/>
        <tr>
            <td valign="top" align="center" nowrap="nowrap">
                <div class="{$p_Style}">
                    <xsl:apply-templates select="CodeTestInternal"/>
                        <xsl:if test="CodeTestLOINC">
                            <i>(<xsl:apply-templates select="CodeTestLOINC"/>)</i>
                        </xsl:if>
				</div>
            </td>
            <td valign="top"  align="left" nowrap="nowrap">
                <div class="{$p_Style}">
                    <xsl:apply-templates select="DescriptionInternal"/>
                        <xsl:if test="DescriptionLOINC">
                            &#xA0;<i>(<xsl:apply-templates select="DescriptionLOINC"/>)</i>
                        </xsl:if>
				</div>
            </td>
									
            <td valign="top"  align="right" nowrap="nowrap">
                <div class="{$p_Style}">
                    <xsl:choose>
                        <xsl:when test="$c_TemplateMode = 'LINEBREAKS'">
                            <xsl:call-template name="break">
                                <xsl:with-param name="p_Text" select="ResultValue"/>
                            </xsl:call-template>					
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:apply-templates select="ResultValue" />
                        </xsl:otherwise>
                    </xsl:choose>
                </div>
            </td>
            
            <td valign="top"  align="center" nowrap="nowrap">
            	<div class="{$p_Style}">
            		<xsl:call-template name="superscript">
						<xsl:with-param name="p_Text" select="Unit"/>
					</xsl:call-template>
            	</div>
            </td>
            <td valign="top"  align="right"  nowrap="nowrap"><div class="{$p_Style}"><xsl:apply-templates select="ReferenceValue"/></div></td>
            <td valign="top"  align="right"  nowrap="nowrap">
            <xsl:choose>    
                <xsl:when test="PrecedingValue">
                    <div class="{$p_Style}">
                        <xsl:apply-templates select="PrecedingValue"/> (<xsl:apply-templates select="PrecedingDate/Date/@day"/>.<xsl:apply-templates select="PrecedingDate/Date/@month"/>.<xsl:apply-templates select="PrecedingDate/Date/@year"/>)
                    </div>
                </xsl:when>
                <xsl:otherwise><div class="{$p_Style}">&#xA0;</div></xsl:otherwise>
            </xsl:choose>
            </td>
            <td valign="top"  align="center" nowrap="nowrap"><div class="{$p_Style}">
                <!-- img src="icn_warning.gif" alt=""/--><xsl:apply-templates select="Alarm"/></div>
            </td>
        </tr>
		
	<xsl:if test="ResultTable[not(. = '')]">
            <tr>
                <td></td>
                <td colspan="6">
                    <div class="{$p_Style}"><b><xsl:value-of select="$p_ResultTableLabel"/></b>: <xsl:value-of select="ResultTable"/></div>
                </td>
            </tr>
	</xsl:if>

	<xsl:if test="ResultComments[not(. = '')]">					
            <tr>
                <td></td>
		<td valign="top"  colspan="6">
                    <div class="{$p_Style}">
                        <b><xsl:value-of select="$p_ResultCommentLabel"/></b>: 
                        <xsl:choose>
                            <xsl:when test="$c_TemplateMode = 'LINEBREAKS'">
                                <xsl:call-template name="break">
                                    <xsl:with-param name="p_Text" select="ResultComments"/>
								</xsl:call-template>					
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="ResultComments"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </td>
            </tr>
	</xsl:if>
</xsl:template>	

<!-- =========================== -->
<!-- Display Compact Result Line -->
<!-- =========================== -->

<xsl:template name="displayCompactResultLine">
    <xsl:param name="p_Result"/>
    <xsl:param name="p_Count"/>
    <xsl:param name="p_ResultTableLabel"/>
    <xsl:param name="p_ResultCommentLabel"/>
    <xsl:param name="p_Style"/>
    <tr>
        <xsl:choose>
            <xsl:when test="DescriptionInternal[. = '']">
                <td valign="top" align="center" nowrap="nowrap">
                    <div class="{$p_Style}"><xsl:value-of select="$p_Count"/></div>
				</td>
				<td valign="top" colspan="6">
                    <div class="{$p_Style}"><xsl:apply-templates select="ResultValue" /></div>
				</td>
            </xsl:when>
													
            <xsl:otherwise>
                <td valign="top" align="center" nowrap="nowrap">
                    <div class="{$p_Style}"><xsl:value-of select="$p_Count"/></div>
				</td>
				<td valign="top"  align="left" nowrap="nowrap">
                    <div class="{$p_Style}">
                        <xsl:apply-templates select="DescriptionInternal" />
                        <xsl:if test="DescriptionLOINC">
                            &#xA0;<i>(<xsl:apply-templates select="DescriptionLOINC" />)</i>
                        </xsl:if>
                    </div>
				</td>
									
                <td valign="top" align="right" nowrap="nowrap">
                    <div class="{$p_Style}">
                        <xsl:choose>
                            <xsl:when test="$c_TemplateMode = 'LINEBREAKS'">
                                <xsl:call-template name="break">
                                    <xsl:with-param name="p_Text" select="ResultValue"/>
								</xsl:call-template>					
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:apply-templates select="ResultValue" />
                            </xsl:otherwise>
						</xsl:choose>
                    </div>
                </td>
			
                <td valign="top" align="center" nowrap="nowrap">
                    <div class="{$p_Style}">
                        <xsl:call-template name="superscript">
                            <xsl:with-param name="p_Text" select="Unit"/>
                        </xsl:call-template>
                    </div>
				</td>
				
                <td valign="top" align="right" nowrap="nowrap">
                    <div class="{$p_Style}">
                        <xsl:apply-templates select="ReferenceValue" />
                    </div>
                </td>
										
				<td valign="top" align="right" nowrap="nowrap">
                    <xsl:choose>
                        <xsl:when test="PrecedingValue">
                            <div class="{$p_Style}">
                                <xsl:apply-templates select="PrecedingValue" />( <xsl:apply-templates select="PrecedingDate/Date/@day" />.<xsl:apply-templates select="PrecedingDate/Date/@month" />.<xsl:apply-templates select="PrecedingDate/Date/@year" /> )
                            </div>
						</xsl:when>
						<xsl:otherwise>
                            <div class="{$p_Style}">&#xA0;</div>
                        </xsl:otherwise>
                    </xsl:choose>		
				</td>
									
				<td valign="top" align="center" nowrap="nowrap">
                    <div class="{$p_Style}">
                        <xsl:apply-templates select="Alarm" />
                    </div>
                </td>
            </xsl:otherwise>
		</xsl:choose>
	</tr>
	
	<xsl:if test="ResultTable[not(. = '')]">
    	<tr>
        	<td>&#xA0;</td>
			<td colspan="6">
            	<div class="{$p_Style}"><b><xsl:value-of select="$p_ResultTableLabel" />: </b><xsl:value-of select="ResultTable" /></div>
			</td>
        </tr>
	</xsl:if>
	
	<xsl:if test="ResultComments[not(. = '')]">					
    	<tr>
        	<td>&#xA0;</td>
			<td colspan="6">
            	<div class="{$p_Style}">
                	<b><xsl:value-of select="$p_ResultCommentLabel"/></b>: 
					<xsl:choose>
                    	<xsl:when test="$c_TemplateMode = 'LINEBREAKS'">
                        	<xsl:call-template name="break">
                            	<xsl:with-param name="p_Text" select="ResultComments"/>
							</xsl:call-template>					
                        </xsl:when>
                        <xsl:otherwise>
                        	<xsl:value-of select="ResultComments"/>
                        </xsl:otherwise>
					</xsl:choose>
             	</div>
			</td>
    	</tr>
	</xsl:if>
</xsl:template>

<!-- ======================== -->
<!-- Display Antibiogram Line -->
<!-- ======================== -->

<xsl:template name="displayAntibiogramLine">
    <xsl:param name="p_Test"/>
    <xsl:param name="p_Count"/>
    
    <xsl:choose> 
        <xsl:when test="$p_Count mod 2">
            <tr class="odd">
                <td>
                    <xsl:apply-templates select="Antibiotic"/>
                </td>
                <xsl:for-each select="Reaction">
                    <xsl:choose>
                        <xsl:when test="Interpretation[(. = 'R')]">    
                            <td class="odd-resistant">
                                <b><xsl:apply-templates select="Interpretation"/>
                                &#xA0;
                                <xsl:apply-templates select="MIC"/>
                                &#xA0;
                                <xsl:apply-templates select="Unit"/></b>
                            </td>
                        </xsl:when>
                        <xsl:otherwise>
                            <td>
                                <xsl:apply-templates select="Interpretation"/>
                                &#xA0;
                                <xsl:apply-templates select="MIC"/>
                                &#xA0;
                                <xsl:apply-templates select="Unit"/>
                            </td>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </tr>
        </xsl:when>
        <xsl:otherwise>
            <tr class="even">
                <td>
                    <xsl:apply-templates select="Antibiotic"/>
                </td>
                <xsl:for-each select="Reaction">
                    <xsl:choose>
                        <xsl:when test="Interpretation[(. = 'R')]">    
                            <td class="even-resistant">
                                <b><xsl:apply-templates select="Interpretation"/>
                                &#xA0;
                                <xsl:apply-templates select="MIC"/>
                                &#xA0;
                                <xsl:apply-templates select="Unit"/></b>
                            </td>
                        </xsl:when>
                        <xsl:otherwise>
                            <td>
                                <xsl:apply-templates select="Interpretation"/>
                                &#xA0;
                                <xsl:apply-templates select="MIC"/>
                                &#xA0;
                                <xsl:apply-templates select="Unit"/>
                            </td>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
            </tr>
        </xsl:otherwise>
    </xsl:choose>        
</xsl:template>

<!-- ========= -->
<!-- Uppercase -->
<!-- ========= -->

<xsl:template name="uppercase">
   <xsl:param name="p_Text"/>
   <xsl:value-of select="translate($p_Text,'abcdefghijklmnopqrstuvwxyzéèêëàâäôöùüîï','ABCDEFGHIJKLMNOPQRSTUVWXYZÉÈÊËÀÂÄÔÖÙÜÎÏ')"/> 
</xsl:template>

<!-- =========== -->
<!-- Superscript -->
<!-- =========== -->

<xsl:template name="superscript">
   <xsl:param name="p_Text"/>
   	<xsl:choose>
   	<xsl:when test="contains($p_Text, '^')">
      	<xsl:value-of select="substring-before($p_Text, '^')"/>
      	<xsl:variable name="position" select="string-length(substring-before($p_Text, '.e')) + 3"/>	
      	<sup>
      		<xsl:value-of select="substring($p_Text, $position, 1)"/>
      	</sup>
      	<xsl:value-of select="substring($p_Text, $position + 1)"/>
    </xsl:when>
    <xsl:otherwise>
    	<xsl:choose>
            <xsl:when test="contains($p_Text, '.e')">
                <xsl:value-of select="substring-before($p_Text, '.e')"/>
      		<xsl:variable name="position" select="string-length(substring-before($p_Text, '.e')) + 3"/>	
                    <sup>
                        <xsl:value-of select="substring($p_Text, $position, 1)"/>
                    </sup>
      		<xsl:value-of select="substring($p_Text, $position + 1)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$p_Text"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- ===== -->
<!-- Break -->
<!-- ===== -->

<xsl:template name="break">
    <xsl:param name="p_Text"/>
    <xsl:choose>
        <xsl:when test="contains($p_Text, '\.br\')">
            <xsl:value-of select="substring-before($p_Text, '\.br\')"/>
            <br/>
            <xsl:call-template name="break">
                <xsl:with-param name="p_Text" select="substring-after($p_Text, '\.br\')"/>
            </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
            <xsl:choose>
                <xsl:when test="starts-with($p_Text, '.br\')">
                    <br/>
                    <xsl:call-template name="break">
                        <xsl:with-param name="p_Text" select="substring-after($p_Text, '.br\')"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="$p_Text"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

</xsl:stylesheet>