package lu.tudor.santec.gecamed.labo.utils;

import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.labo.ejb.session.beans.LaboratoryBean;
import lu.tudor.santec.gecamed.labo.ejb.session.interfaces.ImportInterface;
import lu.tudor.santec.gecamed.labo.ejb.session.interfaces.LaboratoryInterface;
import lu.tudor.santec.i18n.Translatrix;


public class DecryptException extends Exception
{
	private static final long serialVersionUID = 1L;
	
	public static final int STATE_1 = 1;
	public static final int STATE_2 = 2;
	public static final int STATE_3 = 3;
	public static final int STATE_4 = 4;
	public static final int STATE_5 = 5;
	public static final int STATE_6 = 6;
	public static final int STATE_7 = 7;
	public static final int STATE_8 = 8;
	public static final int STATE_9_NO_KEY_STORE = 9;
	public static final int STATE_10 = 10;
	public static final int STATE_11 = 11;
	public static final int STATE_12 = 12;
	public static final int STATE_13 = 13;
	
	
	private final String state;
	
	private byte[]	failedResultData;
	
	private String	failedResultName;
	
	private String	loggedPath;
	
	
	
	public DecryptException (String state)
	{
		this(null, null, state);
	}
	
	
	public DecryptException (Throwable cause)
	{
		this(null, cause, null);
	}
	
	
	public DecryptException (String message, String state)
	{
		this(message, null, state);
	}
	
	
	public DecryptException (String message, Throwable cause, String state)
	{
		this(message, cause, state, null);
	}
	
	
	public DecryptException (String message, Throwable cause, String state, byte[] failedResultData)
	{
		super(message, cause);
		if (state == null)
			this.state = ImportInterface.UNEXPECTED_EXCEPTION;
		else
			this.state = state;
		
		this.failedResultData	= failedResultData;
	}
	
	
	public String getState ()
	{
		return state;
	}
	
	
	public void setFailedResultFileName (String fileName)
	{
		this.failedResultName = fileName;
	}
	
	
	// public void showErrorMessage ()
	// {
	// String msg;
	//
	// if (state != null)
	// msg = Translatrix.getTranslationString(state);
	// // msg = "Error code " + state;
	// else msg = super.getMessage();
	//
	// FormEditorDialog.showMessageDialog (MainFrame.getInstance(),
	// "Labo Error", msg, FormEditorDialog.OK_BUTTON_MODE);
	// }
	
	@Override
	public String getMessage ()
	{
		StringBuffer message = new StringBuffer(Translatrix.getTranslationString(state));
		
		if (state.equals(ImportInterface.UNEXPECTED_EXCEPTION))
			message.append("<br>").append(super.getMessage());
		
		return message.toString();
	}
	
	
	public String logFailedResult ()
	{
		LaboratoryInterface laboManager	= (LaboratoryInterface) ManagerFactory.getRemote(LaboratoryBean.class);
		loggedPath	= logFailedResult(laboManager);
		
		return loggedPath;
	}


	public String logFailedResult (LaboratoryInterface laboManager)
	{
		if (failedResultData != null && failedResultName != null)
		{
			return laboManager.saveFailedResultImport(failedResultData, failedResultName, getMessage(), getCause());
		}
		else
		{
			return null;
		}
	}
}
