/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.letter.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

@javax.persistence.NamedQueries( {
		@NamedQuery(name = Letter.FIND_BY_INCIDENTENTRY_ID, query = "SELECT OBJECT(o) FROM Letter o WHERE o.incidentEntryID = :incidententry_id"),
		@NamedQuery(name = Letter.FIND_TYPES, query = "SELECT DISTINCT o.type FROM Letter o ORDER BY type ASC")
		})
@Entity
@Table(name = "letters", schema = "letter")
/*
 * Bean that represents a row in the table "letter.letters" 
 */
public class Letter extends GECAMedEntityBean implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// Static fields

	public static final String FIND_BY_INCIDENTENTRY_ID = "findAllByIncedentId";

	public static final String FIND_TYPES = "findTypesLetter";


	// Attributes of a letter, accessed by getter/setter methods
	private int incidentEntryID;

	private String mimetype;

	private String type;

	@Column(name = "incident_entry_id")
	public Integer getIncidentEntryID() {
		return incidentEntryID;
	}

	public void setIncidentEntryID(Integer incidentEntryId) {
		this.incidentEntryID = incidentEntryId;
	}

	@Column(name = "mime_type")
	public String getMimetype() {
		return mimetype;
	}

	public void setMimetype(String mimetype) {
		this.mimetype = mimetype;
	}

	@Column(name = "type")
	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
}
